/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.module.maven.commandsecurityplugin;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.module.maven.commandsecurityplugin.CommandAuthorizationInfo;

public class OverrideManager {
    private Map<String, List<CommandAuthorizationInfo.ResourceAction>> overrides = Collections.EMPTY_MAP;

    OverrideManager(File overrideFile, Log log) {
        this.overrides = OverrideManager.readOverrides(overrideFile, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, List<CommandAuthorizationInfo.ResourceAction>> readOverrides(File overrideFile, Log log) {
        if (!overrideFile.canRead()) {
            log.debug((CharSequence)("No readable exceptions file " + overrideFile.getAbsolutePath()));
            return Collections.EMPTY_MAP;
        }
        HashMap<String, List<CommandAuthorizationInfo.ResourceAction>> result = new HashMap();
        try {
            String line = "";
            try (LineNumberReader reader = new LineNumberReader(new FileReader(overrideFile));){
                while ((line = reader.readLine()) != null) {
                    String[] overriddenResourceActionPairs;
                    ArrayList<CommandAuthorizationInfo.ResourceAction> resourceActionPairs = new ArrayList<CommandAuthorizationInfo.ResourceAction>();
                    String[] parts = line.split("\\|");
                    String name = parts[0].trim();
                    for (String pair : overriddenResourceActionPairs = parts[1].trim().split(",")) {
                        String[] resourceAction = pair.split(":");
                        resourceActionPairs.add(new CommandAuthorizationInfo.ResourceAction(resourceAction[0].trim(), resourceAction[1].trim(), resourceAction[2].trim()));
                    }
                    result.put(name, resourceActionPairs);
                }
            }
        }
        catch (Exception ex) {
            result = Collections.EMPTY_MAP;
        }
        return result;
    }

    CommandAuthorizationInfo adjust(CommandAuthorizationInfo info) {
        if (this.overrides.containsKey(info.name())) {
            info.overrideResourceActions(this.overrides.get(info.name()));
        }
        return info;
    }
}

