/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.module.maven.commandsecurityplugin;

import java.util.regex.Pattern;

public class Util {
    static final Pattern TOKENIZER;

    private static String split(String lookback, String lookahead) {
        return "((?<=" + lookback + ")(?=" + lookahead + "))";
    }

    private static String or(String ... tokens) {
        StringBuilder buf = new StringBuilder();
        for (String t : tokens) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(t);
        }
        return buf.toString();
    }

    static String convertName(String name) {
        StringBuilder buf = new StringBuilder(name.length() + 5);
        for (String t : TOKENIZER.split(name)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase());
        }
        return buf.toString();
    }

    static String restOpTypeToAction(String restOpType) {
        if (restOpType.equals("POST")) {
            return "update";
        }
        if (restOpType.equals("PUT")) {
            return "update";
        }
        if (restOpType.equals("GET")) {
            return "read";
        }
        if (restOpType.equals("DELETE")) {
            return "delete";
        }
        return "????";
    }

    static String lastPart(String s) {
        int lastDot = s.lastIndexOf(46);
        return s.substring(lastDot + 1);
    }

    static {
        String pattern = Util.or(Util.split("x", "X"), Util.split("X", "Xx"), Util.split("\\d", "\\D"));
        pattern = pattern.replace("x", "\\p{Lower}").replace("X", "\\p{Upper}");
        TOKENIZER = Pattern.compile(pattern);
    }
}

