/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.glassfish.build.utils.MavenHelper;

@Mojo(name="featuresets-dependencies", requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public final class FeatureSetsDependenciesMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "gfbuild.featuresets.dependencies.";
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Component
    private ArchiverManager archiverManager;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="gfbuild.featuresets.dependencies.stageDirectory", defaultValue="${project.build.directory}/stage")
    private File stageDirectory;
    @Parameter(property="gfbuild.featuresets.dependencies.copyTypes", defaultValue="jar,war,rar")
    private String copyTypes;
    @Parameter(property="gfbuild.featuresets.dependencies.copyExcludes", defaultValue="")
    private String copyExcludes;
    @Parameter(property="gfbuild.featuresets.dependencies.unpackTypes", defaultValue="zip")
    private String unpackTypes;
    @Parameter(property="gfbuild.featuresets.dependencies.unpackExcludes", defaultValue="")
    private String unpackExcludes;
    @Parameter(property="gfbuild.featuresets.dependencies.includes", defaultValue="")
    private String includes;
    @Parameter(property="gfbuild.featuresets.dependencies.excludes", defaultValue="")
    private String excludes;
    @Parameter(property="gfbuild.featuresets.dependencies.includeScope", defaultValue="compile", required=false)
    private String includeScope;
    @Parameter(property="gfbuild.featuresets.dependencies.excludeScope", defaultValue="test,system")
    private String excludeScope;
    @Parameter(property="gfbuild.featuresets.dependencies.featureset.groupid.includes", defaultValue="")
    private String featureSetGroupIdIncludes;
    @Parameter
    private List<DependencyMapping> mappings;
    @Parameter(property="gfbuild.featuresets.dependencies.skip", defaultValue="false")
    private boolean skip;

    private String getMapping(Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("artifact must be non null");
        }
        if (this.mappings != null && !this.mappings.isEmpty()) {
            for (DependencyMapping mapping : this.mappings) {
                if (mapping.getGroupId() != null && !mapping.getGroupId().isEmpty() && !artifact.getGroupId().equals(mapping.getGroupId()) || !artifact.getArtifactId().equals(mapping.getArtifactId()) || mapping.getName() == null || mapping.getName().isEmpty()) continue;
                return mapping.getName();
            }
        }
        return artifact.getArtifactId();
    }

    private static List<String> stringAsList(String str, String c) {
        if (str != null && !str.isEmpty()) {
            return Arrays.asList(str.split(c));
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isScopeIncluded(String scope) {
        return this.includeScope.contains(scope) && !this.excludeScope.contains(scope);
    }

    private static boolean isArtifactExcluded(List<String> excludes, Artifact artifact) {
        block5: for (String exclude : excludes) {
            String[] gav = exclude.split(":");
            if (gav == null || gav.length == 0) continue;
            switch (gav.length) {
                case 1: {
                    if (!artifact.getArtifactId().equals(gav[0])) continue block5;
                    return true;
                }
                case 2: {
                    if (!artifact.getGroupId().equals(gav[0]) || !artifact.getArtifactId().equals(gav[1])) continue block5;
                    return true;
                }
                case 3: {
                    if (!artifact.getGroupId().equals(gav[0]) || !artifact.getArtifactId().equals(gav[1]) || !artifact.getVersion().equals(gav[2])) continue block5;
                    return true;
                }
            }
            throw new IllegalArgumentException("invalid exclude entry");
        }
        return false;
    }

    public void execute() throws MojoExecutionException {
        List resolvedDependencies;
        ArtifactRequest request;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping featuresets-dependencies");
            return;
        }
        List<String> includeScopeList = FeatureSetsDependenciesMojo.stringAsList(this.includeScope, ",");
        List<String> excludeScopeList = FeatureSetsDependenciesMojo.stringAsList(this.excludeScope, ",");
        List<String> featureSetGroupIdIncludesList = FeatureSetsDependenciesMojo.stringAsList(this.featureSetGroupIdIncludes, ",");
        List<String> copyTypesList = FeatureSetsDependenciesMojo.stringAsList(this.copyTypes, ",");
        List<String> unpackTypesList = FeatureSetsDependenciesMojo.stringAsList(this.unpackTypes, ",");
        List<String> unpackExcludesList = FeatureSetsDependenciesMojo.stringAsList(this.unpackExcludes, ",");
        List<String> copyExcludesList = FeatureSetsDependenciesMojo.stringAsList(this.copyExcludes, ",");
        HashSet dependencies = new HashSet();
        for (Object artifact : this.project.getArtifacts()) {
            if (!featureSetGroupIdIncludesList.contains(artifact.getGroupId())) continue;
            ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
            descriptorRequest.setArtifact((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion()));
            descriptorRequest.setRepositories(this.remoteRepos);
            try {
                ArtifactDescriptorResult result = this.repoSystem.readArtifactDescriptor(this.repoSession, descriptorRequest);
                dependencies.addAll(result.getDependencies());
            }
            catch (ArtifactDescriptorException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
            }
        }
        HashSet<ArtifactRequest> dependenciesRequest = new HashSet<ArtifactRequest>();
        for (Object dependency : dependencies) {
            String depScope = dependency.getScope();
            if (!includeScopeList.contains(depScope) || excludeScopeList.contains(depScope)) continue;
            request = new ArtifactRequest();
            request.setArtifact(dependency.getArtifact());
            request.setRepositories(this.remoteRepos);
            dependenciesRequest.add(request);
        }
        for (Object dependency : this.project.getDependencies()) {
            Dependency directDependency;
            if (!(dependency instanceof Dependency) || featureSetGroupIdIncludesList.contains((directDependency = (Dependency)dependency).getGroupId()) || !this.isScopeIncluded(directDependency.getScope())) continue;
            request = new ArtifactRequest();
            request.setArtifact((Artifact)new DefaultArtifact(directDependency.getGroupId(), directDependency.getArtifactId(), directDependency.getClassifier(), directDependency.getType(), directDependency.getVersion()));
            request.setRepositories(this.remoteRepos);
            dependenciesRequest.add(request);
        }
        try {
            resolvedDependencies = this.repoSystem.resolveArtifacts(this.repoSession, dependenciesRequest);
        }
        catch (ArtifactResolutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        this.stageDirectory.mkdir();
        for (ArtifactResult dependency : resolvedDependencies) {
            File sourceFile = dependency.getArtifact().getFile();
            if (sourceFile == null) {
                this.getLog().error((CharSequence)("dependency " + dependency.getArtifact().toString() + ", file is null"));
                continue;
            }
            if (sourceFile.getName().isEmpty()) {
                this.getLog().info((CharSequence)("dependency " + dependency.getArtifact().toString() + ": empty file name"));
                continue;
            }
            boolean doCopy = copyTypesList.contains(dependency.getArtifact().getExtension());
            boolean doUnpack = unpackTypesList.contains(dependency.getArtifact().getExtension());
            if (doCopy && doUnpack) {
                boolean isUnpackExcluded = FeatureSetsDependenciesMojo.isArtifactExcluded(unpackExcludesList, dependency.getArtifact());
                boolean isCopyExcluded = FeatureSetsDependenciesMojo.isArtifactExcluded(copyExcludesList, dependency.getArtifact());
                if (isUnpackExcluded && isCopyExcluded) {
                    this.getLog().warn((CharSequence)("Excluded: " + dependency.getArtifact().toString()));
                    doCopy = false;
                    doUnpack = false;
                } else if (isCopyExcluded && isUnpackExcluded) {
                    doCopy = true;
                    doUnpack = false;
                } else if (isCopyExcluded) {
                    doCopy = false;
                    doUnpack = true;
                } else {
                    doCopy = true;
                    doUnpack = false;
                }
            }
            if (doCopy) {
                String mapping = this.getMapping(dependency.getArtifact());
                File destFile = new File(this.stageDirectory, mapping + "." + dependency.getArtifact().getExtension());
                String relativeDestFile = destFile.getPath().substring(this.project.getBasedir().getPath().length() + 1);
                this.getLog().info((CharSequence)("Copying " + dependency.getArtifact() + " to " + relativeDestFile));
                try {
                    FileUtils.copyFile((File)sourceFile, (File)destFile);
                }
                catch (IOException ex) {
                    this.getLog().error((CharSequence)ex.getMessage(), (Throwable)ex);
                }
            }
            if (!doUnpack) continue;
            String mapping = this.getMapping(dependency.getArtifact());
            File destDir = new File(this.stageDirectory, mapping);
            String relativeDestDir = destDir.getPath().substring(this.project.getBasedir().getPath().length() + 1);
            this.getLog().info((CharSequence)("Unpacking " + dependency.getArtifact() + " to " + relativeDestDir));
            MavenHelper.unpack(sourceFile, destDir, this.includes, this.excludes, true, this.getLog(), this.archiverManager);
        }
    }

    public static class DependencyMapping {
        private String groupId;
        private String artifactId;
        private String name;

        public void setArtifactId(String depArtifactId) {
            this.artifactId = depArtifactId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setGroupId(String depGroupId) {
            this.groupId = depGroupId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setName(String depName) {
            this.name = depName;
        }

        public String getName() {
            return this.name;
        }
    }
}

