/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.glassfish.build.utils.MavenHelper;

@Mojo(name="unpack-sources", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true)
public final class UnpackSourcesMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "gfbuild.unpack";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Component
    private ArchiverManager archiverManager;
    @Parameter(property="gfbuild.unpackincludes")
    private String includes;
    @Parameter(property="gfbuild.unpackexcludes")
    private String excludes;
    @Parameter(property="gfbuild.unpackexcludeTransitive", defaultValue="", required=false)
    private boolean excludeTransitive;
    @Parameter(property="gfbuild.unpackincludeTypes", defaultValue="", required=false)
    private String includeTypes;
    @Parameter(property="gfbuild.unpackexcludeTypes", defaultValue="", required=false)
    private String excludeTypes;
    @Parameter(property="gfbuild.unpackincludeScope", defaultValue="", required=false)
    private String includeScope;
    @Parameter(property="gfbuild.unpackexcludeScope", defaultValue="", required=false)
    private String excludeScope;
    @Parameter(property="gfbuild.unpackincludeClassifiers", defaultValue="", required=false)
    private String includeClassifiers;
    @Parameter(property="gfbuild.unpackexcludeClassifiers", defaultValue="", required=false)
    private String excludeClassifiers;
    @Parameter(property="gfbuild.unpackexcludeArtifactIds", defaultValue="", required=false)
    private String excludeArtifactIds;
    @Parameter(property="gfbuild.unpackincludeArtifactIds", defaultValue="")
    private String includeArtifactIds;
    @Parameter(property="gfbuild.unpackexcludeGroupIds", defaultValue="")
    private String excludeGroupIds;
    @Parameter(property="gfbuild.unpackincludeGroupIds", defaultValue="")
    private String includeGroupIds;
    @Parameter(property="gfbuild.unpackoutputDirectory", defaultValue="${project.build.directory}/sources-dependency")
    private File outputDirectory;
    @Parameter(property="gfbuild.unpacksilent", defaultValue="false")
    private boolean silent;
    @Parameter(property="gfbuild.unpackattach-sources", defaultValue="false")
    private boolean attachSources;
    @Parameter(property="gfbuild.unpackskip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping unpack-sources");
            return;
        }
        Set<Artifact> filteredDependencies = MavenHelper.filterArtifacts(this.project.getArtifacts(), this.project.getDependencyArtifacts(), this.excludeTransitive, this.includeScope, this.excludeScope, this.excludeTypes, this.includeTypes, this.includeClassifiers, this.excludeClassifiers, this.includeGroupIds, this.excludeGroupIds, this.includeArtifactIds, this.excludeArtifactIds);
        for (Artifact artifact : filteredDependencies) {
            ArtifactResult result = MavenHelper.resolveArtifact(artifact.getGroupId(), artifact.getArtifactId(), "sources", "jar", artifact.getVersion(), this.repoSystem, this.repoSession, this.remoteRepos);
            MavenHelper.unpack(result.getArtifact().getFile(), this.outputDirectory, MavenHelper.cleanToBeTokenizedString(this.includes), MavenHelper.cleanToBeTokenizedString(this.excludes), this.silent, this.getLog(), this.archiverManager);
        }
        if (this.attachSources) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
    }
}

