/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.spec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class Artifact {
    private String groupId;
    private String artifactId;
    private ArtifactVersion version;
    private String buildNumber;
    private static final String[] buildNumberSeparators = new String[]{"m", "b"};
    public static final String SNAPSHOT_QUALIFIER = "SNAPSHOT";

    private static String stripSnapshotQualifier(String qualifier) {
        if (qualifier != null) {
            if (qualifier.endsWith("-SNAPSHOT")) {
                qualifier = qualifier.replace("-SNAPSHOT", "");
            }
            return qualifier;
        }
        return null;
    }

    private static String getBuildNumber(String qualifier) {
        if ((qualifier = Artifact.stripSnapshotQualifier(qualifier)) != null) {
            for (String c : buildNumberSeparators) {
                if (!qualifier.contains(c)) continue;
                return qualifier.substring(qualifier.lastIndexOf(c) + 1);
            }
        }
        return null;
    }

    public Artifact() {
    }

    public Artifact(String _groupId, String _artifactId, String _version) {
        this.groupId = _groupId;
        this.artifactId = _artifactId;
        this.version = new DefaultArtifactVersion(_version);
        this.buildNumber = Artifact.getBuildNumber(this.version.getQualifier());
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public ArtifactVersion getVersion() {
        return this.version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setVersion(String version) {
        this.version = new DefaultArtifactVersion(version);
        this.buildNumber = Artifact.getBuildNumber(this.version.getQualifier());
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    private static ZipEntry getPomPropertiesFile(JarFile jar) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith("pom.properties")) continue;
            return entry;
        }
        return null;
    }

    public static Artifact fromJar(JarFile jar) throws IOException {
        ZipEntry entry = Artifact.getPomPropertiesFile(jar);
        if (entry == null) {
            throw new RuntimeException("unable to find pom.properties files inside " + jar.getName());
        }
        InputStream is = jar.getInputStream(entry);
        Properties pomProps = new Properties();
        pomProps.load(is);
        return new Artifact(pomProps.getProperty("groupId"), pomProps.getProperty("artifactId"), pomProps.getProperty("version"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        sb.append(this.groupId);
        sb.append(':');
        sb.append(this.artifactId);
        sb.append(':');
        sb.append(this.version);
        sb.append(" ]");
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Artifact other = (Artifact)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        return this.version == other.version || this.version != null && this.version.equals(other.version);
    }
}

