/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.StringUtils;

public final class JDK {
    private static int major;
    private static int minor;
    private static int subminor;
    private static int update;

    private JDK() {
    }

    public static boolean ok() {
        return major == 1 && minor >= 6;
    }

    public static int getMajor() {
        return major;
    }

    public static int getMinor() {
        return minor;
    }

    public static int getSubMinor() {
        return subminor;
    }

    public static int getUpdate() {
        return update;
    }

    public static String toStringStatic() {
        return "major: " + JDK.getMajor() + "\nminor: " + JDK.getMinor() + "\nsubminor: " + JDK.getSubMinor() + "\nupdate: " + JDK.getUpdate() + "\nOK ==>" + JDK.ok();
    }

    private static void initialize() {
        major = 1;
        update = 0;
        subminor = 0;
        minor = 0;
        try {
            String jv = System.getProperty("java.version");
            if (!StringUtils.ok(jv)) {
                return;
            }
            String[] ss = jv.split("\\.");
            if (ss == null || ss.length < 3 || !ss[0].equals("1")) {
                return;
            }
            major = Integer.parseInt(ss[0]);
            minor = Integer.parseInt(ss[1]);
            if ((ss = ss[2].split("_")) == null || ss.length < 1) {
                return;
            }
            subminor = Integer.parseInt(ss[0]);
            if (ss.length > 1) {
                update = Integer.parseInt(ss[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        JDK.initialize();
    }
}

