/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.Attribute;
import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.Constants;
import com.sun.btrace.util.NullVisitor;

public class MethodRemover
extends ClassAdapter {
    public MethodRemover(ClassVisitor visitor) {
        super(visitor);
    }

    private MethodVisitor addMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, final String signature, final String[] exceptions) {
        if (name.equals("<init>") || name.equals("<clinit>")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        return new MethodAdapter(new NullVisitor()){
            private boolean include;
            private MethodVisitor adaptee;
            {
                super(x0);
                this.include = true;
                this.adaptee = null;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String annoDesc, boolean visible) {
                if (annoDesc.equals(Constants.ONMETHOD_DESC)) {
                    this.include = false;
                    return new NullVisitor();
                }
                if (annoDesc.equals(Constants.ONPROBE_DESC)) {
                    this.include = false;
                    return new NullVisitor();
                }
                this.adaptee = MethodRemover.this.addMethod(access, name, desc, signature, exceptions);
                return this.adaptee.visitAnnotation(annoDesc, visible);
            }

            @Override
            public void visitAttribute(Attribute attr) {
                if (this.include) {
                    this.adaptee.visitAttribute(attr);
                }
            }

            @Override
            public void visitCode() {
                if (this.include) {
                    this.adaptee.visitCode();
                }
            }

            @Override
            public void visitFrame(int type2, int nLocal, Object[] local, int nStack, Object[] stack) {
                if (this.include) {
                    this.adaptee.visitFrame(type2, nLocal, local, nStack, stack);
                }
            }

            @Override
            public void visitInsn(int opcode) {
                if (this.include) {
                    this.adaptee.visitInsn(opcode);
                }
            }

            @Override
            public void visitIntInsn(int opcode, int operand) {
                if (this.include) {
                    this.adaptee.visitIntInsn(opcode, operand);
                }
            }

            @Override
            public void visitVarInsn(int opcode, int var) {
                if (this.include) {
                    this.adaptee.visitVarInsn(opcode, var);
                }
            }

            @Override
            public void visitTypeInsn(int opcode, String desc2) {
                if (this.include) {
                    this.adaptee.visitTypeInsn(opcode, desc2);
                }
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name2, String desc2) {
                if (this.include) {
                    this.adaptee.visitFieldInsn(opcode, owner, name2, desc2);
                }
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name2, String desc2) {
                if (this.include) {
                    this.adaptee.visitMethodInsn(opcode, owner, name2, desc2);
                }
            }

            @Override
            public void visitJumpInsn(int opcode, Label label) {
                if (this.include) {
                    this.adaptee.visitJumpInsn(opcode, label);
                }
            }

            @Override
            public void visitLabel(Label label) {
                if (this.include) {
                    this.adaptee.visitLabel(label);
                }
            }

            @Override
            public void visitLdcInsn(Object cst) {
                if (this.include) {
                    this.adaptee.visitLdcInsn(cst);
                }
            }

            @Override
            public void visitIincInsn(int var, int increment) {
                if (this.include) {
                    this.adaptee.visitIincInsn(var, increment);
                }
            }

            @Override
            public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
                if (this.include) {
                    this.adaptee.visitTableSwitchInsn(min, max, dflt, labels);
                }
            }

            @Override
            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                if (this.include) {
                    this.adaptee.visitLookupSwitchInsn(dflt, keys, labels);
                }
            }

            @Override
            public void visitMultiANewArrayInsn(String desc2, int dims) {
                if (this.include) {
                    this.adaptee.visitMultiANewArrayInsn(desc2, dims);
                }
            }

            @Override
            public void visitTryCatchBlock(Label start, Label end, Label handler, String type2) {
                if (this.include) {
                    this.adaptee.visitTryCatchBlock(start, end, handler, type2);
                }
            }

            @Override
            public void visitLocalVariable(String name2, String desc2, String signature2, Label start, Label end, int index) {
                if (this.include) {
                    this.adaptee.visitLocalVariable(name2, desc2, signature2, start, end, index);
                }
            }

            @Override
            public void visitLineNumber(int line, Label start) {
                if (this.include) {
                    this.adaptee.visitLineNumber(line, start);
                }
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                if (this.include) {
                    this.adaptee.visitMaxs(maxStack, maxLocals);
                }
            }

            @Override
            public void visitEnd() {
                if (this.include) {
                    this.adaptee.visitEnd();
                }
            }
        };
    }
}

