/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.IndentingWriter;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;

public abstract class Generator {
    protected static final Logger _logger = LogDomains.getLogger(Generator.class, "javax.enterprise.system.container.ejb");
    protected String ejbClassSymbol;

    public abstract String getGeneratedClass();

    protected String getPackageName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return className.substring(0, dot);
    }

    protected String getBaseName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return className;
        }
        return className.substring(dot + 1);
    }

    protected String printType(Class cls) {
        if (cls.isArray()) {
            return this.printType(cls.getComponentType()) + "[]";
        }
        return cls.getName();
    }

    protected Method[] removeDups(Method[] orig) {
        Vector<Method> nodups = new Vector<Method>();
        for (int i = 0; i < orig.length; ++i) {
            Method m1 = orig[i];
            boolean dup = false;
            Enumeration e = nodups.elements();
            while (e.hasMoreElements()) {
                Class<?>[] m2parms;
                Class<?>[] m1parms;
                Method m2 = (Method)e.nextElement();
                if (!m1.getName().equals(m2.getName()) || (m1parms = m1.getParameterTypes()).length != (m2parms = m2.getParameterTypes()).length) continue;
                boolean parmsDup = true;
                for (int j = 0; j < m2parms.length; ++j) {
                    if (m1parms[j] == m2parms[j]) continue;
                    parmsDup = false;
                    break;
                }
                if (!parmsDup) continue;
                dup = true;
                if (!m2.getDeclaringClass().isAssignableFrom(m1.getDeclaringClass())) break;
                nodups.remove(m2);
                nodups.add(m1);
                break;
            }
            if (dup) continue;
            nodups.add(m1);
        }
        return nodups.toArray(new Method[nodups.size()]);
    }

    protected boolean isEJBIntfMethod(Class ejbIntfClz, Method methodToCheck) {
        boolean isEJBIntfMethod = false;
        Method[] ejbIntfMethods = ejbIntfClz.getMethods();
        for (int i = 0; i < ejbIntfMethods.length; ++i) {
            Method next = ejbIntfMethods[i];
            if (!this.methodCompare(methodToCheck, next)) continue;
            isEJBIntfMethod = true;
            String ejbIntfClzName = ejbIntfClz.getName();
            Class<?> methodToCheckClz = methodToCheck.getDeclaringClass();
            if (methodToCheckClz.getName().equals(ejbIntfClzName)) break;
            Object[] logParams = new String[]{next.toString(), methodToCheck.toString()};
            _logger.log(Level.WARNING, "ejb.illegal_ejb_interface_override", logParams);
            break;
        }
        return isEJBIntfMethod;
    }

    private boolean methodCompare(Method factoryMethod, Method homeMethod) {
        Class<?>[] beanParamTypes;
        if (!factoryMethod.getName().equals(homeMethod.getName())) {
            return false;
        }
        Class<?>[] factoryParamTypes = factoryMethod.getParameterTypes();
        if (factoryParamTypes.length != (beanParamTypes = homeMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < factoryParamTypes.length; ++i) {
            if (factoryParamTypes[i] == beanParamTypes[i]) continue;
            return false;
        }
        return true;
    }

    protected String[] printStaticMethodInit(IndentingWriter p, Class genClass, Method[] methods) throws IOException {
        int i;
        if (methods == null || methods.length == 0) {
            return new String[0];
        }
        String[] methodVars = new String[methods.length];
        for (i = 0; i < methods.length; ++i) {
            String methodVar;
            methodVars[i] = methodVar = this.getUniqueMethodVar(methodVars, "__Method__" + methods[i].getName(), 0);
            p.pln("private static java.lang.reflect.Method " + methodVar + ";");
        }
        p.plnI("static {");
        p.plnI("try {");
        p.pln("java.lang.Class[] cl;");
        for (i = 0; i < methods.length; ++i) {
            Class<?>[] params = methods[i].getParameterTypes();
            p.pln("cl = new java.lang.Class[" + params.length + "];");
            for (int j = 0; j < params.length; ++j) {
                p.pln("cl[" + j + "] = " + this.printType(params[j]) + ".class;");
            }
            p.pln(methodVars[i] + " = " + genClass.getName() + ".class.getMethod(\"" + methods[i].getName() + "\", cl);");
        }
        p.pOln("} catch(NoSuchMethodException e) {}");
        p.pOln("}");
        return methodVars;
    }

    private String getUniqueMethodVar(String[] existingNames, String newName, int count) {
        boolean exists = false;
        String name = newName;
        if (count > 0) {
            name = newName + count;
        }
        for (int i = 0; i < existingNames.length; ++i) {
            String existingName = existingNames[i];
            if (existingName == null || !existingName.equals(name)) continue;
            exists = true;
            break;
        }
        if (exists) {
            return this.getUniqueMethodVar(existingNames, newName, ++count);
        }
        return name;
    }

    protected String getUniqueClassName(DeploymentContext context, String origName, String origSuffix, Vector existingClassNames) {
        String newClassName = null;
        boolean foundUniqueName = false;
        int count = 0;
        while (!foundUniqueName) {
            String suffix = origSuffix;
            if (count > 0) {
                suffix = origSuffix + count;
            }
            if (!existingClassNames.contains(newClassName = origName + suffix)) {
                foundUniqueName = true;
                existingClassNames.add(newClassName);
                continue;
            }
            ++count;
        }
        return newClassName;
    }

    protected String getTxAttribute(EjbDescriptor dd, Method method) {
        if (dd instanceof EjbSessionDescriptor && ((EjbSessionDescriptor)dd).getTransactionType().equals("Bean")) {
            return "TX_BEAN_MANAGED";
        }
        String txAttr = null;
        MethodDescriptor mdesc = new MethodDescriptor(method, this.ejbClassSymbol);
        ContainerTransaction ct = dd.getContainerTransactionFor(mdesc);
        if (ct != null) {
            String attr = ct.getTransactionAttribute();
            if (attr.equals("NotSupported")) {
                txAttr = "TX_NOT_SUPPORTED";
            } else if (attr.equals("Supports")) {
                txAttr = "TX_SUPPORTS";
            } else if (attr.equals("Required")) {
                txAttr = "TX_REQUIRED";
            } else if (attr.equals("RequiresNew")) {
                txAttr = "TX_REQUIRES_NEW";
            } else if (attr.equals("Mandatory")) {
                txAttr = "TX_MANDATORY";
            } else if (attr.equals("Never")) {
                txAttr = "TX_NEVER";
            }
        }
        if (txAttr == null) {
            throw new RuntimeException("Transaction Attribute not found for method " + method);
        }
        return txAttr;
    }

    protected String getSecurityAttribute(EjbDescriptor dd, Method m) {
        Set excluded;
        MethodDescriptor thisMethodDesc = new MethodDescriptor(m, this.ejbClassSymbol);
        Set unchecked = dd.getUncheckedMethodDescriptors();
        if (unchecked != null) {
            for (MethodDescriptor md : unchecked) {
                if (!thisMethodDesc.equals(md)) continue;
                return "SEC_UNCHECKED";
            }
        }
        if ((excluded = dd.getExcludedMethodDescriptors()) != null) {
            for (MethodDescriptor md : excluded) {
                if (!thisMethodDesc.equals(md)) continue;
                return "SEC_EXCLUDED";
            }
        }
        return "SEC_CHECKED";
    }
}

