/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.corba.ee.spi.orbutil.codegen.Type;
import com.sun.corba.ee.spi.orbutil.codegen.Wrapper;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.jws.WebMethod;

public class ServiceInterfaceGenerator
extends Generator
implements ClassGeneratorFactory {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServiceInterfaceGenerator.class);
    private static Logger _logger = null;
    Class sib = null;
    String serviceIntfName;
    String packageName;
    String serviceIntfSimpleName;
    Method[] intfMethods;

    public ServiceInterfaceGenerator(ClassLoader cl, Class sib) throws GeneratorException, ClassNotFoundException {
        this.sib = sib;
        this.serviceIntfSimpleName = this.getServiceIntfName();
        this.packageName = this.getPackageName();
        this.serviceIntfName = this.packageName + "." + this.serviceIntfSimpleName;
        this.intfMethods = this.calculateMethods(sib, this.removeDups(sib.getMethods()));
    }

    public String getServiceIntfName() {
        String serviceIntfSimpleName = this.sib.getSimpleName();
        if (serviceIntfSimpleName.endsWith("EJB")) {
            return serviceIntfSimpleName.substring(0, serviceIntfSimpleName.length() - 3);
        }
        return serviceIntfSimpleName + "SEI";
    }

    public String getPackageName() {
        return this.sib.getPackage().getName() + ".internal.jaxws";
    }

    public String getGeneratedClass() {
        return this.serviceIntfName;
    }

    public String className() {
        return this.getGeneratedClass();
    }

    private Method[] calculateMethods(Class sib, Method[] initialList) {
        boolean webMethodAnnotationUsed = false;
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : initialList) {
            WebMethod wm = m.getAnnotation(WebMethod.class);
            if (wm != null && !webMethodAnnotationUsed) {
                webMethodAnnotationUsed = true;
                list.clear();
            }
            if (wm != null) {
                list.add(m);
                continue;
            }
            if (webMethodAnnotationUsed || m.getDeclaringClass().equals(Object.class)) continue;
            list.add(m);
        }
        return list.toArray(new Method[0]);
    }

    public void evaluate() {
        Wrapper._clear();
        if (this.packageName != null) {
            Wrapper._package((String)this.packageName);
        }
        Wrapper._interface((int)1, (String)this.serviceIntfSimpleName, (Type[])new Type[0]);
        for (int i = 0; i < this.intfMethods.length; ++i) {
            this.printMethod(this.intfMethods[i]);
        }
        Wrapper._end();
    }

    private void printMethod(Method m) {
        boolean throwsRemoteException = false;
        LinkedList<Type> exceptionList = new LinkedList<Type>();
        for (Class<?> exception : m.getExceptionTypes()) {
            exceptionList.add(Type.type(exception));
            if (!exception.getName().equals("java.rmi.RemoteException")) continue;
            throwsRemoteException = true;
        }
        if (!throwsRemoteException) {
            exceptionList.add(Wrapper._t((String)"java.rmi.RemoteException"));
        }
        Wrapper._method((int)1025, (Type)Type.type(m.getReturnType()), (String)m.getName(), exceptionList);
        int i = 0;
        for (Class<?> param : m.getParameterTypes()) {
            Wrapper._arg((Type)Type.type(param), (String)("param" + i));
            ++i;
        }
        Wrapper._end();
    }

    static {
        _logger = LogDomains.getLogger(ServiceInterfaceGenerator.class, "javax.enterprise.system.tools.deployment");
    }
}

