/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.builder;

import com.sun.ejb.base.container.util.CacheProperties;
import com.sun.ejb.base.sfsb.util.CheckpointPolicyImpl;
import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.ejb.base.sfsb.util.ScrambledKeyGenerator;
import com.sun.ejb.base.sfsb.util.SimpleKeyGenerator;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.builder.BaseContainerBuilder;
import com.sun.ejb.containers.builder.CachePassivatorTask;
import com.sun.ejb.containers.builder.ExpiredSessionsRemovalTask;
import com.sun.ejb.containers.util.cache.FIFOSessionCache;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import com.sun.ejb.containers.util.cache.NRUSessionCache;
import com.sun.ejb.containers.util.cache.UnBoundedSessionCache;
import com.sun.ejb.spi.container.SFSBContainerInitialization;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.EjbContainerAvailability;
import com.sun.enterprise.deployment.EjbDescriptor;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.util.SimpleMetadata;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class StatefulContainerBuilder
extends BaseContainerBuilder {
    private static final Level TRACE_LEVEL = Level.FINE;
    private StatefulSessionContainer sfsbContainer;
    private SFSBContainerInitialization containerInitialization;
    @Inject
    private Habitat habitat;
    @Inject
    private CacheProperties cacheProps;
    @Inject
    private EJBServerConfigLookup ejbConfigLookup;
    @Inject(optional=true)
    private AvailabilityService availabilityService;
    @Inject(optional=true)
    private EjbContainerAvailability ejbAvailability;
    @Inject
    EjbContainer ejbContainerConfig;
    @Inject(optional=true)
    GMSAdapterService gmsAdapterService;
    private LruSessionCache sessionCache;
    private BackingStore<Serializable, SimpleMetadata> backingStore;
    private boolean HAEnabled = false;
    private boolean asyncReplication = true;
    private SimpleKeyGenerator keyGen;

    public BaseContainer createContainer(EjbDescriptor ejbDescriptor, ClassLoader loader) throws Exception {
        this.cacheProps.init(ejbDescriptor);
        this.ejbConfigLookup.initWithEjbDescriptor(ejbDescriptor);
        this.sfsbContainer = new StatefulSessionContainer(ejbDescriptor, loader);
        this.containerInitialization = this.sfsbContainer;
        return this.sfsbContainer;
    }

    public void buildComponents() throws Exception {
        if (this.availabilityService != null) {
            this.HAEnabled = Boolean.valueOf(this.availabilityService.getAvailabilityEnabled());
            _logger.log(Level.INFO, "TopLevel AvailabilityService.getAvailabilityEnabled => " + this.HAEnabled);
            if (this.HAEnabled && this.ejbAvailability != null) {
                this.HAEnabled = Boolean.valueOf(this.ejbAvailability.getAvailabilityEnabled());
                _logger.log(Level.INFO, "TopLevel EjbAvailabilityService.getAvailabilityEnabled => " + this.HAEnabled);
            }
            boolean appLevelHAEnabled = false;
            try {
                if (this.HAEnabled) {
                    DeployCommandParameters params;
                    DeploymentContext dc = this.getDynamicDeploymentContext();
                    if (dc != null && (params = dc.getCommandParameters(DeployCommandParameters.class)) != null) {
                        appLevelHAEnabled = params.availabilityenabled;
                        this.asyncReplication = params.asyncreplication;
                    }
                    _logger.log(Level.INFO, "**Global AvailabilityEnabled => " + this.HAEnabled + "; isAppHAEnabled: " + appLevelHAEnabled);
                }
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "Exception while trying to determine availability-enabled settings for this app", ex);
                appLevelHAEnabled = false;
            }
            this.HAEnabled = this.HAEnabled && appLevelHAEnabled;
            _logger.log(Level.INFO, "StatefulContainerBuilder AvailabilityEnabled for this app => " + this.HAEnabled);
        }
        this.buildCheckpointPolicy(this.HAEnabled);
        this.buildSFSBUUIDUtil();
        this.buildStoreManager();
        this.buildCache();
        this.scheduleTimerTasks(this.sfsbContainer);
    }

    private final void buildCheckpointPolicy(boolean haEnabled) {
        this.containerInitialization.setCheckpointPolicy(new CheckpointPolicyImpl(haEnabled));
    }

    private void buildSFSBUUIDUtil() {
        this.keyGen = this.HAEnabled ? new ScrambledKeyGenerator(this.getIPAddress(), this.getPort()) : new SimpleKeyGenerator(this.getIPAddress(), this.getPort());
        this.containerInitialization.setSFSBUUIDUtil(this.keyGen);
    }

    private void buildStoreManager() throws BackingStoreException {
        GMSAdapter gmsAdapter;
        String persistenceStoreType = "file";
        if (this.ejbAvailability != null) {
            String string = persistenceStoreType = this.HAEnabled ? this.ejbAvailability.getSfsbHaPersistenceType() : this.ejbAvailability.getSfsbPersistenceType();
            if ("ha".equals(persistenceStoreType)) {
                persistenceStoreType = "replicated";
            } else if ("memory".equals(persistenceStoreType)) {
                persistenceStoreType = "file";
            }
        }
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        String storeName = this.ejbDescriptor.getName() + "-" + this.ejbDescriptor.getUniqueId() + "-BackingStore";
        _logger.log(Level.INFO, "StatefulContainerBuilder.buildStoreManager() storeName: " + storeName);
        String subDirName = "";
        subDirName = subDirName + this.ejbDescriptor.getName() + "-" + this.ejbDescriptor.getUniqueId();
        conf.setShortUniqueName("" + this.ejbDescriptor.getUniqueId()).setStoreName(storeName).setStoreType(persistenceStoreType).setBaseDirectory(new File(this.ejbContainerConfig.getSessionStore(), subDirName)).setKeyClazz(Serializable.class).setValueClazz(SimpleMetadata.class).setClassLoader(StatefulContainerBuilder.class.getClassLoader());
        Map<String, Object> vendorMap = conf.getVendorSpecificSettings();
        vendorMap.put("local.caching", true);
        vendorMap.put("start.gms", false);
        vendorMap.put("async.replication", this.asyncReplication);
        vendorMap.put("broadcast.remove.expired", false);
        vendorMap.put("value.class.is.thread.safe", true);
        vendorMap.put("key.transformer", this.keyGen);
        if (this.gmsAdapterService != null && (gmsAdapter = this.gmsAdapterService.getGMSAdapter()) != null) {
            conf.setClusterName(gmsAdapter.getClusterName());
            conf.setInstanceName(gmsAdapter.getModule().getInstanceName());
        }
        BackingStoreFactory factory = null;
        try {
            factory = this.habitat.getComponent(BackingStoreFactory.class, persistenceStoreType);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Could not instantiate backing store for type: " + persistenceStoreType, ex);
        }
        try {
            if (factory == null) {
                factory = this.habitat.getComponent(BackingStoreFactory.class, "noop");
            }
            this.backingStore = factory.createBackingStore(conf);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Could not instantiate BackingStore for persistence type: " + persistenceStoreType, ex);
            throw new BackingStoreException("Could not instantiate BackingStore for persistence type: " + persistenceStoreType, ex);
        }
        _logger.log(Level.WARNING, "StatefulContainerbuilder instantiated store: " + this.backingStore + "; ha-enabled: " + this.HAEnabled + " ==> " + conf);
    }

    private void buildCache() {
        String cacheName = this.ejbDescriptor.getEjbClassName();
        String victimPolicy = this.cacheProps.getVictimSelectionPolicy();
        this.sessionCache = this.cacheProps.getMaxCacheSize() <= 0 ? new UnBoundedSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : ("lru".equalsIgnoreCase(victimPolicy) ? new LruSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : ("fifo".equalsIgnoreCase(victimPolicy) ? new FIFOSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : new NRUSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds())));
        float ratio = (float)(1.0 * (double)this.cacheProps.getNumberOfVictimsToSelect() / (double)this.cacheProps.getMaxCacheSize());
        float loadFactor = (float)(1.0 - (double)ratio);
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            loadFactor = 0.75f;
        }
        if (this.cacheProps.getMaxCacheSize() <= 0) {
            this.sessionCache.init(16384, loadFactor, null);
        } else {
            this.sessionCache.init(this.cacheProps.getMaxCacheSize(), loadFactor, null);
        }
        this.sessionCache.addCacheListener(this.sfsbContainer);
        this.sfsbContainer.setSessionCache(this.sessionCache);
        this.sessionCache.setBackingStore(this.backingStore);
        this.sfsbContainer.setBackingStore(this.backingStore);
        if (this.cacheProps.getNumberOfVictimsToSelect() > 8) {
            this.sfsbContainer.setPassivationBatchCount(this.cacheProps.getNumberOfVictimsToSelect());
        }
        if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "Created cache [for " + this.ejbDescriptor.getName() + "] " + this.cacheProps + "; loadFactor: " + loadFactor + "; backingStore: " + this.backingStore);
        }
    }

    private void scheduleTimerTasks(StatefulSessionContainer container) {
        long timeout;
        String ejbName = this.ejbDescriptor.getEjbClassName();
        if (this.cacheProps.getCacheIdleTimeoutInSeconds() > 0) {
            timeout = (long)this.cacheProps.getCacheIdleTimeoutInSeconds() * 1000L;
            try {
                this.sfsbContainer.invokePeriodically(timeout, timeout, new CachePassivatorTask(ejbName, this.sessionCache, _logger));
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "[SFSBBuilder]: Added CachePassivator for: " + ejbName + ". To run after " + timeout + " millis...");
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "ejb.sfsb_helper_add_idle_passivatortask_failed", th);
            }
        }
        if (this.cacheProps.getRemovalTimeoutInSeconds() > 0) {
            timeout = (long)this.cacheProps.getRemovalTimeoutInSeconds() * 1000L;
            try {
                this.sfsbContainer.invokePeriodically(timeout, timeout, new ExpiredSessionsRemovalTask(ejbName, this.sfsbContainer, _logger));
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "[SFSBBuilder]: Added StorePassivator for: " + ejbName + ". To run after " + "after " + timeout + " millis...");
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "ejb.sfsb_helper_add_remove_passivatortask_failed", th);
            }
        }
    }
}

