/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.Jps;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import org.glassfish.api.admin.CommandException;

public abstract class LocalServerCommand
extends CLICommand {
    private ServerDirs serverDirs;
    private static final LocalStringsImpl strings = new LocalStringsImpl(LocalDomainCommand.class);

    protected boolean checkForSpecialFiles() {
        return true;
    }

    protected final HostAndPort getAdminAddress() throws CommandException {
        return this.getAdminAddress("server");
    }

    protected final HostAndPort getAdminAddress(String serverName) throws CommandException {
        try {
            MiniXmlParser parser = new MiniXmlParser(this.getDomainXml(), serverName);
            List<HostAndPort> addrSet = parser.getAdminAddresses();
            if (addrSet.size() > 0) {
                return addrSet.get(0);
            }
            throw new CommandException(strings.get("NoAdminPort"));
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException(strings.get("NoAdminPortEx", ex), ex);
        }
    }

    protected final void setServerDirs(ServerDirs sd) {
        this.serverDirs = sd;
    }

    protected final void setLocalPassword() {
        String pw;
        String string = pw = this.serverDirs == null ? null : this.serverDirs.getLocalPassword();
        if (LocalServerCommand.ok(pw)) {
            this.programOpts.setPassword(pw, ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
            logger.finer("Using local password");
        } else {
            logger.finer("Not using local password");
        }
    }

    protected final void unsetLocalPassword() {
        this.programOpts.setPassword(null, ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
    }

    protected final void resetServerDirs() throws IOException {
        this.serverDirs = this.serverDirs.refresh();
    }

    protected final ServerDirs getServerDirs() {
        return this.serverDirs;
    }

    protected final File getDomainXml() {
        return this.serverDirs.getDomainXml();
    }

    protected final String readFromMasterPasswordFile() {
        File mpf = this.getMasterPasswordFile();
        if (mpf == null) {
            return null;
        }
        try {
            PasswordAdapter pw = new PasswordAdapter(mpf.getAbsolutePath(), "master-password".toCharArray());
            return pw.getPasswordForAlias("master-password");
        }
        catch (Exception e) {
            logger.finer("master password file reading error: " + e.getMessage());
            return null;
        }
    }

    protected final boolean verifyMasterPassword(String mpv) {
        return this.loadAndVerifyKeystore(this.getJKS(), mpv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadAndVerifyKeystore(File jks, String mpv) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(jks);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, mpv.toCharArray());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.finer(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    protected final String getMasterPassword() throws CommandException {
        int RETRIES = 3;
        long t0 = System.currentTimeMillis();
        String mpv = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD");
        if (mpv == null) {
            mpv = "changeit";
            if (!this.verifyMasterPassword(mpv) && !this.verifyMasterPassword(mpv = this.readFromMasterPasswordFile())) {
                mpv = this.retry(3);
            }
        } else if (!this.verifyMasterPassword(mpv)) {
            mpv = this.retry(3);
        }
        long t1 = System.currentTimeMillis();
        logger.finer("Time spent in master password extraction: " + (t1 - t0) + " msec");
        return mpv;
    }

    protected final boolean isThisServer(File ourDir, String directoryKey) {
        if (!LocalServerCommand.ok(directoryKey)) {
            throw new NullPointerException();
        }
        ourDir = this.getUniquePath(ourDir);
        logger.finer("Check if server is at location " + ourDir);
        try {
            RemoteCommand cmd = new RemoteCommand("__locations", this.programOpts, this.env);
            Map<String, String> attrs = cmd.executeAndReturnAttributes("__locations");
            String theirDirPath = attrs.get(directoryKey);
            logger.finer("Remote server has root directory " + theirDirPath);
            if (LocalServerCommand.ok(theirDirPath)) {
                File theirDir = this.getUniquePath(new File(theirDirPath));
                return theirDir.equals(ourDir);
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isRunning(String host, int port) {
        Socket server = null;
        try {
            server = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.finer("\nisRunning got exception: " + ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    protected final boolean isRunning(int port) {
        return this.isRunning(null, port);
    }

    protected boolean isRunning() {
        int pp = this.getPrevPid();
        if (pp < 0) {
            return this.isRunningByCheckingForPidFile();
        }
        Boolean b = ProcessUtils.isProcessRunning(pp);
        if (b == null) {
            return this.isRunningUsingJps();
        }
        return b;
    }

    protected final void waitForRestart(File pwFile, long oldTimeStamp, long uptimeOldServer) throws CommandException {
        if (oldTimeStamp <= 0L || !this.usingLocalPassword()) {
            this.waitForRestartRemote(uptimeOldServer);
        } else {
            this.waitForRestartLocal(pwFile, oldTimeStamp, uptimeOldServer);
        }
    }

    protected final int getPrevPid() {
        try {
            File prevPidFile = new File(this.getServerDirs().getPidFile().getPath() + ".prev");
            if (!prevPidFile.canRead()) {
                return -1;
            }
            String pids = FileUtils.readSmallFile(prevPidFile).trim();
            return Integer.parseInt(pids);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private final boolean isRunningUsingJps() {
        int pp = this.getPrevPid();
        if (pp < 0) {
            return this.isRunningByCheckingForPidFile();
        }
        return Jps.isPid(pp);
    }

    private boolean isRunningByCheckingForPidFile() {
        File pf = this.getServerDirs().getPidFile();
        if (pf != null) {
            return pf.exists();
        }
        return this.isRunning(this.programOpts.getHost(), this.programOpts.getPort());
    }

    private void waitForRestartLocal(File pwFile, long oldTimeStamp, long uptimeOldServer) throws CommandException {
        if (!this.usingLocalPassword()) {
            throw new CommandException("Internal Error - waitForRestartLocal should not be called unless using local password authentication.");
        }
        long end = 600000L + System.currentTimeMillis();
        while (System.currentTimeMillis() < end) {
            try {
                long newTimeStamp = pwFile.lastModified();
                logger.finer("Checking timestamp of local-password.  old: " + oldTimeStamp + ", new: " + newTimeStamp);
                if (newTimeStamp > oldTimeStamp) {
                    this.resetServerDirs();
                    this.programOpts.setPassword(this.getServerDirs().getLocalPassword(), ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
                    this.waitForRestartRemote(uptimeOldServer);
                    return;
                }
                Thread.sleep(300L);
            }
            catch (Exception e) {}
        }
        throw new CommandException(strings.get("restartDomain.noGFStart"));
    }

    private void waitForRestartRemote(long uptimeOldServer) throws CommandException {
        long end = 600000L + System.currentTimeMillis();
        while (System.currentTimeMillis() < end) {
            try {
                Thread.sleep(300L);
                long up = this.getUptime();
                logger.finer("oldserver-uptime, newserver-uptime = " + uptimeOldServer + " --- " + up);
                if (up <= 0L || up >= uptimeOldServer) continue;
                return;
            }
            catch (Exception e) {
            }
        }
        throw new CommandException(strings.get("restartDomain.noGFStart"));
    }

    protected final long getUptime() throws CommandException {
        RemoteCommand cmd = new RemoteCommand("uptime", this.programOpts, this.env);
        String up = cmd.executeAndReturnOutput("uptime", "--milliseconds").trim();
        long up_ms = this.parseUptime(up);
        if (up_ms <= 0L) {
            throw new CommandException(strings.get("restart.dasNotRunning"));
        }
        logger.finer("server uptime: " + up_ms);
        return up_ms;
    }

    private long parseUptime(String up) {
        try {
            return Long.parseLong(up);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private boolean usingLocalPassword() {
        return this.programOpts.getPasswordLocation() == ProgramOptions.PasswordLocation.LOCAL_PASSWORD;
    }

    private final File getJKS() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(new File(this.serverDirs.getServerDir(), "config"), "cacerts.jks");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    protected File getMasterPasswordFile() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(this.serverDirs.getServerDir(), "master-password");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    private String retry(int times) throws CommandException {
        for (int i = 0; i < times; ++i) {
            String prompt = strings.get("mp.prompt", times - i);
            String mpv = super.readPassword(prompt);
            if (mpv == null) {
                throw new CommandException(strings.get("no.console"));
            }
            if (this.verifyMasterPassword(mpv)) {
                return mpv;
            }
            if (i >= times - 1) continue;
            logger.info(strings.get("retry.mp"));
        }
        throw new CommandException(strings.get("mp.giveup", times));
    }

    private File getUniquePath(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException ioex) {
            f = SmartFile.sanitize(f);
        }
        return f;
    }
}

