/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.Result;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainXmlVerifier {
    private Domain domain;
    public boolean error;
    PrintStream _out;
    private static final LocalStringsImpl strings = new LocalStringsImpl(DomainXmlVerifier.class);

    public DomainXmlVerifier(Domain domain) throws Exception {
        this(domain, System.out);
    }

    public DomainXmlVerifier(Domain domain, PrintStream out) throws Exception {
        this.domain = domain;
        this._out = out;
        this.error = false;
    }

    public boolean invokeConfigValidator() {
        boolean failed = false;
        try {
            failed = this.validate();
        }
        catch (Exception e) {
            failed = true;
            e.printStackTrace();
        }
        return failed;
    }

    public boolean validate() {
        try {
            this.checkUnique(this.domain);
            if (!this.error) {
                this._out.println(strings.get("VerifySuccess"));
            }
        }
        catch (Exception e) {
            this.error = true;
            e.printStackTrace();
        }
        return this.error;
    }

    public void checkUnique(Domain domain) {
        try {
            Resources resources = domain.getResources();
            Collection<ConnectorConnectionPool> connectionPoolList = resources.getResources(ConnectorConnectionPool.class);
            this.checkDuplicate(connectionPoolList);
            for (ConnectorConnectionPool ccp : connectionPoolList) {
                List<SecurityMap> secMapList = ccp.getSecurityMap();
                this.checkDuplicate(secMapList);
            }
            Configs configs = domain.getConfigs();
            if (configs != null) {
                List<Config> configList = configs.getConfig();
                this.checkDuplicate(configList);
                if (configList != null) {
                    for (Config cfg : configList) {
                        SecurityService securitysvc;
                        JmsService jmsService;
                        AdminService adminsvc;
                        IiopService iiopSvc;
                        HttpService httpSvc = cfg.getHttpService();
                        if (httpSvc != null) {
                            List<HttpListener> httpListeners = httpSvc.getHttpListener();
                            this.checkDuplicate(httpListeners);
                            List<VirtualServer> virtualServers = httpSvc.getVirtualServer();
                            this.checkDuplicate(virtualServers);
                        }
                        if ((iiopSvc = cfg.getIiopService()) != null) {
                            List<IiopListener> iiopListeners = iiopSvc.getIiopListener();
                            this.checkDuplicate(iiopListeners);
                        }
                        if ((adminsvc = cfg.getAdminService()) != null) {
                            List<JmxConnector> jmxConnectors = adminsvc.getJmxConnector();
                            this.checkDuplicate(jmxConnectors);
                        }
                        if ((jmsService = cfg.getJmsService()) != null) {
                            List<JmsHost> jmsHosts = jmsService.getJmsHost();
                            this.checkDuplicate(jmsHosts);
                        }
                        if ((securitysvc = cfg.getSecurityService()) == null) continue;
                        List<AuditModule> auditModules = securitysvc.getAuditModule();
                        this.checkDuplicate(auditModules);
                        List<AuthRealm> authrealms = securitysvc.getAuthRealm();
                        this.checkDuplicate(authrealms);
                        List<JaccProvider> providers = securitysvc.getJaccProvider();
                        this.checkDuplicate(providers);
                    }
                }
            }
        }
        catch (Exception e) {
            this.error = true;
            e.printStackTrace();
        }
    }

    public void output(Result result) {
        this._out.println(strings.get("VerifyError", result.result()));
    }

    public void checkDuplicate(Collection<? extends ConfigBeanProxy> beans) {
        if (beans == null) {
            return;
        }
        WeakHashMap<String, Dom> keyBeanMap = new WeakHashMap<String, Dom>();
        ArrayList<String> keys = new ArrayList<String>(beans.size());
        for (ConfigBeanProxy configBeanProxy : beans) {
            String key = Dom.unwrap(configBeanProxy).getKey();
            keyBeanMap.put(key, Dom.unwrap(configBeanProxy));
            keys.add(key);
        }
        WeakHashMap errorKeyBeanMap = new WeakHashMap();
        String[] stringArray = keys.toArray(new String[beans.size()]);
        block1: for (int i = 0; i < stringArray.length; ++i) {
            boolean foundDuplicate = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[i].equals(stringArray[j]) || i == j) continue;
                foundDuplicate = true;
                errorKeyBeanMap.put(stringArray[i], ((Dom)keyBeanMap.get(stringArray[i])).getProxyType());
                this.error = true;
                continue block1;
            }
        }
        for (Object errorKey : errorKeyBeanMap.keySet()) {
            Result<String> result = new Result<String>(strings.get("VerifyDupKey", errorKey, errorKeyBeanMap.get(errorKey)));
            this.output(result);
        }
    }
}

