/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.NonSMFServiceAdapter;
import com.sun.enterprise.admin.servermgmt.services.ServicesUtils;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WindowsService
extends NonSMFServiceAdapter {
    private static final String SOURCE_WIN32_EXE_FILENAME = "winsw.exe";
    private static final String TARGET_DIR = "bin";
    private static final String TEMPLATE_FILE_NAME = "Domain-service-winsw.xml.template";
    private File sourceWin32Exe;
    private File targetDir;
    private File targetXml;
    private File targetWin32Exe;
    private String xmlFileCopy;

    static boolean apropos() {
        return OS.isWindowsForSure();
    }

    WindowsService(ServerDirs dirs, AppserverServiceType type2) {
        super(dirs, type2);
        if (!WindowsService.apropos()) {
            throw new IllegalArgumentException(Strings.get("internal.error", "Constructor called but Windows Services are not available."));
        }
    }

    public final void createServiceInternal() throws RuntimeException {
        try {
            this.handlePreExisting(this.targetWin32Exe, this.targetXml, this.info.force);
            FileUtils.copy(this.sourceWin32Exe, this.targetWin32Exe);
            this.trace("Copied from " + this.sourceWin32Exe + " to " + this.targetWin32Exe);
            this.getTokenMap().put("CREDENTIALS_START", this.getAsadminCredentials("startargument"));
            this.getTokenMap().put("CREDENTIALS_STOP", this.getAsadminCredentials("stopargument"));
            ServicesUtils.tokenReplaceTemplateAtDestination(this.getTokenMap(), this.getTemplateFile().getPath(), this.targetXml.getPath());
            this.trace("Target XML file written: " + this.targetXml);
            this.trace("**********   Object Dump  **********\n" + this.toString());
            if (this.uninstall() == 0 && !this.info.dryRun) {
                this.trace(Strings.get("windows.services.uninstall.good"));
            } else {
                this.trace("No preexisting Service with that id and/or name was found");
            }
            this.install();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteServiceInternal() {
        try {
            if (!this.isInstalled()) {
                throw new RuntimeException(Strings.get("not_installed"));
            }
            if (!this.targetWin32Exe.canExecute()) {
                throw new RuntimeException(Strings.get("cant_exec"));
            }
            ProcessManager pm = new ProcessManager(this.targetWin32Exe.getAbsolutePath(), "stop");
            pm.setEcho(false);
            pm.execute();
            pm = new ProcessManager(this.targetWin32Exe.getAbsolutePath(), "uninstall");
            pm.setEcho(false);
            pm.execute();
            this.trace("Uninstalled Windows Service");
            if (!this.targetWin32Exe.delete()) {
                this.targetWin32Exe.deleteOnExit();
            }
            if (!this.targetXml.delete()) {
                this.targetXml.deleteOnExit();
            }
            this.trace("deleted " + this.targetWin32Exe + this.targetXml);
            this.trace(this.toString());
        }
        catch (ProcessManagerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final String getSuccessMessage() {
        if (this.info.dryRun) {
            return Strings.get("dryrun");
        }
        return Strings.get("WindowsServiceCreated", this.info.serviceName, this.getServerDirs().getServerName() + " GlassFish Server", this.getServerDirs().getServerDir(), this.targetXml, this.targetWin32Exe);
    }

    public final void writeReadmeFile(String msg) {
        File f = new File(this.getServerDirs().getServerDir(), "PlatformServices.log");
        if (StringUtils.ok(this.xmlFileCopy)) {
            msg = msg + this.xmlFileCopy;
        }
        ServicesUtils.appendTextToFile(f, msg);
    }

    public String toString() {
        return ObjectAnalyzer.toString(this);
    }

    public final String getLocationArgsStart() {
        if (this.isDomain()) {
            return this.makeStartArg("--domaindir") + this.makeStartArg(this.getServerDirs().getServerParentDir().getPath());
        }
        return this.makeStartArg("--nodedir") + this.makeStartArg(this.getServerDirs().getServerGrandParentDir().getPath().replace('\\', '/')) + this.makeStartArg("--node") + this.makeStartArg(this.getServerDirs().getServerParentDir().getName());
    }

    public final String getLocationArgsStop() {
        if (this.isDomain()) {
            return this.makeStopArg("--domaindir") + this.makeStopArg(this.getServerDirs().getServerParentDir().getPath());
        }
        return this.makeStopArg("--nodedir") + this.makeStopArg(this.getServerDirs().getServerGrandParentDir().getPath().replace('\\', '/')) + this.makeStopArg("--node") + this.makeStopArg(this.getServerDirs().getServerParentDir().getName());
    }

    public final void initializeInternal() {
        try {
            this.setTemplateFile(TEMPLATE_FILE_NAME);
            this.setSourceWin32Exe();
            this.targetDir = new File(this.getServerDirs().getServerDir(), TARGET_DIR);
            this.targetDir.mkdirs();
            if (!this.targetDir.isDirectory()) {
                throw new RuntimeException(Strings.get("noTargetDir", this.targetDir));
            }
            this.targetWin32Exe = new File(this.targetDir, this.getServerDirs().getServerName() + "Service.exe");
            this.targetXml = new File(this.targetDir, this.getServerDirs().getServerName() + "Service.xml");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isInstalled() {
        if (this.targetDir == null || this.targetWin32Exe == null || this.targetXml == null) {
            throw new RuntimeException(Strings.get("internal.error", "call to isInstall() before initializeInternal()"));
        }
        return this.targetWin32Exe.isFile() && this.targetXml.isFile();
    }

    private void setSourceWin32Exe() throws IOException {
        this.sourceWin32Exe = new File(this.info.libDir, SOURCE_WIN32_EXE_FILENAME);
        if (!this.sourceWin32Exe.isFile()) {
            InputStream in = this.getClass().getResourceAsStream("/lib/winsw.exe");
            FileOutputStream out = new FileOutputStream(this.sourceWin32Exe);
            WindowsService.copyStream(in, out);
            this.trace("Copied from inside the jar to " + this.sourceWin32Exe);
        }
        this.trace("Source executable: " + this.sourceWin32Exe);
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[16384];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    private String getAsadminCredentials(String elem) {
        if (this.info.passwordFile == null) {
            return " ";
        }
        String user = this.info.appserverUser;
        String begin = "<" + elem + ">";
        String end = "</" + elem + ">\n";
        StringBuilder sb = new StringBuilder();
        if (user != null) {
            StringBuilder append = sb.append(" " + begin + "--user" + end);
            sb.append("  ").append(begin).append(user).append(end);
        }
        sb.append("  ").append(begin).append("--passwordfile").append(end);
        sb.append("  ").append(begin).append(this.info.passwordFile.getPath()).append(end);
        sb.append("  ");
        return sb.toString();
    }

    private int uninstall() throws ProcessManagerException {
        if (this.info.dryRun || !this.targetWin32Exe.canExecute()) {
            return 0;
        }
        ProcessManager mgr = new ProcessManager(this.targetWin32Exe.getPath(), "uninstall");
        mgr.setEcho(false);
        mgr.execute();
        this.trace("Uninstall STDERR: " + mgr.getStderr());
        this.trace("Uninstall STDOUT: " + mgr.getStdout());
        return mgr.getExitValue();
    }

    private void install() throws ProcessManagerException {
        if (this.info.dryRun) {
            try {
                this.xmlFileCopy = Strings.get("xmlfiledump") + FileUtils.readSmallFile(this.targetXml);
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.targetXml.delete();
            this.targetWin32Exe.delete();
        } else {
            ProcessManager mgr = new ProcessManager(this.targetWin32Exe.getPath(), "install");
            mgr.setEcho(false);
            mgr.execute();
            int ret = mgr.getExitValue();
            if (ret != 0) {
                throw new RuntimeException(Strings.get("windows.services.install.bad", "" + ret, mgr.getStdout(), mgr.getStderr()));
            }
            this.trace("Install STDERR: " + mgr.getStderr());
            this.trace("Install STDOUT: " + mgr.getStdout());
        }
    }

    private void handlePreExisting(File targetWin32Exe, File targetXml, boolean force) {
        if (targetWin32Exe.exists() || targetXml.exists()) {
            if (force) {
                targetWin32Exe.delete();
                targetXml.delete();
                this.handlePreExisting(targetWin32Exe, targetXml, false);
            } else {
                throw new RuntimeException(Strings.get("services.alreadyCreated", new File(this.targetDir, this.getServerDirs().getServerName() + "Service").toString() + ".*", "del"));
            }
        }
    }

    private String makeStartArg(String s) {
        return "  <startargument>" + s + "</startargument>" + "\n";
    }

    private String makeStopArg(String s) {
        return "  <stopargument>" + s + "</stopargument>" + "\n";
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

