/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.enterprise.connectors.work.WorkManagerFactory;
import com.sun.logging.LogDomains;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;

public class WorkManagerProxy
implements WorkManager,
Externalizable {
    private transient WorkManager wm;
    private String moduleName;
    private static Logger _logger = LogDomains.getLogger(WorkManagerProxy.class, "javax.enterprise.resource.resourceadapter");

    public WorkManagerProxy(WorkManager wm, String moduleName) {
        this.wm = wm;
        this.moduleName = moduleName;
    }

    public WorkManagerProxy() {
    }

    public void doWork(Work work) throws WorkException {
        this.wm.doWork(work);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        this.wm.doWork(work, startTimeout, executionContext, workListener);
    }

    public long startWork(Work work) throws WorkException {
        return this.wm.startWork(work);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        return this.wm.startWork(work, startTimeout, executionContext, workListener);
    }

    public void scheduleWork(Work work) throws WorkException {
        this.wm.scheduleWork(work);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        this.wm.scheduleWork(work, startTimeout, executionContext, workListener);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.moduleName);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.moduleName = in.readUTF();
        this.wm = WorkManagerFactory.retrieveWorkManager(this.moduleName);
        _logger = LogDomains.getLogger(WorkManagerProxy.class, "javax.enterprise.resource.resourceadapter");
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof WorkManagerProxy) {
            WorkManagerProxy wmp = (WorkManagerProxy)o;
            equal = wmp.wm.equals(this.wm);
        }
        return equal;
    }

    public int hashCode() {
        return this.wm.hashCode();
    }
}

