/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractCommonAttributeHandler;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAuthAnnotationHandler
extends AbstractCommonAttributeHandler
implements PostProcessor {
    AbstractAuthAnnotationHandler() {
    }

    protected abstract void processEjbMethodSecurity(Annotation var1, MethodDescriptor var2, EjbDescriptor var3);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        if (!this.validateAccessControlAnnotations(ainfo)) {
            return this.getDefaultFailedResult();
        }
        Annotation authAnnotation = ainfo.getAnnotation();
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            for (Object next : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                Method m;
                MethodDescriptor md = (MethodDescriptor)next;
                if (this.hasMethodPermissionsFromDD(md, ejbDesc) || !TypeUtil.sameMethodSignature(m = md.getMethod(ejbDesc), annMethod)) continue;
                this.processEjbMethodSecurity(authAnnotation, md, ejbDesc);
            }
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        return this.getInvalidAnnotatedElementHandlerResult(webCompContexts[0], ainfo);
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.getInvalidAnnotatedElementHandlerResult(webBundleContext, ainfo);
    }

    @Override
    public void postProcessAnnotation(AnnotationInfo ainfo, AnnotatedElementHandler aeHandler) throws AnnotationProcessorException {
        EjbContext ejbContext = (EjbContext)aeHandler;
        EjbDescriptor ejbDesc = ejbContext.getDescriptor();
        Annotation authAnnotation = ainfo.getAnnotation();
        if (!(ejbContext.isInherited() || ejbDesc.getMethodPermissionsFromDD() != null && ejbDesc.getMethodPermissionsFromDD().size() != 0)) {
            for (MethodDescriptor md : this.getMethodAllDescriptors(ejbDesc)) {
                this.processEjbMethodSecurity(authAnnotation, md, ejbDesc);
            }
        } else {
            Class classAn = (Class)ainfo.getAnnotatedElement();
            for (Object next : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                MethodDescriptor md = (MethodDescriptor)next;
                Method m = md.getMethod(ejbDesc);
                if (!classAn.equals(ejbContext.getDeclaringClass(md)) || this.hasMethodPermissionsFromDD(md, ejbDesc)) continue;
                this.processEjbMethodSecurity(authAnnotation, md, ejbDesc);
            }
        }
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    protected Class<? extends Annotation>[] relatedAnnotationTypes() {
        return new Class[0];
    }

    private Set<MethodDescriptor> getMethodAllDescriptors(EjbDescriptor ejbDesc) {
        HashSet<MethodDescriptor> methodAlls = new HashSet<MethodDescriptor>();
        if (ejbDesc.isRemoteInterfacesSupported() || ejbDesc.isRemoteBusinessInterfacesSupported()) {
            methodAlls.add(new MethodDescriptor("*", "", "Remote"));
            if (ejbDesc.isRemoteInterfacesSupported()) {
                methodAlls.add(new MethodDescriptor("*", "", "Home"));
            }
        }
        if (ejbDesc.isLocalInterfacesSupported() || ejbDesc.isLocalBusinessInterfacesSupported()) {
            methodAlls.add(new MethodDescriptor("*", "", "Local"));
            if (ejbDesc.isLocalInterfacesSupported()) {
                methodAlls.add(new MethodDescriptor("*", "", "LocalHome"));
            }
        }
        if (ejbDesc.isLocalBean()) {
            methodAlls.add(new MethodDescriptor("*", "", "Local"));
        }
        if (ejbDesc.hasWebServiceEndpointInterface()) {
            methodAlls.add(new MethodDescriptor("*", "", "ServiceEndpoint"));
        }
        return methodAlls;
    }

    private boolean hasMethodPermissionsFromDD(MethodDescriptor methodDesc, EjbDescriptor ejbDesc) {
        HashMap methodPermissionsFromDD = ejbDesc.getMethodPermissionsFromDD();
        if (methodPermissionsFromDD != null) {
            Set allMethods = ejbDesc.getMethodDescriptors();
            String ejbClassSymbol = methodDesc.getEjbClassSymbol();
            for (Object mdObjsObj : methodPermissionsFromDD.values()) {
                List mdObjs = (List)mdObjsObj;
                for (Object mdObj : mdObjs) {
                    MethodDescriptor md = (MethodDescriptor)mdObj;
                    for (Object style3MdObj : md.doStyleConversion(ejbDesc, allMethods)) {
                        MethodDescriptor style3Md = (MethodDescriptor)style3MdObj;
                        if (!methodDesc.equals(style3Md)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean validateAccessControlAnnotations(AnnotationInfo ainfo) throws AnnotationProcessorException {
        boolean validity = true;
        AnnotatedElement ae = ainfo.getAnnotatedElement();
        int count = 0;
        boolean hasDenyAll = false;
        count += ae.isAnnotationPresent(RolesAllowed.class) ? 1 : 0;
        if (ae.isAnnotationPresent(DenyAll.class)) {
            ++count;
            hasDenyAll = true;
        }
        if (count < 2 && ae.isAnnotationPresent(PermitAll.class)) {
            ++count;
        }
        if (count > 1) {
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.morethanoneauthannotation", "One cannot have more than one of @RolesAllowed, @PermitAll, @DenyAll in the same AnnotatedElement."));
            validity = false;
        }
        return validity;
    }
}

