/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import javax.resource.spi.AuthenticationMechanism;
import javax.resource.spi.Connector;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AuthenticationMechanismHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractHandler.class);

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return AuthenticationMechanism.class;
    }

    @Override
    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        AuthenticationMechanism authMechanism = (AuthenticationMechanism)element.getAnnotation();
        if (aeHandler instanceof RarBundleContext) {
            boolean isConnectionDefinition = this.hasConnectorAnnotation(element);
            if (isConnectionDefinition) {
                OutboundResourceAdapter ora;
                RarBundleContext rarContext = (RarBundleContext)aeHandler;
                ConnectorDescriptor desc = rarContext.getDescriptor();
                if (!desc.getOutBoundDefined()) {
                    ora = new OutboundResourceAdapter();
                    desc.setOutboundResourceAdapter(ora);
                }
                ora = desc.getOutboundResourceAdapter();
                String[] description = authMechanism.description();
                int authMechanismValue = this.getAuthMechVal(authMechanism.authMechanism());
                AuthenticationMechanism.CredentialInterface ci = authMechanism.credentialInterface();
                String credentialInterface = OutboundResourceAdapter.getCredentialInterfaceName(ci);
                String firstDesc = "";
                if (description.length > 0) {
                    firstDesc = description[0];
                }
                AuthMechanism auth = new AuthMechanism(firstDesc, authMechanismValue, credentialInterface);
                ora.addAuthMechanism(auth);
            } else {
                this.getFailureResult(element, "Not a @Connector annotation : @AuthenticationMechanism must be specified along with @Connector annotation", true);
            }
        } else {
            this.getFailureResult(element, "Not a rar bundle context", true);
        }
        return this.getDefaultProcessedResult();
    }

    private boolean hasConnectorAnnotation(AnnotationInfo element) {
        Class c = (Class)element.getAnnotatedElement();
        return c.getAnnotation(Connector.class) != null;
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getConnectorAnnotationTypes();
    }

    @Override
    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), ResultType.PROCESSED);
    }

    public int getAuthMechVal(String value) {
        int authMechVal;
        if (value.trim().equals("BasicPassword")) {
            authMechVal = 0;
        } else if (value.trim().equals("Kerbv5")) {
            authMechVal = 1;
        } else {
            throw new IllegalArgumentException("Invalid auth-mech-type");
        }
        return authMechVal;
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            Class c = (Class)element.getAnnotatedElement();
            String className = c.getName();
            Object[] args = new Object[]{element.getAnnotation(), className, message};
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.connectorannotationfailure", "failed to handle annotation [ {0} ] on class [ {1} ], reason : {2}", args);
            this.logger.log(Level.WARNING, localString);
        }
        return result;
    }
}

