/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.web.ServletMappingNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.net.URLPattern;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebResourceCollectionNode
extends DeploymentDescriptorNode {
    private WebResourceCollectionImpl descriptor;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServletMappingNode.class);

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (WebResourceCollectionImpl)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    protected XMLElement getXMLRootTag() {
        return new XMLElement("web-resource-collection");
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("web-resource-name", "setName");
        table.put("http-method", "addHttpMethod");
        table.put("http-method-omission", "addHttpMethodOmission");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("url-pattern".equals(element.getQName())) {
            if (!URLPattern.isValid(value)) {
                String trimmedUrl = value.trim();
                Object parent = this.getParentNode().getParentNode().getDescriptor();
                if (parent instanceof WebBundleDescriptor && ((WebBundleDescriptor)parent).getSpecVersion().equals("2.2") && !trimmedUrl.startsWith("/") && !trimmedUrl.startsWith("*.")) {
                    trimmedUrl = "/" + trimmedUrl;
                }
                if (URLPattern.isValid(trimmedUrl)) {
                    if (URLPattern.containsCRorLF(value)) {
                        DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.urlcontainscrlf", new Object[]{value});
                    }
                    value = trimmedUrl;
                } else {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.invalidurlpattern", "Invalid URL Pattern: [{0}]", value));
                }
            }
            this.descriptor.addUrlPattern(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebResourceCollectionImpl descriptor) {
        Element myNode = WebResourceCollectionNode.appendChild(parent, nodeName);
        WebResourceCollectionNode.appendTextChild((Node)myNode, "web-resource-name", descriptor.getName());
        this.writeLocalizedDescriptions(myNode, descriptor);
        for (String urlPattern : descriptor.getUrlPatterns()) {
            WebResourceCollectionNode.appendTextChild((Node)myNode, "url-pattern", urlPattern);
        }
        for (String httpMethod : descriptor.getHttpMethods()) {
            WebResourceCollectionNode.appendTextChild((Node)myNode, "http-method", httpMethod);
        }
        for (String httpMethodOmission : descriptor.getHttpMethodOmissions()) {
            WebResourceCollectionNode.appendTextChild((Node)myNode, "http-method-omission", httpMethodOmission);
        }
        return myNode;
    }
}

