/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.JavaURLContext;
import com.sun.enterprise.naming.impl.NamedNamingObjectManager;
import com.sun.enterprise.naming.impl.ProviderManager;
import com.sun.enterprise.naming.impl.SerialContextProvider;
import com.sun.enterprise.naming.impl.SerialInitContextFactory;
import com.sun.enterprise.naming.impl.SerialNameParser;
import com.sun.enterprise.naming.util.LogFacade;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.rmi.PortableRemoteObject;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ORBLocator;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class SerialContext
implements Context {
    private static final int MAX_LEVEL = 5;
    private static final String JAVA_URL = "java:";
    private static final String JAVA_GLOBAL_URL = "java:global/";
    static final String INITIAL_CONTEXT_TEST_MODE = "com.sun.enterprise.naming.TestMode";
    private static final Logger _logger = LogFacade.getLogger();
    private static final NameParser myParser = new SerialNameParser();
    private static final Map<ProviderCacheKey, SerialContextProvider> providerCache = new HashMap<ProviderCacheKey, SerialContextProvider>();
    private static final ThreadLocal<ThreadLocalIC> stickyContext = new ThreadLocal<ThreadLocalIC>(){

        @Override
        protected ThreadLocalIC initialValue() {
            return new ThreadLocalIC();
        }
    };
    private Hashtable myEnv = null;
    private SerialContextProvider provider;
    private final String myName;
    private final JavaURLContext javaUrlContext;
    private Habitat habitat;
    private boolean testMode = false;
    private ProcessEnvironment.ProcessType processType = ProcessEnvironment.ProcessType.Server;
    private ORB orbFromEnv;
    private String targetHost;
    private String targetPort;
    private ORB orb = null;
    private boolean intraServerLookups;
    private ClassLoader commonCL;

    static Context getStickyContext() {
        return stickyContext.get().getContext();
    }

    private void grabSticky() {
        stickyContext.get().grab(this);
    }

    private void releaseSticky() {
        stickyContext.get().release();
    }

    static void clearSticky() {
        stickyContext.get().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public SerialContext(String name, Hashtable environment, Habitat h) throws NamingException {
        this.habitat = h;
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
        this.myEnv.put("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        this.myEnv.put("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        this.myName = name;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SerialContext ==> SerialContext instance created : " + this);
        }
        if (this.myEnv.get(INITIAL_CONTEXT_TEST_MODE) != null) {
            this.testMode = true;
            System.out.println("SerialContext in test mode");
        }
        if (this.habitat == null && !this.testMode) {
            Class<SerialContext> clazz = SerialContext.class;
            // MONITORENTER : com.sun.enterprise.naming.impl.SerialContext.class
            if (SerialInitContextFactory.getDefaultHabitat() == null) {
                this.habitat = Globals.getStaticHabitat();
                SerialInitContextFactory.setDefaultHabitat(this.habitat);
            } else {
                this.habitat = SerialInitContextFactory.getDefaultHabitat();
            }
            // MONITOREXIT : clazz
        }
        if (this.testMode) {
            this.processType = ProcessEnvironment.ProcessType.Server;
        } else {
            ProcessEnvironment processEnv = this.habitat.getComponent(ProcessEnvironment.class);
            this.processType = processEnv.getProcessType();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Serial Context initializing with process environment {0}", processEnv);
            }
        }
        JavaURLContext urlContextTemp = null;
        urlContextTemp = this.myEnv.get("com.sun.appserv.ee.iiop.endpointslist") != null ? new JavaURLContext(this.myEnv, this) : new JavaURLContext(this.myEnv, null);
        this.javaUrlContext = urlContextTemp;
        this.orbFromEnv = (ORB)this.myEnv.get("java.naming.corba.orb");
        String targetHostFromEnv = (String)this.myEnv.get("org.omg.CORBA.ORBInitialHost");
        String targetPortFromEnv = (String)this.myEnv.get("org.omg.CORBA.ORBInitialPort");
        boolean bl = this.intraServerLookups = this.processType.isServer() && this.orbFromEnv == null && targetHostFromEnv == null && targetPortFromEnv == null;
        if (targetHostFromEnv != null) {
            this.targetHost = targetHostFromEnv;
            if (targetPortFromEnv == null) {
                this.targetPort = "3700";
            }
        }
        if (targetPortFromEnv != null) {
            this.targetPort = targetPortFromEnv;
            if (targetHostFromEnv == null) {
                this.targetHost = "localhost";
            }
        }
        this.orb = this.orbFromEnv;
        if (this.habitat == null) return;
        ServerContext sc = this.habitat.getByContract(ServerContext.class);
        if (sc == null) return;
        this.commonCL = sc.getCommonClassLoader();
    }

    public SerialContext(Hashtable env, Habitat habitat) throws NamingException {
        this("", env, habitat);
    }

    private SerialContextProvider getProvider() throws NamingException {
        SerialContextProvider returnValue = this.provider;
        if (this.provider == null) {
            try {
                returnValue = this.intraServerLookups ? ProviderManager.getProviderManager().getLocalProvider() : this.getRemoteProvider();
            }
            catch (Exception e) {
                SerialContext.clearSticky();
                e.printStackTrace();
                NamingException ne = new NamingException("Unable to acquire SerialContextProvider for " + this);
                ne.initCause(e);
                throw ne;
            }
        }
        return returnValue;
    }

    private ORB getORB() {
        ORBLocator orbHelper = this.habitat.getComponent(ORBLocator.class);
        if (this.orb == null) {
            this.orb = orbHelper.getORB();
        }
        return this.orb;
    }

    private ProviderCacheKey getProviderCacheKey() {
        ORB myORB = this.getORB();
        String eplist = null;
        if (this.myEnv != null) {
            eplist = (String)this.myEnv.get("com.sun.appserv.ee.iiop.endpointslist");
        }
        ProviderCacheKey key = eplist != null ? new ProviderCacheKey(eplist) : (this.targetHost == null ? new ProviderCacheKey(myORB) : new ProviderCacheKey(this.targetHost, this.targetPort));
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProvider() {
        ProviderCacheKey key = this.getProviderCacheKey();
        Class<SerialContext> clazz = SerialContext.class;
        synchronized (SerialContext.class) {
            providerCache.remove(key);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.provider = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SerialContextProvider getRemoteProvider() throws Exception {
        if (this.provider != null) return this.provider;
        ProviderCacheKey key = this.getProviderCacheKey();
        Class<SerialContext> clazz = SerialContext.class;
        synchronized (SerialContext.class) {
            SerialContextProvider cachedProvider = providerCache.get(key);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (cachedProvider == null) {
                SerialContextProvider newProvider = key.getNameService();
                Class<SerialContext> clazz2 = SerialContext.class;
                synchronized (SerialContext.class) {
                    cachedProvider = providerCache.get(key);
                    if (cachedProvider == null) {
                        providerCache.put(key, newProvider);
                        this.provider = newProvider;
                    } else {
                        this.provider = cachedProvider;
                    }
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return this.provider;
                }
            } else {
                this.provider = cachedProvider;
            }
            return this.provider;
        }
    }

    public String getNameInNamespace() throws NamingException {
        return this.myName;
    }

    private boolean isjavaURL(String name) {
        return name.startsWith(JAVA_URL) && !name.startsWith(JAVA_GLOBAL_URL);
    }

    public java.lang.Object lookup(String name) throws NamingException {
        return this.lookup(name, 0);
    }

    private java.lang.Object lookup(String name, int level) throws NamingException {
        boolean useSticky;
        NamedNamingObjectManager.checkAndLoadProxies(this.habitat);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SerialContext ==> lookup( {0})", name);
        }
        boolean bl = useSticky = this.myEnv.get("com.sun.appserv.ee.iiop.endpointslist") != null;
        if (useSticky) {
            this.grabSticky();
        }
        try {
            java.lang.Object retObj;
            if (name.isEmpty()) {
                SerialContext serialContext = new SerialContext(this.myName, this.myEnv, this.habitat);
                return serialContext;
            }
            name = this.getRelativeName(name);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SerialContext ==> lookup relative name : {0}", name);
            }
            if (this.isjavaURL(name)) {
                java.lang.Object o = this.javaUrlContext.lookup(name);
                if (o instanceof Reference) {
                    o = this.getObjectInstance(name, o);
                }
                java.lang.Object object = o;
                return object;
            }
            SerialContextProvider provider = this.getProvider();
            java.lang.Object obj = provider.lookup(name);
            if (obj instanceof NamingObjectProxy) {
                java.lang.Object object = ((NamingObjectProxy)obj).create(this);
                return object;
            }
            if (obj instanceof Context) {
                SerialContext serialContext = new SerialContext(name, this.myEnv, this.habitat);
                return serialContext;
            }
            java.lang.Object object = retObj = this.getObjectInstance(name, obj);
            return object;
        }
        catch (NamingException nnfe) {
            NamingException ne = new NamingException("Lookup failed for '" + name + "' in " + this);
            ne.initCause(nnfe);
            throw ne;
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "enterprise_naming.serialctx_communication_exception", name);
            _logger.log(Level.FINE, "", ex);
            int nextLevel = level + 1;
            if (ex instanceof MarshalException && ex.getCause() instanceof COMM_FAILURE && nextLevel < 5) {
                this.clearProvider();
                _logger.fine("Resetting provider to NULL. Will get new obj ref for provider since previous obj ref was stale...");
                java.lang.Object retObj = this.lookup(name, nextLevel);
                return retObj;
            }
            CommunicationException ce = new CommunicationException("Communication exception for " + this);
            ce.initCause(ex);
            throw ce;
        }
        finally {
            if (useSticky) {
                this.releaseSticky();
            }
        }
    }

    private java.lang.Object getObjectInstance(String name, java.lang.Object obj) throws Exception {
        Reference ref;
        ClassLoader tccl;
        java.lang.Object retObj = NamingManager.getObjectInstance(obj, new CompositeName(name), null, this.myEnv);
        if (retObj == obj && (tccl = Thread.currentThread().getContextClassLoader()) != this.commonCL && (ref = this.getReference(obj)) != null) {
            _logger.logp(Level.FINE, "SerialContext", "getObjectInstance", "Trying with CommonClassLoader for name {0} ", new java.lang.Object[]{name});
            ObjectFactory factory = this.getObjectFactory(ref, this.commonCL);
            if (factory != null) {
                retObj = factory.getObjectInstance(ref, new CompositeName(name), null, this.myEnv);
            }
            if (retObj != obj) {
                _logger.logp(Level.FINE, "SerialContext", "getObjectInstance", "Found with CommonClassLoader");
            }
        }
        return retObj;
    }

    private Reference getReference(java.lang.Object obj) throws NamingException {
        Reference ref = null;
        if (obj instanceof Reference) {
            ref = (Reference)obj;
        } else if (obj instanceof Referenceable) {
            ref = ((Referenceable)obj).getReference();
        }
        return ref;
    }

    private ObjectFactory getObjectFactory(Reference ref, ClassLoader cl) throws IllegalAccessException, InstantiationException {
        String factoryName = ref.getFactoryClassName();
        if (factoryName != null) {
            try {
                Class<?> c = Class.forName(factoryName, false, cl);
                return (ObjectFactory)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.bind(name, obj);
        } else {
            try {
                this.getProvider().bind(name, obj);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void bind(Name name, java.lang.Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.rebind(name, obj);
        } else {
            try {
                this.getProvider().rebind(name, obj);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.unbind(name);
        } else {
            try {
                this.getProvider().unbind(name);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        oldname = this.getRelativeName(oldname);
        newname = this.getRelativeName(newname);
        if (this.isjavaURL(oldname)) {
            this.javaUrlContext.rename(oldname, newname);
        } else {
            try {
                this.getProvider().rename(oldname, newname);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.isEmpty()) {
            try {
                Hashtable bindings = this.getProvider().list(this.myName);
                return new RepNames(bindings);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.list(name);
        }
        java.lang.Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.isEmpty()) {
            try {
                Hashtable bindings = this.getProvider().list(this.myName);
                return new RepBindings(bindings);
            }
            catch (RemoteException ex) {
                CommunicationException ce = new CommunicationException(ex.toString());
                ce.initCause(ex);
                throw ce;
            }
        }
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.listBindings(name);
        }
        java.lang.Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.destroySubcontext(name);
        } else {
            try {
                this.getProvider().destroySubcontext(name);
            }
            catch (RemoteException e) {
                CommunicationException ce = new CommunicationException(e.toString());
                ce.initCause(e);
                throw ce;
            }
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        Context c = null;
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.createSubcontext(name);
        }
        try {
            c = this.getProvider().createSubcontext(name);
            if (c instanceof Context) {
                c = new SerialContext(name, this.myEnv, this.habitat);
            }
        }
        catch (RemoteException e) {
            CommunicationException ce = new CommunicationException(e.toString());
            ce.initCause(e);
            throw ce;
        }
        return c;
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.lookupLink(name);
        }
        return this.lookup(name);
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public java.lang.Object addToEnvironment(String propName, java.lang.Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    private String getRelativeName(String name) {
        if (!this.myName.equals("")) {
            name = this.myName + "/" + name;
        }
        return name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SerialContext[");
        if (this.testMode) {
            sb.append("( IN TEST MODE ) ");
        }
        sb.append("myEnv=");
        sb.append(this.myEnv);
        return sb.toString();
    }

    private class ProviderCacheKey {
        private ORB localORB = null;
        private String endpoints = null;

        ProviderCacheKey(ORB orb) {
            this.localORB = orb;
        }

        ProviderCacheKey(String host, String port) {
            this.endpoints = "corbaloc:iiop:1.2@" + host + ":" + port + "/NameService";
        }

        ProviderCacheKey(String endpoints) {
            this.endpoints = endpoints;
        }

        public String toString() {
            if (this.localORB == null) {
                return "ProviderCacheKey[" + this.endpoints + "]";
            }
            return "ProviderCacheKey[" + this.localORB + "]";
        }

        public SerialContextProvider getNameService() throws org.omg.CORBA.ORBPackage.InvalidName, NotFound, CannotProceed, InvalidName {
            Object objref = null;
            objref = this.endpoints == null ? SerialContext.this.orb.resolve_initial_references("NameService") : SerialContext.this.orb.string_to_object(this.endpoints);
            NamingContext nctx = NamingContextHelper.narrow(objref);
            NameComponent[] path = new NameComponent[]{new NameComponent("SerialContextProvider", "")};
            Object obj = nctx.resolve(path);
            SerialContextProvider result = (SerialContextProvider)PortableRemoteObject.narrow((java.lang.Object)obj, SerialContextProvider.class);
            return result;
        }

        public int hashCode() {
            return SerialContext.this.orb != null ? SerialContext.this.orb.hashCode() : this.endpoints.hashCode();
        }

        public boolean equals(java.lang.Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof ProviderCacheKey)) {
                return false;
            }
            ProviderCacheKey otherKey = (ProviderCacheKey)other;
            if (this.localORB != null) {
                return this.localORB == otherKey.localORB;
            }
            if (this.endpoints == null) {
                return otherKey.endpoints == null;
            }
            return this.endpoints.equals(otherKey.endpoints);
        }
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;
        Hashtable bindings;

        RepBindings(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public java.lang.Object nextElement() {
            if (this.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                return new Binding(name, this.bindings.get(name));
            }
            return null;
        }

        public java.lang.Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }

    class RepNames
    implements NamingEnumeration {
        Hashtable bindings;
        Enumeration names;

        RepNames(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public java.lang.Object nextElement() {
            if (this.names.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                String className = this.bindings.get(name).getClass().getName();
                return new NameClassPair(name, className);
            }
            return null;
        }

        public java.lang.Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }

    private static class ThreadLocalIC {
        private Context ctx = null;
        private int count = 0;

        private ThreadLocalIC() {
        }

        Context getContext() {
            return this.ctx;
        }

        void grab(Context context) {
            if (this.ctx == null) {
                this.ctx = context;
            }
            ++this.count;
        }

        void release() {
            if (this.count > 0) {
                --this.count;
                if (this.count == 0) {
                    this.ctx = null;
                }
            } else {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "SerialContext: attempt to release StickyContext  without grab");
                }
                this.ctx = null;
            }
        }

        void clear() {
            this.ctx = null;
            this.count = 0;
        }
    }
}

