/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.SecurityMapUtils;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.deployer.GlobalResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resource.common.PoolInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ConnectorConnectionPoolDeployer
extends GlobalResourceDeployer
implements ResourceDeployer {
    @Inject
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(ConnectorConnectionPoolDeployer.class, "javax.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(ConnectorConnectionPoolDeployer.class);

    @Override
    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ConnectorConnectionPool domainCcp;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ConnectorConnectionPoolDeployer : deployResource ");
        }
        if (ConnectionPoolObjectsUtils.isPoolSystemPool(domainCcp = (ConnectorConnectionPool)resource)) {
            this.redeployResource(resource);
            return;
        }
        PoolInfo poolInfo = new PoolInfo(domainCcp.getName(), applicationName, moduleName);
        com.sun.enterprise.connectors.ConnectorConnectionPool ccp = this.getConnectorConnectionPool(domainCcp, poolInfo);
        String rarName = domainCcp.getResourceAdapterName();
        String connDefName = domainCcp.getConnectionDefinitionName();
        List<Property> props = domainCcp.getProperty();
        List<SecurityMap> securityMaps = domainCcp.getSecurityMap();
        this.populateConnectorConnectionPool(ccp, connDefName, rarName, props, securityMaps);
        String defName = domainCcp.getConnectionDefinitionName();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Calling backend to add connectorConnectionPool", domainCcp.getResourceAdapterName());
        }
        this.runtime.createConnectorConnectionPool(ccp, defName, domainCcp.getResourceAdapterName(), domainCcp.getProperty(), domainCcp.getSecurityMap());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Added connectorConnectionPool in backend", domainCcp.getResourceAdapterName());
        }
    }

    @Override
    public void deployResource(Object resource) throws Exception {
        ConnectorConnectionPool ccp = (ConnectorConnectionPool)resource;
        PoolInfo poolInfo = ConnectorsUtil.getPoolInfo(ccp);
        this.deployResource(resource, poolInfo.getApplicationName(), poolInfo.getModuleName());
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ConnectorConnectionPoolDeployer : undeployResource : ");
        }
        ConnectorConnectionPool domainCcp = (ConnectorConnectionPool)resource;
        PoolInfo poolInfo = new PoolInfo(domainCcp.getName(), applicationName, moduleName);
        this.actualUndeployResource(domainCcp, poolInfo);
    }

    @Override
    public synchronized void undeployResource(Object resource) throws Exception {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ConnectorConnectionPoolDeployer : undeployResource : ");
        }
        ConnectorConnectionPool domainCcp = (ConnectorConnectionPool)resource;
        PoolInfo poolInfo = ConnectorsUtil.getPoolInfo(domainCcp);
        this.actualUndeployResource(domainCcp, poolInfo);
    }

    private void actualUndeployResource(ConnectorConnectionPool domainCcp, PoolInfo poolInfo) throws ConnectorRuntimeException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Calling backend to delete ConnectorConnectionPool", domainCcp);
        }
        this.runtime.deleteConnectorConnectionPool(poolInfo);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Deleted ConnectorConnectionPool in backend", domainCcp);
        }
    }

    @Override
    public synchronized void redeployResource(Object resource) throws Exception {
        ConnectorConnectionPool domainCcp = (ConnectorConnectionPool)resource;
        List<SecurityMap> securityMaps = domainCcp.getSecurityMap();
        PoolInfo poolInfo = ConnectorsUtil.getPoolInfo(domainCcp);
        if (!this.runtime.isConnectorConnectionPoolDeployed(poolInfo)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("The connector connection pool " + poolInfo + " is either not referred or not yet created in " + "this server instance and pool and hence " + "redeployment is ignored");
            }
            return;
        }
        String rarName = domainCcp.getResourceAdapterName();
        String connDefName = domainCcp.getConnectionDefinitionName();
        List<Property> props = domainCcp.getProperty();
        com.sun.enterprise.connectors.ConnectorConnectionPool ccp = this.getConnectorConnectionPool(domainCcp, poolInfo);
        this.populateConnectorConnectionPool(ccp, connDefName, rarName, props, securityMaps);
        boolean poolRecreateRequired = false;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Calling reconfigure pool");
            }
            poolRecreateRequired = this.runtime.reconfigureConnectorConnectionPool(ccp, new HashSet());
        }
        catch (ConnectorRuntimeException cre) {
            Object[] params = new Object[]{poolInfo, cre};
            _logger.log(Level.WARNING, "error.reconfiguring.pool", params);
        }
        if (poolRecreateRequired) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Pool recreation required");
            }
            this.runtime.recreateConnectorConnectionPool(ccp);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Pool recreation done");
            }
        }
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof ConnectorConnectionPool;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    @Override
    public synchronized void disableResource(Object resource) throws Exception {
    }

    @Override
    public synchronized void enableResource(Object resource) throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     */
    private com.sun.enterprise.connectors.ConnectorConnectionPool getConnectorConnectionPool(ConnectorConnectionPool domainCcp, PoolInfo poolInfo) throws Exception {
        com.sun.enterprise.connectors.ConnectorConnectionPool ccp = new com.sun.enterprise.connectors.ConnectorConnectionPool(poolInfo);
        ccp.setSteadyPoolSize(domainCcp.getSteadyPoolSize());
        ccp.setMaxPoolSize(domainCcp.getMaxPoolSize());
        ccp.setMaxWaitTimeInMillis(domainCcp.getMaxWaitTimeInMillis());
        ccp.setPoolResizeQuantity(domainCcp.getPoolResizeQuantity());
        ccp.setIdleTimeoutInSeconds(domainCcp.getIdleTimeoutInSeconds());
        ccp.setFailAllConnections(Boolean.valueOf(domainCcp.getFailAllConnections()));
        ccp.setAuthCredentialsDefinedInPool(this.isAuthCredentialsDefinedInPool(domainCcp));
        ccp.setConnectionValidationRequired(Boolean.valueOf(domainCcp.getIsConnectionValidationRequired()));
        String txSupport = domainCcp.getTransactionSupport();
        int txSupportIntVal = this.parseTransactionSupportString(txSupport);
        if (txSupportIntVal == -1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Got transaction-support attr null from domain.xml");
            }
            txSupportIntVal = ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(domainCcp.getResourceAdapterName());
        } else if (!ConnectionPoolObjectsUtils.isTxSupportConfigurationSane(txSupportIntVal, domainCcp.getResourceAdapterName())) {
            String i18nMsg = localStrings.getString("ccp_deployer.incorrect_tx_support");
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.incorrect_tx_support", ccp.getName());
            throw cre;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("setting txSupportVal to " + txSupportIntVal + " in pool " + domainCcp.getName());
        }
        ccp.setTransactionSupport(txSupportIntVal);
        ccp.setNonComponent(false);
        ccp.setNonTransactional(false);
        ccp.setConnectionLeakTracingTimeout(domainCcp.getConnectionLeakTimeoutInSeconds());
        ccp.setConnectionReclaim(Boolean.valueOf(domainCcp.getConnectionLeakReclaim()));
        ccp.setMatchConnections(Boolean.valueOf(domainCcp.getMatchConnections()));
        ccp.setAssociateWithThread(Boolean.valueOf(domainCcp.getAssociateWithThread()));
        ccp.setPooling(Boolean.valueOf(domainCcp.getPooling()));
        ccp.setPingDuringPoolCreation(Boolean.valueOf(domainCcp.getPing()));
        boolean lazyConnectionEnlistment = Boolean.valueOf(domainCcp.getLazyConnectionEnlistment());
        boolean lazyConnectionAssociation = Boolean.valueOf(domainCcp.getLazyConnectionAssociation());
        if (lazyConnectionAssociation) {
            if (!lazyConnectionEnlistment) {
                _logger.log(Level.SEVERE, "conn_pool_obj_utils.lazy_enlist-lazy_assoc-invalid-combination", domainCcp.getName());
                String i18nMsg = localStrings.getString("cpou.lazy_enlist-lazy_assoc-invalid-combination", domainCcp.getName());
                throw new RuntimeException(i18nMsg);
            }
            ccp.setLazyConnectionAssoc(true);
            ccp.setLazyConnectionEnlist(true);
        } else {
            ccp.setLazyConnectionAssoc(lazyConnectionAssociation);
            ccp.setLazyConnectionEnlist(lazyConnectionEnlistment);
        }
        boolean pooling = Boolean.valueOf(domainCcp.getPooling());
        if (!pooling) {
            if (Boolean.valueOf(domainCcp.getAssociateWithThread()).booleanValue()) {
                _logger.log(Level.SEVERE, "conn_pool_obj_utils.pooling_disabled_assocwiththread_invalid_combination", domainCcp.getName());
                String i18nMsg = localStrings.getString("cpou.pooling_disabled_assocwiththread_invalid_combination", domainCcp.getName());
                throw new RuntimeException(i18nMsg);
            }
            if (Boolean.valueOf(domainCcp.getIsConnectionValidationRequired()).booleanValue()) {
                _logger.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_conn_validation_invalid_combination", domainCcp.getName());
            }
            if (Integer.parseInt(domainCcp.getValidateAtmostOncePeriodInSeconds()) > 0) {
                _logger.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_validate_atmost_once_invalid_combination", domainCcp.getName());
            }
            if (Boolean.valueOf(domainCcp.getMatchConnections()).booleanValue()) {
                _logger.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_match_connections_invalid_combination", domainCcp.getName());
            }
            if (Integer.parseInt(domainCcp.getMaxConnectionUsageCount()) > 0) {
                _logger.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_max_conn_usage_invalid_combination", domainCcp.getName());
            }
            if (Integer.parseInt(domainCcp.getIdleTimeoutInSeconds()) > 0) {
                _logger.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_idle_timeout_invalid_combination", domainCcp.getName());
            }
        }
        ccp.setPooling(pooling);
        ccp.setMaxConnectionUsage(domainCcp.getMaxConnectionUsageCount());
        ccp.setValidateAtmostOncePeriod(domainCcp.getValidateAtmostOncePeriodInSeconds());
        ccp.setConCreationRetryAttempts(domainCcp.getConnectionCreationRetryAttempts());
        ccp.setConCreationRetryInterval(domainCcp.getConnectionCreationRetryIntervalInSeconds());
        this.convertElementPropertyToPoolProperty(ccp, domainCcp);
        return ccp;
    }

    private void populateConnectorConnectionPool(com.sun.enterprise.connectors.ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, List<Property> props, List<SecurityMap> securityMaps) throws ConnectorRuntimeException {
        ConnectorDescriptor connectorDescriptor = this.runtime.getConnectorDescriptor(rarName);
        if (connectorDescriptor == null) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to get connection pool object");
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_notfound_registry", rarName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        Set connectionDefs = connectorDescriptor.getOutboundResourceAdapter().getConnectionDefs();
        ConnectionDefDescriptor cdd = null;
        Iterator it = connectionDefs.iterator();
        while (it.hasNext() && !connectionDefinitionName.equals((cdd = (ConnectionDefDescriptor)it.next()).getConnectionFactoryIntf())) {
        }
        ConnectorDescriptorInfo cdi = new ConnectorDescriptorInfo();
        cdi.setRarName(rarName);
        cdi.setResourceAdapterClassName(connectorDescriptor.getResourceAdapterClass());
        cdi.setConnectionDefinitionName(cdd.getConnectionFactoryIntf());
        cdi.setManagedConnectionFactoryClass(cdd.getManagedConnectionFactoryImpl());
        cdi.setConnectionFactoryClass(cdd.getConnectionFactoryImpl());
        cdi.setConnectionFactoryInterface(cdd.getConnectionFactoryIntf());
        cdi.setConnectionClass(cdd.getConnectionImpl());
        cdi.setConnectionInterface(cdd.getConnectionIntf());
        Set mergedProps = this.mergeProps(props, cdd.getConfigProperties(), rarName);
        cdi.setMCFConfigProperties(mergedProps);
        cdi.setResourceAdapterConfigProperties(connectorDescriptor.getConfigProperties());
        ccp.setConnectorDescriptorInfo(cdi);
        ccp.setSecurityMaps(SecurityMapUtils.getConnectorSecurityMaps(securityMaps));
    }

    private Set mergeProps(List<Property> props, Set defaultMCFProps, String rarName) {
        HashSet<Object> mergedSet = new HashSet<Object>();
        Object[] defaultProps = defaultMCFProps == null ? new Object[]{} : defaultMCFProps.toArray();
        for (int i = 0; i < defaultProps.length; ++i) {
            ConnectorConfigProperty ep1;
            if (rarName.trim().equals("jmsra") && (ep1 = (ConnectorConfigProperty)defaultProps[i]).getName().equals("AddressList") && ep1.getValue().equals("localhost")) continue;
            mergedSet.add(defaultProps[i]);
        }
        for (Property property : props) {
            if (property == null) continue;
            ConnectorConfigProperty ep = new ConnectorConfigProperty(property.getName(), property.getValue(), null);
            if (defaultMCFProps.contains(ep)) {
                mergedSet.remove(ep);
            }
            mergedSet.add(ep);
        }
        return mergedSet;
    }

    private int parseTransactionSupportString(String txSupport) {
        return ConnectionPoolObjectsUtils.parseTransactionSupportString(txSupport);
    }

    public void convertElementPropertyToPoolProperty(com.sun.enterprise.connectors.ConnectorConnectionPool ccp, ConnectorConnectionPool domainCcp) {
        List<Property> elemProps = domainCcp.getProperty();
        if (elemProps == null) {
            return;
        }
        for (Property ep : elemProps) {
            if (ep == null) continue;
            if ("MATCHCONNECTIONS".equals(ep.getName().toUpperCase())) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" ConnectorConnectionPoolDeployer::  Setting matchConnections");
                }
                ccp.setMatchConnections(this.toBoolean(ep.getValue(), true));
                continue;
            }
            if ("LAZYCONNECTIONASSOCIATION".equals(ep.getName().toUpperCase())) {
                ConnectionPoolObjectsUtils.setLazyEnlistAndLazyAssocProperties(ep.getValue(), domainCcp.getProperty(), ccp);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("LAZYCONNECTIONASSOCIATION");
                continue;
            }
            if ("LAZYCONNECTIONENLISTMENT".equals(ep.getName().toUpperCase())) {
                ccp.setLazyConnectionEnlist(this.toBoolean(ep.getValue(), false));
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("LAZYCONNECTIONENLISTMENT");
                continue;
            }
            if ("ASSOCIATEWITHTHREAD".equals(ep.getName().toUpperCase())) {
                ccp.setAssociateWithThread(this.toBoolean(ep.getValue(), false));
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("ASSOCIATEWITHTHREAD");
                continue;
            }
            if ("POOLDATASTRUCTURE".equals(ep.getName().toUpperCase())) {
                ccp.setPoolDataStructureType(ep.getValue());
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("POOLDATASTRUCTURE");
                continue;
            }
            if ("POOLWAITQUEUE".equals(ep.getName().toUpperCase())) {
                ccp.setPoolWaitQueue(ep.getValue());
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("POOLWAITQUEUE");
                continue;
            }
            if ("DATASTRUCTUREPARAMETERS".equals(ep.getName().toUpperCase())) {
                ccp.setDataStructureParameters(ep.getValue());
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("DATASTRUCTUREPARAMETERS");
                continue;
            }
            if (!"PREFER-VALIDATE-OVER-RECREATE".equals(ep.getName().toUpperCase())) continue;
            String value = ep.getValue();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" ConnectorConnectionPoolDeployer::  Setting PREFER-VALIDATE-OVER-RECREATE to " + value);
            }
            ccp.setPreferValidateOverRecreate(this.toBoolean(value, false));
        }
    }

    private boolean toBoolean(Object prop, boolean defaultVal) {
        if (prop == null) {
            return defaultVal;
        }
        return Boolean.valueOf((String)prop);
    }

    private boolean isAuthCredentialsDefinedInPool(ConnectorConnectionPool domainCcp) {
        List<Property> elemProps = domainCcp.getProperty();
        if (elemProps == null) {
            return false;
        }
        for (Property ep : elemProps) {
            if (!ep.getName().equalsIgnoreCase("UserName") && !ep.getName().equalsIgnoreCase("User") && !ep.getName().equalsIgnoreCase("Password")) continue;
            return true;
        }
        return false;
    }
}

