/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.server.logging.commands.ListLoggerLevels;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-log-attributes")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Scoped(value=PerLookup.class)
@I18n(value="list.log.attributes")
public class ListLogAttributes
implements AdminCommand {
    @Inject
    LoggingConfigImpl loggingConfig;
    @Param(primary=true, optional=true, defaultValue="server")
    String target;
    @Inject
    Domain domain;
    @Inject
    Servers servers;
    @Inject
    Clusters clusters;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListLoggerLevels.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        boolean isCluster = false;
        boolean isDas = false;
        boolean isInstance = false;
        boolean isConfig = false;
        String targetConfigName = "";
        try {
            Server targetServer;
            HashMap props = null;
            Config config = this.domain.getConfigNamed(this.target);
            if (config != null) {
                targetConfigName = this.target;
                isConfig = true;
                targetServer = this.domain.getServerNamed("server");
                if (targetServer.getConfigRef().equals(this.target)) {
                    isDas = true;
                }
            } else {
                Cluster clusterForInstance;
                targetServer = this.domain.getServerNamed(this.target);
                if (targetServer != null && targetServer.isDas()) {
                    isDas = true;
                } else {
                    Cluster cluster = this.domain.getClusterNamed(this.target);
                    if (cluster != null) {
                        isCluster = true;
                        targetConfigName = cluster.getConfigRef();
                    } else if (targetServer != null) {
                        isInstance = true;
                        targetConfigName = targetServer.getConfigRef();
                    }
                }
                if (isInstance && (clusterForInstance = targetServer.getCluster()) != null) {
                    targetConfigName = clusterForInstance.getConfigRef();
                }
            }
            if (isCluster || isInstance) {
                props = (HashMap)this.loggingConfig.getLoggingProperties(targetConfigName);
            } else if (isDas) {
                props = (HashMap)this.loggingConfig.getLoggingProperties();
            } else if (isConfig) {
                props = (HashMap)this.loggingConfig.getLoggingProperties(targetConfigName);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", this.target);
                report.setMessage(msg);
                return;
            }
            ArrayList keys = new ArrayList();
            keys.addAll(props.keySet());
            Collections.sort(keys);
            Iterator it2 = keys.iterator();
            HashMap logAttributes = new HashMap();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                if (name.endsWith(".level") || name.equals(".level")) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(name + "\t" + "<" + (String)props.get(name) + ">");
                logAttributes.put(name, props.get(name));
            }
            Properties restData = new Properties();
            restData.put("logAttributes", logAttributes);
            report.setExtraProperties(restData);
        }
        catch (IOException ex) {
            report.setMessage(localStrings.getLocalString("get.log.attribute.failed", "Could not get logging attributes for {0}.", this.target));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

