/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.ExceptionUtil;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.connect.NodeRunner;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeUtils {
    static final String NODE_DEFAULT_SSH_PORT = "22";
    static final String NODE_DEFAULT_SSH_USER = "${user.name}";
    static final String NODE_DEFAULT_INSTALLDIR = "${com.sun.aas.productRoot}";
    static final String PARAM_NODEHOST = "nodehost";
    static final String PARAM_INSTALLDIR = "installdir";
    static final String PARAM_NODEDIR = "nodedir";
    static final String PARAM_SSHPORT = "sshport";
    static final String PARAM_SSHUSER = "sshuser";
    static final String PARAM_SSHKEYFILE = "sshkeyfile";
    static final String PARAM_SSHPASSWORD = "sshpassword";
    static final String PARAM_SSHKEYPASSPHRASE = "sshkeypassphrase";
    static final String PARAM_TYPE = "type";
    static final String PARAM_INSTALL = "install";
    static final String LANDMARK_FILE = "glassfish/modules/admin-cli.jar";
    private static final String NL = System.getProperty("line.separator");
    private TokenResolver resolver = null;
    private Logger logger = null;
    private Habitat habitat = null;
    SSHLauncher sshL = null;

    NodeUtils(Habitat habitat, Logger logger) {
        this.logger = logger;
        this.habitat = habitat;
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
        this.sshL = habitat.getComponent(SSHLauncher.class);
    }

    static boolean isSSHNode(Node node) {
        if (node == null) {
            return false;
        }
        return node.getType().equals("SSH");
    }

    String getGlassFishVersionOnNode(Node node) throws CommandValidationException {
        if (node == null) {
            return "";
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("version");
        command.add("--local");
        command.add("--terse");
        NodeRunner nr = new NodeRunner(this.habitat, this.logger);
        StringBuilder output = new StringBuilder();
        try {
            int commandStatus = nr.runAdminCommandOnNode(node, output, command);
            if (commandStatus != 0) {
                return "unknown version: " + output.toString();
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(Strings.get("failed.to.run", ((Object)command).toString(), node.getNodeHost()), e);
        }
        return output.toString().trim();
    }

    void validate(Node node) throws CommandValidationException {
        ParameterMap map = new ParameterMap();
        map.add("DEFAULT", node.getName());
        map.add(PARAM_INSTALLDIR, node.getInstallDir());
        map.add(PARAM_NODEHOST, node.getNodeHost());
        map.add(PARAM_NODEDIR, node.getNodeDirAbsolute());
        SshConnector sshc = node.getSshConnector();
        if (sshc != null) {
            map.add(PARAM_SSHPORT, sshc.getSshPort());
            SshAuth ssha = sshc.getSshAuth();
            map.add(PARAM_SSHUSER, ssha.getUserName());
            map.add(PARAM_SSHKEYFILE, ssha.getKeyfile());
            map.add(PARAM_SSHPASSWORD, ssha.getPassword());
            map.add(PARAM_SSHKEYPASSPHRASE, ssha.getKeyPassphrase());
            map.add(PARAM_TYPE, "SSH");
        }
        this.validate(map);
    }

    void validate(ParameterMap map) throws CommandValidationException {
        String sshkeyfile = (String)map.getOne(PARAM_SSHKEYFILE);
        if (StringUtils.ok(sshkeyfile)) {
            File kfile = new File(this.resolver.resolve(sshkeyfile));
            if (!kfile.isAbsolute()) {
                throw new CommandValidationException(Strings.get("key.path.not.absolute", kfile.getPath()));
            }
            if (!kfile.exists()) {
                throw new CommandValidationException(Strings.get("key.path.not.found", kfile.getPath()));
            }
            if (!kfile.canRead()) {
                throw new CommandValidationException(Strings.get("key.path.not.readable", kfile.getPath(), System.getProperty("user.name")));
            }
        }
        this.validatePassword((String)map.getOne(PARAM_SSHPASSWORD));
        this.validatePassword((String)map.getOne(PARAM_SSHKEYPASSPHRASE));
        String nodehost = (String)map.getOne(PARAM_NODEHOST);
        this.validateHostName(nodehost);
        if (this.sshL != null && !nodehost.equals("localhost")) {
            this.validateSSHConnection(map);
        }
    }

    void validateHostName(String hostName) throws CommandValidationException {
        if (!StringUtils.ok(hostName)) {
            throw new CommandValidationException(Strings.get("nodehost.required"));
        }
        try {
            InetAddress addr = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            throw new CommandValidationException(Strings.get("unknown.host", hostName), e);
        }
    }

    private void validatePassword(String p) throws CommandValidationException {
        String expandedPassword = null;
        if (StringUtils.ok(p)) {
            try {
                expandedPassword = RelativePathResolver.getRealPasswordFromAlias(p);
            }
            catch (IllegalArgumentException e) {
                throw new CommandValidationException(Strings.get("no.such.password.alias", p));
            }
            catch (Exception e) {
                throw new CommandValidationException(Strings.get("no.such.password.alias", p), e);
            }
            if (expandedPassword == null) {
                throw new CommandValidationException(Strings.get("no.such.password.alias", p));
            }
        }
    }

    void pingSSHConnection(Node node) throws CommandValidationException {
        this.validateHostName(node.getNodeHost());
        try {
            this.sshL.init(node, this.logger);
            this.sshL.pingConnection();
        }
        catch (Exception e) {
            String m1 = e.getMessage();
            String m2 = "";
            Throwable e2 = e.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            String msg = Strings.get("ssh.bad.connect", node.getNodeHost());
            this.logger.warning(StringUtils.cat(": ", msg, m1, m2, this.sshL.toString()));
            throw new CommandValidationException(StringUtils.cat(NL, msg, m1, m2));
        }
    }

    private void validateSSHConnection(ParameterMap map) throws CommandValidationException {
        String nodehost = (String)map.getOne(PARAM_NODEHOST);
        String installdir = (String)map.getOne(PARAM_INSTALLDIR);
        String nodedir = (String)map.getOne(PARAM_NODEDIR);
        String sshport = (String)map.getOne(PARAM_SSHPORT);
        String sshuser = (String)map.getOne(PARAM_SSHUSER);
        String sshkeyfile = (String)map.getOne(PARAM_SSHKEYFILE);
        String sshpassword = (String)map.getOne(PARAM_SSHPASSWORD);
        String sshkeypassphrase = (String)map.getOne(PARAM_SSHKEYPASSPHRASE);
        boolean installFlag = Boolean.parseBoolean((String)map.getOne(PARAM_INSTALL));
        if (!NetUtils.isPortStringValid(this.resolver.resolve(sshport))) {
            throw new CommandValidationException(Strings.get("ssh.invalid.port", sshport));
        }
        int port = Integer.parseInt(this.resolver.resolve(sshport));
        try {
            String resolvedInstallDir = this.resolver.resolve(installdir);
            this.sshL.validate(this.resolver.resolve(nodehost), port, this.resolver.resolve(sshuser), sshpassword, this.resolver.resolve(sshkeyfile), sshkeypassphrase, resolvedInstallDir, LANDMARK_FILE, this.logger);
        }
        catch (IOException e) {
            String m1 = e.getMessage();
            String m2 = "";
            Throwable e2 = e.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            if (e instanceof FileNotFoundException) {
                this.logger.warning(StringUtils.cat(": ", m1, m2, this.sshL.toString()));
                if (!installFlag) {
                    throw new CommandValidationException(StringUtils.cat(NL, m1, m2));
                }
            }
            String msg = Strings.get("ssh.bad.connect", nodehost);
            this.logger.warning(StringUtils.cat(": ", msg, m1, m2, this.sshL.toString()));
            throw new CommandValidationException(StringUtils.cat(NL, msg, m1, m2));
        }
    }

    static void sanitizeReport(ActionReport report) {
        Throwable rootCause;
        if (report != null && report.hasFailures() && report.getFailureCause() != null && (rootCause = ExceptionUtil.getRootCause(report.getFailureCause())) != null && StringUtils.ok(rootCause.getMessage())) {
            report.setMessage(rootCause.getMessage());
        }
    }

    void runAdminCommandOnNode(Node node, List<String> command, AdminCommandContext context, String firstErrorMessage, String humanCommand, StringBuilder output, boolean waitForReaderThreads) {
        ActionReport report = context.getActionReport();
        boolean failure = true;
        String msg1 = firstErrorMessage;
        String msg2 = "";
        String msg3 = "";
        String nodeHost = node.getNodeHost();
        String nodeName = node.getName();
        String installDir = node.getInstallDir();
        if (output == null) {
            output = new StringBuilder();
        }
        if (StringUtils.ok(humanCommand)) {
            msg3 = Strings.get("node.ssh.tocomplete", nodeHost, installDir, humanCommand);
        }
        NodeRunner nr = new NodeRunner(this.habitat, this.logger);
        try {
            int status = nr.runAdminCommandOnNode(node, output, waitForReaderThreads, command);
            if (status != 0) {
                msg2 = Strings.get("node.command.failed", nodeName, nodeHost, output.toString().trim(), nr.getLastCommandRun());
                this.logger.warning(StringUtils.cat(": ", msg1, msg2, msg3));
                msg2 = Strings.get("node.command.failed.short", nodeName, nodeHost, output.toString().trim());
            } else {
                failure = false;
                this.logger.info(output.toString().trim());
            }
        }
        catch (SSHCommandExecutionException ec) {
            msg2 = Strings.get("node.ssh.bad.connect", nodeName, nodeHost, ec.getMessage());
            String msg = Strings.get("node.command.failed.ssh.details", nodeName, nodeHost, ec.getCommandRun(), ec.getMessage(), ec.getSSHSettings());
            this.logger.warning(StringUtils.cat(": ", msg1, msg, msg3));
        }
        catch (ProcessManagerException ex) {
            msg2 = Strings.get("node.command.failed.local.details", ex.getMessage(), nr.getLastCommandRun());
            this.logger.warning(StringUtils.cat(": ", msg1, msg2, msg3));
            msg2 = Strings.get("node.command.failed.local.exception", ex.getMessage());
        }
        catch (UnsupportedOperationException e) {
            msg2 = Strings.get("node.not.ssh", nodeName, nodeHost);
            this.logger.warning(StringUtils.cat(": ", msg1, msg2, msg3));
        }
        catch (IllegalArgumentException e) {
            msg2 = e.getMessage();
            this.logger.warning(StringUtils.cat(": ", msg1, msg2, msg3));
        }
        if (failure) {
            report.setMessage(StringUtils.cat(NL + NL, msg1, msg2, msg3));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        } else {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    void runAdminCommandOnNode(Node node, List<String> command, AdminCommandContext context, String firstErrorMessage, String humanCommand, StringBuilder output) {
        this.runAdminCommandOnNode(node, command, context, firstErrorMessage, humanCommand, output, true);
    }
}

