/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_post-unregister-instance")
@Supplemental(value="_unregister-instance", ifFailure=FailurePolicy.Warn)
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class PostUnregisterInstanceCommand
implements AdminCommand {
    @Param(name="node", optional=true)
    public String node;
    @Param(name="name", primary=true)
    public String instanceName;
    @Inject
    private Habitat habitat;
    @Inject
    private Target target;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        String clusterName = context.getActionReport().getResultType(String.class);
        if (clusterName != null) {
            try {
                ParameterMapExtractor pme = new ParameterMapExtractor(this);
                ParameterMap paramMap = pme.extract();
                ArrayList<String> targets = new ArrayList<String>();
                List<Server> instances = this.target.getInstances(clusterName);
                for (Server s : instances) {
                    targets.add(s.getName());
                }
                ClusterOperationUtil.replicateCommand("_unregister-instance", FailurePolicy.Warn, FailurePolicy.Warn, targets, context, paramMap, this.habitat);
            }
            catch (Exception e) {
                report.failure(logger, e.getMessage());
            }
        }
    }
}

