/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.remote.ServerRemoteAdminCommand;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.StopServer;
import com.sun.enterprise.v3.admin.cluster.InstanceDirUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.cluster.ssh.connect.RemoteConnectHelper;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="stop-instance")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="stop.instance.command")
@ExecuteOn(value={RuntimeType.DAS})
public class StopInstanceCommand
extends StopServer
implements AdminCommand,
PostConstruct {
    @Inject
    private Habitat habitat;
    @Inject
    private ServerContext serverContext;
    @Inject
    private Nodes nodes;
    @Inject
    private ServerEnvironment env;
    @Inject
    Node[] nodeList;
    @Inject
    private ModulesRegistry registry;
    @Param(optional=true, defaultValue="true")
    private Boolean force = true;
    @Param(optional=true, defaultValue="false")
    private Boolean kill = false;
    @Param(optional=false, primary=true)
    private String instanceName;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;
    private ActionReport report;
    private String errorMessage = null;
    private String cmdName = "stop-instance";
    private Server instance;
    File pidFile = null;
    SFTPClient ftpClient = null;

    @Override
    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        this.errorMessage = this.env.isDas() ? (this.kill.booleanValue() ? this.killInstance(context) : this.callInstance()) : Strings.get("stop.instance.notDas", this.env.getRuntimeType().toString());
        if (this.errorMessage == null && !this.kill.booleanValue()) {
            this.errorMessage = this.pollForDeath();
        }
        if (this.errorMessage != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(this.errorMessage);
            return;
        }
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        this.report.setMessage(Strings.get("stop.instance.success", this.instanceName));
        if (this.kill.booleanValue()) {
            return;
        }
        String nodeName = this.instance.getNodeRef();
        Node node = this.nodes.getNode(nodeName);
        String nodeHost = node.getNodeHost();
        InstanceDirUtils insDU = new InstanceDirUtils(node, this.serverContext);
        try {
            this.pidFile = new File(insDU.getLocalInstanceDir(this.instance.getName()), "config/pid");
        }
        catch (IOException eio) {
            return;
        }
        int dasPort = this.helper.getAdminPort("server");
        String dasHost = System.getProperty("com.sun.aas.hostName");
        RemoteConnectHelper rch = new RemoteConnectHelper(this.habitat, node, this.logger, dasHost, dasPort);
        if (rch.isLocalhost()) {
            if (this.pidFile.exists()) {
                this.errorMessage = this.pollForRealDeath("local");
            }
        } else if (node.getType().equals("SSH")) {
            SSHLauncher launcher = this.habitat.getComponent(SSHLauncher.class);
            launcher.init(node, this.logger);
            try {
                this.ftpClient = launcher.getSFTPClient();
                if (this.ftpClient.exists(this.pidFile.toString())) {
                    this.errorMessage = this.pollForRealDeath("remote");
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (this.errorMessage != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(this.errorMessage);
        }
    }

    @Override
    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    private String initializeInstance() {
        if (!StringUtils.ok(this.instanceName)) {
            return Strings.get("stop.instance.noInstanceName", this.cmdName);
        }
        this.instance = this.helper.getServer(this.instanceName);
        if (this.instance == null) {
            return Strings.get("stop.instance.noSuchInstance", this.instanceName);
        }
        return null;
    }

    private String callInstance() {
        String msg = this.initializeInstance();
        if (msg != null) {
            return msg;
        }
        String host = this.instance.getAdminHost();
        if (host == null) {
            return Strings.get("stop.instance.noHost", this.instanceName);
        }
        int port = this.helper.getAdminPort(this.instance);
        if (port < 0) {
            return Strings.get("stop.instance.noPort", this.instanceName);
        }
        if (!this.instance.isRunning()) {
            return null;
        }
        try {
            this.logger.info(Strings.get("stop.instance.init", this.instanceName));
            ServerRemoteAdminCommand rac = new ServerRemoteAdminCommand(this.habitat, "_stop-instance", host, port, false, "admin", null, this.logger);
            ParameterMap map = new ParameterMap();
            map.add("force", Boolean.toString(this.force));
            rac.executeCommand(map);
        }
        catch (CommandException ex) {
            return Strings.get("stop.instance.racError", this.instanceName, ex.getLocalizedMessage());
        }
        return null;
    }

    private String killInstance(AdminCommandContext context) {
        String msg = this.initializeInstance();
        if (msg != null) {
            return msg;
        }
        String nodeName = this.instance.getNodeRef();
        Node node = this.nodes.getNode(nodeName);
        NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
        ArrayList<String> command = new ArrayList<String>();
        command.add("stop-local-instance");
        command.add("--kill");
        command.add(this.instanceName);
        String humanCommand = this.makeCommandHuman(command);
        String firstErrorMessage = Strings.get("stop.local.instance.kill", this.instanceName, nodeName, humanCommand);
        this.logger.fine("stop-instance: running " + humanCommand + " on " + nodeName);
        nodeUtils.runAdminCommandOnNode(node, command, context, firstErrorMessage, humanCommand, null);
        ActionReport killreport = context.getActionReport();
        if (killreport.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            return killreport.getMessage();
        }
        return null;
    }

    private String pollForDeath() {
        int counter = 0;
        while (++counter < 240) {
            if (!this.instance.isRunning()) {
                return null;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        return Strings.get("stop.instance.timeout", this.instanceName);
    }

    private String pollForRealDeath(String mode) {
        int counter = 0;
        while (++counter < 24) {
            try {
                if (mode.equals("local") ? !this.pidFile.exists() : !this.ftpClient.exists(this.pidFile.toString())) {
                    return null;
                }
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
        }
        return Strings.get("stop.instance.timeout.completely", this.instanceName);
    }

    private String makeCommandHuman(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString().trim();
    }
}

