/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.MemoryStrategyBuilder;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.jvnet.hk2.component.Habitat;

public class PersistenceStrategyBuilderFactory {
    private static final Logger _logger = LogDomains.getLogger(PersistenceStrategyBuilderFactory.class, "javax.enterprise.system.container.web");
    Habitat habitat;

    public PersistenceStrategyBuilderFactory(ServerConfigLookup serverConfigLookup, Habitat habitat) {
        this.habitat = habitat;
    }

    public PersistenceStrategyBuilder createPersistenceStrategyBuilder(String persistenceType, String frequency, String scope, Context ctx) {
        PersistenceStrategyBuilder builder;
        String resolvedPersistenceFrequency = null;
        String resolvedPersistenceScope = null;
        if (!(persistenceType.equalsIgnoreCase(PersistenceType.MEMORY.getType()) || persistenceType.equalsIgnoreCase(PersistenceType.FILE.getType()) || persistenceType.equalsIgnoreCase(PersistenceType.COOKIE.getType()))) {
            resolvedPersistenceFrequency = frequency;
            resolvedPersistenceScope = scope;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("resolvedPersistenceType = " + persistenceType);
            _logger.finest("resolvedPersistenceFrequency = " + resolvedPersistenceFrequency);
            _logger.finest("resolvedPersistenceScope = " + resolvedPersistenceScope);
        }
        if ((builder = this.habitat.getComponent(PersistenceStrategyBuilder.class, persistenceType)) == null) {
            builder = new MemoryStrategyBuilder();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Could not find PersistentStrategyBuilder for persistenceType  " + persistenceType);
            }
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: CandidateBuilderClassName = " + builder.getClass());
            }
            builder.setPersistenceFrequency(frequency);
            builder.setPersistenceScope(scope);
            builder.setPassedInPersistenceType(persistenceType);
        }
        return builder;
    }

    public String getApplicationId(Context ctx) {
        return ((WebModule)ctx).getID();
    }
}

