/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationStateInfo;
import com.sun.faces.util.ComponentStruct;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateContext {
    private static final String KEY = StateContext.class.getName() + "_KEY";
    private static final String HAS_ONE_OR_MORE_DYNAMIC_CHILD = StateContext.class.getName() + "_HAS_ONE_OR_MORE_DYNAMIC_CHILD";
    private boolean partial;
    private boolean partialLocked;
    private boolean trackMods = true;
    private AddRemoveListener modListener;
    private ApplicationStateInfo stateInfo;
    private WeakReference<UIViewRoot> viewRootRef = new WeakReference<Object>(null);

    private StateContext(ApplicationStateInfo stateInfo) {
        this.stateInfo = stateInfo;
    }

    public static StateContext getStateContext(FacesContext ctx) {
        StateContext stateCtx = (StateContext)ctx.getAttributes().get(KEY);
        if (stateCtx == null) {
            ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
            ApplicationStateInfo info = associate.getApplicationStateInfo();
            stateCtx = new StateContext(info);
            ctx.getAttributes().put(KEY, stateCtx);
        }
        return stateCtx;
    }

    public boolean partialStateSaving(FacesContext ctx, String viewId) {
        UIViewRoot refRoot;
        UIViewRoot root = ctx.getViewRoot();
        if (root != (refRoot = (UIViewRoot)this.viewRootRef.get())) {
            this.viewRootRef = new WeakReference<UIViewRoot>(root);
            if (refRoot != null) {
                this.modListener = null;
                this.partialLocked = false;
            }
        }
        if (!this.partialLocked) {
            if (viewId == null) {
                viewId = root != null ? root.getViewId() : (String)ctx.getAttributes().get("com.sun.faces.viewId");
            }
            this.partial = this.stateInfo.usePartialStateSaving(viewId);
            this.partialLocked = true;
        }
        return this.partial;
    }

    public boolean trackViewModifications() {
        return this.trackMods;
    }

    public void startTrackViewModifications() {
        if (this.modListener == null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            this.modListener = new AddRemoveListener(ctx);
            UIViewRoot root = ctx.getViewRoot();
            root.subscribeToViewEvent(PostAddToViewEvent.class, this.modListener);
            root.subscribeToViewEvent(PreRemoveFromViewEvent.class, this.modListener);
        }
        this.setTrackViewModifications(true);
    }

    public void setTrackViewModifications(boolean trackMods) {
        this.trackMods = trackMods;
    }

    public boolean componentAddedDynamically(UIComponent c) {
        return c.getAttributes().containsKey("com.sun.faces.StateHolderSaver_DYNAMIC_COMPONENT");
    }

    public int getIndexOfDynamicallyAddedChildInParent(UIComponent c) {
        int result = -1;
        Map<String, Object> attrs = c.getAttributes();
        if (attrs.containsKey("com.sun.faces.StateHolderSaver_DYNAMIC_COMPONENT")) {
            result = (Integer)attrs.get("com.sun.faces.StateHolderSaver_DYNAMIC_COMPONENT");
        }
        return result;
    }

    public boolean hasOneOrMoreDynamicChild(UIComponent parent) {
        return parent.getAttributes().containsKey(HAS_ONE_OR_MORE_DYNAMIC_CHILD);
    }

    private int incrementDynamicChildCount(UIComponent parent) {
        int result = 0;
        Map<String, Object> attrs = parent.getAttributes();
        Integer cur = (Integer)attrs.get(HAS_ONE_OR_MORE_DYNAMIC_CHILD);
        if (null != cur) {
            Integer n = cur;
            Integer n2 = cur = Integer.valueOf(cur + 1);
            result = n;
        } else {
            result = 1;
        }
        attrs.put(HAS_ONE_OR_MORE_DYNAMIC_CHILD, result);
        return result;
    }

    private int decrementDynamicChildCount(UIComponent parent) {
        int result = 0;
        Map<String, Object> attrs = parent.getAttributes();
        Integer cur = (Integer)attrs.get(HAS_ONE_OR_MORE_DYNAMIC_CHILD);
        if (null != cur) {
            int n;
            if (0 < cur) {
                Integer n2 = cur;
                Integer n3 = cur = Integer.valueOf(cur - 1);
                n = n2;
            } else {
                n = result = 0;
            }
        }
        if (0 == result && null != cur) {
            attrs.remove(HAS_ONE_OR_MORE_DYNAMIC_CHILD);
        }
        return result;
    }

    public Map<String, ComponentStruct> getDynamicAdds() {
        return this.modListener != null ? this.modListener.getDynamicAdds() : null;
    }

    public List<String> getDynamicRemoves() {
        return this.modListener != null ? this.modListener.dynamicRemoves : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AddRemoveListener
    implements SystemEventListener {
        private StateContext stateCtx;
        private LinkedHashMap<String, ComponentStruct> dynamicAdds;
        private List<String> dynamicRemoves;

        public AddRemoveListener(FacesContext ctx) {
            this.stateCtx = StateContext.getStateContext(ctx);
        }

        public Map<String, ComponentStruct> getDynamicAdds() {
            if (null == this.dynamicAdds) {
                this.dynamicAdds = new LinkedHashMap();
            }
            return this.dynamicAdds;
        }

        @Override
        public void processEvent(SystemEvent event) throws AbortProcessingException {
            FacesContext ctx = FacesContext.getCurrentInstance();
            if (event instanceof PreRemoveFromViewEvent) {
                if (this.stateCtx.trackViewModifications()) {
                    this.handleRemoveEvent(ctx, (PreRemoveFromViewEvent)event);
                }
            } else if (this.stateCtx.trackViewModifications()) {
                this.handleAddEvent(ctx, (PostAddToViewEvent)event);
            }
        }

        @Override
        public boolean isListenerForSource(Object source) {
            return source instanceof UIComponent;
        }

        private void handleRemoveEvent(FacesContext context, PreRemoveFromViewEvent event) {
            UIComponent removed = event.getComponent();
            if (removed.isTransient()) {
                return;
            }
            if (this.dynamicRemoves == null) {
                this.dynamicRemoves = new ArrayList<String>();
            }
            String clientId = event.getComponent().getClientId(context);
            if (this.dynamicAdds != null && this.dynamicAdds.containsKey(clientId)) {
                this.dynamicAdds.remove(clientId);
            }
            StateContext.this.decrementDynamicChildCount(removed.getParent());
            this.dynamicRemoves.add(clientId);
        }

        private void handleAddEvent(FacesContext context, PostAddToViewEvent event) {
            UIComponent parent;
            if (context.getViewRoot().isTransient()) {
                return;
            }
            UIComponent added = event.getComponent();
            if (added.isTransient() || added instanceof UIViewRoot) {
                return;
            }
            for (parent = added.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.isTransient()) continue;
                return;
            }
            parent = added.getParent();
            StateContext.this.incrementDynamicChildCount(parent);
            ComponentStruct toAdd = new ComponentStruct();
            toAdd.absorbComponent(context, added);
            if (this.dynamicRemoves != null) {
                this.dynamicRemoves.remove(toAdd.clientId);
            }
            added.getAttributes().put("com.sun.faces.StateHolderSaver_DYNAMIC_COMPONENT", new Integer(toAdd.indexOfChildInParent));
            this.getDynamicAdds().put(toAdd.clientId, toAdd);
        }
    }
}

