/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnection;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.util.SQLTraceDelegator;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.sql.DataSource;
import org.glassfish.api.jdbc.SQLTraceRecord;

public abstract class JdbcObjectsFactory
implements Serializable {
    protected static final Logger _logger = LogDomains.getLogger(JdbcObjectsFactory.class, "javax.enterprise.resource.resourceadapter");

    public static JdbcObjectsFactory getInstance() {
        boolean jdbc40 = DataSourceObjectBuilder.isJDBC40();
        JdbcObjectsFactory factory = null;
        try {
            factory = jdbc40 ? (JdbcObjectsFactory)Class.forName("com.sun.gjc.spi.jdbc40.Jdbc40ObjectsFactory").newInstance() : (JdbcObjectsFactory)Class.forName("com.sun.gjc.spi.jdbc30.Jdbc30ObjectsFactory").newInstance();
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "jdbc.jdbc_factory_class_load_exception", e);
        }
        return factory;
    }

    public abstract DataSource getDataSourceInstance(ManagedConnectionFactory var1, ConnectionManager var2);

    public abstract ConnectionHolder getConnection(Connection var1, ManagedConnection var2, ConnectionRequestInfo var3, boolean var4, SQLTraceDelegator var5);

    protected Connection getProxiedConnection(Object conObject, Class[] connIntf, SQLTraceDelegator sqlTraceDelegator) {
        Connection proxiedConn = null;
        try {
            proxiedConn = (Connection)this.getProxyObject(conObject, connIntf, sqlTraceDelegator);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "jdbc.jdbc_proxied_connection_get_exception", ex.getMessage());
        }
        return proxiedConn;
    }

    protected <T> T getProxyObject(final Object actualObject, Class<T>[] ifaces, final SQLTraceDelegator sqlTraceDelegator) throws Exception {
        InvocationHandler ih = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                SQLTraceRecord record = new SQLTraceRecord();
                record.setMethodName(method.getName());
                record.setParams(args);
                record.setClassName(actualObject.getClass().getName());
                record.setThreadName(Thread.currentThread().getName());
                record.setThreadID(Thread.currentThread().getId());
                record.setTimeStamp(System.currentTimeMillis());
                sqlTraceDelegator.sqlTrace(record);
                return method.invoke(actualObject, args);
            }
        };
        Object result = Proxy.newProxyInstance(actualObject.getClass().getClassLoader(), ifaces, ih);
        return (T)result;
    }
}

