/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.corba.ee.spi.costransactions.TransactionService;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorResourceServantActivator;
import com.sun.jts.CosTransactions.CurrentImpl;
import com.sun.jts.CosTransactions.ProxyChecker;
import com.sun.jts.CosTransactions.RecoveryCoordinatorServantActivator;
import com.sun.jts.CosTransactions.SenderReceiver;
import com.sun.jts.CosTransactions.TransactionFactoryImpl;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TSIdentification;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.RequestProcessingPolicyValue;

public class DefaultTransactionService
implements TransactionService,
ProxyChecker {
    private static CurrentImpl currentInstance = null;
    private static TransactionFactoryImpl factoryInstance = null;
    private static NamingContext namingContext = null;
    private static ORB orb = null;
    private static boolean recoverable = false;
    private static boolean poasCreated = false;
    private static boolean active = false;
    static Logger _logger = LogDomains.getLogger(DefaultTransactionService.class, "javax.enterprise.system.core.transaction");
    public static final String JTS_SERVER_ID = "com.sun.jts.persistentServerId";
    public static final String JTS_XA_SERVER_NAME = "com.sun.jts.xa-servername";

    public static boolean isActive() {
        return active;
    }

    public Current get_current() {
        CurrentImpl result = null;
        result = currentInstance;
        return result;
    }

    public void identify_ORB(ORB orb, TSIdentification ident, Properties properties) {
        block18: {
            if (DefaultTransactionService.orb == null) {
                DefaultTransactionService.orb = orb;
                Configuration.setORB(orb);
                Configuration.setProperties(properties);
                Configuration.setProxyChecker(this);
            }
            if (!poasCreated) {
                DefaultTransactionService.setServerName(properties);
                try {
                    if (orb != null) {
                        DefaultTransactionService.createPOAs();
                    }
                }
                catch (Exception exc) {
                    _logger.log(Level.WARNING, "jts.unexpected_error_when_creating_poa", exc);
                    throw new INTERNAL(265, CompletionStatus.COMPLETED_NO);
                }
            }
            if (currentInstance == null) {
                try {
                    currentInstance = new CurrentImpl();
                }
                catch (Exception exc) {
                    _logger.log(Level.WARNING, "jts.unexpected_error_when_creating_current", exc);
                    throw new INTERNAL(265, CompletionStatus.COMPLETED_NO);
                }
            }
            if (ident != null) {
                SenderReceiver.identify(ident);
            }
            if (recoverable && namingContext == null) {
                try {
                    namingContext = NamingContextHelper.narrow(orb.resolve_initial_references("NameService"));
                }
                catch (InvalidName inexc) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "jts.orb_not_running");
                    }
                }
                catch (Exception exc) {
                    if (!_logger.isLoggable(Level.FINE)) break block18;
                    _logger.log(Level.FINE, "jts.orb_not_running");
                }
            }
        }
        if (factoryInstance == null) {
            try {
                boolean localFactory = true;
                TransactionFactory factory = null;
                factoryInstance = new TransactionFactoryImpl();
                factory = localFactory ? factoryInstance : factoryInstance.object();
                Configuration.setFactory(factory, localFactory);
                if (!Configuration.isLocalFactory() && namingContext != null) {
                    NameComponent nc = new NameComponent(TransactionFactoryHelper.id(), "");
                    NameComponent[] path = new NameComponent[]{nc};
                    namingContext.rebind(path, factory);
                }
            }
            catch (Exception exc) {
                _logger.log(Level.WARNING, "jts.cannot_register_with_orb", "TransactionFactory");
            }
        }
        active = true;
    }

    public static void setServerName(Properties properties) {
        if (!poasCreated) {
            Configuration.setProperties(properties);
            String serverId = properties.getProperty(JTS_SERVER_ID);
            if (serverId == null) {
                serverId = properties.getProperty("com.sun.CORBA.POA.ORBServerId");
            }
            if (serverId != null) {
                _logger.log(Level.INFO, "jts.startup_msg", serverId);
            }
            String serverName = "UnknownHost";
            if (properties.getProperty(JTS_XA_SERVER_NAME) != null) {
                serverName = properties.getProperty(JTS_XA_SERVER_NAME);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "DTR: Got serverName from JTS_XA_SERVER_NAME");
                }
            } else {
                try {
                    serverName = InetAddress.getLocalHost().getHostName();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "DTR: Got serverName from InetAddress.getLocalHost().getHostName()");
                    }
                }
                catch (UnknownHostException ex) {
                    // empty catch block
                }
            }
            if (serverId != null) {
                Configuration.setServerName(DefaultTransactionService.getAdjustedServerName(serverName + "," + Configuration.getPropertyValue("com.sun.jts.instancename") + ",P" + serverId), true);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "DTR: Recoverable Server");
                }
                recoverable = true;
            } else {
                long timestamp = System.currentTimeMillis();
                Configuration.setServerName(DefaultTransactionService.getAdjustedServerName(serverName + ",T" + String.valueOf(timestamp)), false);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "DTR: Non-Recoverable Server");
                }
            }
        }
    }

    public static void shutdown(boolean immediate) {
        if (namingContext != null) {
            try {
                NameComponent nc = new NameComponent(TransactionFactoryHelper.id(), "");
                NameComponent[] path = new NameComponent[]{nc};
                namingContext.unbind(path);
                namingContext = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TransactionFactoryImpl.deactivate();
        CurrentImpl.deactivate();
        currentInstance.shutdown(immediate);
        currentInstance = null;
        factoryInstance = null;
        active = false;
    }

    public final boolean isProxy(Object obj) {
        return !StubAdapter.isStub((java.lang.Object)obj) || !StubAdapter.isLocal((java.lang.Object)obj);
    }

    static final void createPOAs() throws Exception {
        POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        POA CRpoa = null;
        if (recoverable) {
            Policy[] tpolicy = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
            CRpoa = rootPOA.create_POA("com.sun.jts.CosTransactions.CoordinatorResourcePOA", null, tpolicy);
            CoordinatorResourceServantActivator crsa = new CoordinatorResourceServantActivator(orb);
            CRpoa.set_servant_manager(crsa);
        } else {
            CRpoa = rootPOA;
        }
        Configuration.setPOA("CoordinatorResource", CRpoa);
        POA RCpoa = null;
        if (recoverable) {
            Policy[] tpolicy = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
            RCpoa = rootPOA.create_POA("com.sun.jts.CosTransactions.RecoveryCoordinatorPOA", null, tpolicy);
            RecoveryCoordinatorServantActivator rcsa = new RecoveryCoordinatorServantActivator(orb);
            RCpoa.set_servant_manager(rcsa);
        } else {
            RCpoa = rootPOA;
        }
        Configuration.setPOA("RecoveryCoordinator", RCpoa);
        POA Cpoa = rootPOA.create_POA("CoordinatorPOA", null, null);
        Configuration.setPOA("Coordinator", Cpoa);
        Configuration.setPOA("transient", rootPOA);
        CRpoa.the_POAManager().activate();
        RCpoa.the_POAManager().activate();
        Cpoa.the_POAManager().activate();
        rootPOA.the_POAManager().activate();
        poasCreated = true;
    }

    public static boolean isORBAvailable() {
        return orb != null;
    }

    private static String getAdjustedServerName(String originalName) {
        String tempServerName = originalName;
        if (tempServerName.length() > 56) {
            int hc = tempServerName.hashCode();
            String newString = Integer.toString(hc);
            if (hc < 0) {
                newString = newString.replace("-", "R");
            }
            int hcLength = 56 - newString.length();
            tempServerName = tempServerName.substring(0, hcLength) + newString;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "DTR: Adjusted serverName " + originalName + " to: " + tempServerName);
        }
        return tempServerName;
    }
}

