/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.AuthProxy;
import com.sun.pkg.client.PkgProxySelector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemInfo {
    private static final String APPNAME = "updatetool";
    private static final String INITFILE = "init.cfg";
    private static final String DEFAULTSFILE = "defaults.cfg";
    private static final String WIN_APP_DATA = "Application Data";
    private static final String MAC_APP_DATA = "/Library/Application Support/";
    private static final String eol = System.getProperty("line.separator");
    private static Proxy httpProxy = null;
    private static Proxy httpsProxy = null;
    private static File proxyInfoFile = null;
    private static long proxyInfoLastModified = 0L;
    private static final String OS_ARCH_PROP = "os.arch";
    private static final Hashtable<String, ArchInfo> os_arch_table = new Hashtable();

    public static String getOSBitness() {
        ArchInfo info = os_arch_table.get(System.getProperty(OS_ARCH_PROP).toLowerCase());
        if (info.bits == null) {
            return "32";
        }
        return info.bits;
    }

    public static String getCanonicalOSArch() {
        ArchInfo info = os_arch_table.get(System.getProperty(OS_ARCH_PROP).toLowerCase());
        if (info.bits == null) {
            return "i386";
        }
        return info.arch;
    }

    public static ProxySelector getProxySelector() {
        SystemInfo.loadProxyInfo();
        return new PkgProxySelector(httpProxy, httpsProxy);
    }

    public static Proxy getProxy() {
        SystemInfo.loadProxyInfo();
        return httpProxy;
    }

    private static void loadProxyInfo() {
        Logger log = Logger.getLogger(SystemInfo.class.getName());
        try {
            String line;
            String hp = System.getenv("http_proxy");
            String hsp = System.getenv("https_proxy");
            if (hp != null || hsp != null) {
                httpProxy = hp == null || hp.length() == 0 ? null : AuthProxy.newProxy(new URL(hp));
                httpsProxy = hsp == null || hsp.length() == 0 ? null : AuthProxy.newProxy(new URL(hsp));
                return;
            }
            File f = SystemInfo.getInitFile();
            if (!f.exists() && !(f = SystemInfo.getDefaultsFile()).exists()) {
                return;
            }
            if (proxyInfoFile != null && proxyInfoFile.equals(f) && proxyInfoLastModified >= f.lastModified()) {
                return;
            }
            proxyInfoFile = f;
            proxyInfoLastModified = f.lastModified();
            httpsProxy = null;
            httpProxy = null;
            BufferedReader r = SystemInfo.getFileReader(f);
            String proxy_host = null;
            int proxy_port = 80;
            String proxy_https_host = null;
            int proxy_https_port = 443;
            String proxy_username = "";
            String proxy_password = "";
            boolean useSystem = false;
            boolean proxy_required = false;
            boolean proxy_ssl_use_http = true;
            boolean proxy_auth = false;
            while ((line = r.readLine()) != null) {
                String[] tokens;
                if (!line.startsWith("proxy.") || (tokens = line.split("\\s*[:=]\\s*", 2)).length != 2) continue;
                if (tokens[0].equals("proxy.host")) {
                    proxy_host = tokens[1].trim();
                    continue;
                }
                if (tokens[0].equals("proxy.port") && tokens[1].trim().length() > 0) {
                    try {
                        proxy_port = Integer.parseInt(tokens[1].trim());
                    }
                    catch (NumberFormatException nfe) {
                        log.log(Level.SEVERE, "invalidproxyport", new Object[]{"HTTP", proxyInfoFile, tokens[1]});
                    }
                    continue;
                }
                if (tokens[0].equals("proxy.https.host")) {
                    proxy_https_host = tokens[1].trim();
                    continue;
                }
                if (tokens[0].equals("proxy.https.port") && tokens[1].trim().length() > 0) {
                    try {
                        proxy_https_port = Integer.parseInt(tokens[1].trim());
                    }
                    catch (NumberFormatException nfe) {
                        log.log(Level.SEVERE, "invalidproxyport", new Object[]{"HTTPS", proxyInfoFile, tokens[1]});
                    }
                    continue;
                }
                if (tokens[0].equals("proxy.required")) {
                    proxy_required = Boolean.parseBoolean(tokens[1].trim());
                    continue;
                }
                if (tokens[0].equals("proxy.auth")) {
                    proxy_auth = Boolean.parseBoolean(tokens[1].trim());
                    continue;
                }
                if (tokens[0].equals("proxy.ssl_use_http")) {
                    proxy_ssl_use_http = Boolean.parseBoolean(tokens[1].trim());
                    continue;
                }
                if (tokens[0].equals("proxy.username")) {
                    proxy_username = tokens[1];
                    continue;
                }
                if (tokens[0].equals("proxy.password")) {
                    proxy_password = tokens[1];
                    continue;
                }
                if (!tokens[0].equals("proxy.use.system")) continue;
                useSystem = Boolean.parseBoolean(tokens[1].trim());
            }
            if (proxy_required) {
                InetSocketAddress addr;
                if (proxy_host == null || proxy_host.length() == 0) {
                    log.log(Level.SEVERE, "invalidproxy", new Object[]{"HTTP", proxyInfoFile});
                } else {
                    addr = new InetSocketAddress(proxy_host, proxy_port);
                    Proxy proxy = httpProxy = proxy_auth ? new AuthProxy(Proxy.Type.HTTP, addr, proxy_username, proxy_password) : new AuthProxy(Proxy.Type.HTTP, addr);
                }
                if (proxy_ssl_use_http) {
                    httpsProxy = httpProxy;
                } else if (proxy_https_host == null || proxy_https_host.length() == 0) {
                    log.log(Level.SEVERE, "invalidproxy", new Object[]{"HTTPS", proxyInfoFile});
                } else {
                    addr = new InetSocketAddress(proxy_https_host, proxy_https_port);
                    httpsProxy = proxy_auth ? new AuthProxy(Proxy.Type.HTTP, addr, proxy_username, proxy_password) : new AuthProxy(Proxy.Type.HTTP, addr);
                }
            } else if (useSystem) {
                System.setProperty("java.net.useSystemProxies", "true");
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "badproxy", proxyInfoFile);
            ex.printStackTrace();
        }
    }

    public static UpdateCheckFrequency getUpdateCheckFrequency() {
        UpdateCheckFrequency rv = UpdateCheckFrequency.DAILY;
        boolean optin = true;
        try {
            File ifile;
            File dfile = SystemInfo.getDefaultsFile();
            if (dfile.exists()) {
                String line;
                BufferedReader r = SystemInfo.getFileReader(dfile);
                while ((line = r.readLine()) != null) {
                    if (!line.startsWith("check_frequency")) continue;
                    String[] tokens = line.split("\\s*=\\s*", 2);
                    if (tokens.length != 2) break;
                    if (tokens[1].equals("daily")) {
                        rv = UpdateCheckFrequency.DAILY;
                        break;
                    }
                    if (tokens[1].equals("weekly")) {
                        rv = UpdateCheckFrequency.WEEKLY;
                        break;
                    }
                    if (tokens[1].equals("monthly")) {
                        rv = UpdateCheckFrequency.MONTHLY;
                        break;
                    }
                    if (!tokens[1].equals("never")) break;
                    rv = UpdateCheckFrequency.NEVER;
                    break;
                }
                r.close();
            }
            if ((ifile = SystemInfo.getInitFile()).exists()) {
                String line;
                BufferedReader r = SystemInfo.getFileReader(ifile);
                while ((line = r.readLine()) != null) {
                    if (!line.startsWith("optin.update.notification")) continue;
                    String[] tokens = line.split("\\s*:\\s*", 2);
                    if (tokens.length != 2 || tokens[1].equals("true")) break;
                    optin = false;
                    break;
                }
                r.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SystemInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!optin) {
            return UpdateCheckFrequency.NEVER;
        }
        return rv;
    }

    public static void initUpdateToolProps(Properties props) throws Exception {
        try {
            File f = SystemInfo.getInitFile();
            try {
                boolean success;
                File configdir = f.getParentFile();
                if (!configdir.exists() && !(success = configdir.mkdirs())) {
                    throw new IOException("Unable to initialize properties: mkdirs() failed: " + configdir);
                }
                if (!configdir.isDirectory()) {
                    throw new IOException("Unable to initialize properties: file exists but is not a directory: " + configdir);
                }
            }
            catch (SecurityException e) {
                IOException ioe = new IOException("Unable to initialize updatetool preferences");
                ioe.initCause(e);
                throw ioe;
            }
            BufferedWriter out = SystemInfo.getFileWriter(f);
            out.write("[main]" + eol);
            out.write("date: " + new Date().getTime() + eol);
            String v = props.getProperty("optin.update.notification");
            if (v != null) {
                out.write("optin.update.notification: " + v + eol);
            }
            if ((v = props.getProperty("image.path")) != null) {
                out.write("image_list: " + new File(v.trim()).getAbsolutePath() + eol);
            }
            out.write("[network]" + eol);
            v = props.getProperty("proxy.use.system");
            if (v != null) {
                out.write("proxy.use.system: " + v.trim() + eol);
            }
            if ((v = props.getProperty("proxy.URL")) != null) {
                if (v.trim().length() > 0) {
                    String userinfo;
                    URL proxy = new URL(v.trim());
                    out.write("proxy.required: true" + eol);
                    out.write("proxy.host: " + proxy.getHost() + eol);
                    if (proxy.getPort() != -1) {
                        out.write("proxy.port: " + proxy.getPort() + eol);
                    }
                    if ((userinfo = proxy.getUserInfo()) != null && userinfo.length() != 0) {
                        String password;
                        String[] tokens = userinfo.split(":", 2);
                        String user = tokens[0];
                        String string = password = tokens.length > 1 ? tokens[1] : null;
                        if (user != null) {
                            out.write("proxy.username: " + user + eol);
                        }
                        if (password != null) {
                            out.write("proxy.password: " + password + eol);
                        }
                        out.write("proxy.auth: true" + eol);
                    } else {
                        out.write("proxy.auth: false" + eol);
                    }
                } else {
                    out.write("proxy.required: false" + eol);
                }
            }
            out.close();
            SystemInfo.setPermissions(f, "0600");
        }
        catch (IOException e) {
            throw new Exception("Unable to initialize properties", e);
        }
    }

    private static File getConfigDir() throws IOException {
        String configpath;
        String homedir = System.getProperty("user.home");
        String osname = System.getProperty("os.name");
        String username = System.getProperty("user.name");
        if (osname.startsWith("Windows")) {
            configpath = new String(homedir + File.separator + WIN_APP_DATA + File.separator + APPNAME);
        } else if (osname.startsWith("Mac OS")) {
            if (username.equals("root")) {
                try {
                    homedir = SystemInfo.getMacHomeDir();
                }
                catch (Exception e) {
                    throw new IOException("Unable to determine $HOME for: " + username);
                }
            }
            configpath = new String(homedir + MAC_APP_DATA + APPNAME);
        } else {
            configpath = new String(homedir + File.separator + "." + APPNAME);
        }
        return new File(configpath);
    }

    private static String getMacHomeDir() throws Exception {
        String homedir = null;
        String[] cmdarray = new String[]{"/usr/bin/awk", "-F:", "{ if ( $1 == \"root\" ) print $6 }", "/etc/passwd"};
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(cmdarray);
        int exitVal = proc.waitFor();
        InputStream stdin = proc.getInputStream();
        InputStreamReader isr = new InputStreamReader(stdin);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            homedir = line;
        }
        stdin.close();
        InputStream stderr = proc.getErrorStream();
        isr = new InputStreamReader(stderr);
        br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
        }
        stderr.close();
        return homedir;
    }

    private static void setPermissions(File file, String mode) throws IOException {
        int m = Integer.parseInt(mode, 8);
        if (Action.haveJavaMethods) {
            try {
                boolean setOwnerExe = (m & 0x40) != 0;
                boolean setOtherExe = (m & 1) != 0;
                boolean setOwnerWrite = (m & 0x80) != 0;
                boolean setOtherWrite = (m & 2) != 0;
                boolean setOwnerRead = (m & 0x100) != 0;
                boolean setOtherRead = (m & 4) != 0;
                Action.setExecutable2.invoke((Object)file, setOtherExe, false);
                Action.setExecutable.invoke((Object)file, setOwnerExe);
                Action.setWritable2.invoke((Object)file, setOtherWrite, false);
                Action.setWritable.invoke((Object)file, setOwnerWrite);
                Action.setReadable2.invoke((Object)file, setOtherRead, false);
                Action.setReadable.invoke((Object)file, setOwnerRead);
                return;
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        if (Action.isPosix && file.isFile()) {
            String[] cmd = new String[]{"/bin/chmod", mode, file.getCanonicalPath()};
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                p.waitFor();
                if (p.exitValue() != 0) {
                    throw new Error("/bin/chmod failed");
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            return;
        }
    }

    private static File getInitFile() throws IOException {
        return new File(SystemInfo.getConfigDir(), INITFILE);
    }

    private static File getDefaultsFile() throws IOException {
        return new File(SystemInfo.getConfigDir(), DEFAULTSFILE);
    }

    private static BufferedReader getFileReader(File f) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
    }

    private static BufferedWriter getFileWriter(File f) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
    }

    static {
        os_arch_table.put("ia64", new ArchInfo("ia64", "64"));
        os_arch_table.put("ia64n", new ArchInfo("ia64", "64"));
        os_arch_table.put("sparc", new ArchInfo("sparc", "64"));
        os_arch_table.put("sparcv9", new ArchInfo("sparc", "64"));
        os_arch_table.put("amd64", new ArchInfo("i386", "64"));
        os_arch_table.put("x64", new ArchInfo("i386", "64"));
        os_arch_table.put("x86", new ArchInfo("i386", "32"));
        os_arch_table.put("x86_64", new ArchInfo("i386", "64"));
        os_arch_table.put("i386", new ArchInfo("i386", "32"));
        os_arch_table.put("i686", new ArchInfo("i386", "32"));
        os_arch_table.put("i686_64", new ArchInfo("i386", "64"));
        os_arch_table.put("pa-risc2.0", new ArchInfo("pa-risc", "64"));
        os_arch_table.put("pa-risc", new ArchInfo("pa-risc", "32"));
        os_arch_table.put("power", new ArchInfo("powerpc", "32"));
        os_arch_table.put("powerpc", new ArchInfo("powerpc", "32"));
        os_arch_table.put("ppc", new ArchInfo("powerpc", "32"));
        os_arch_table.put("ppc64", new ArchInfo("powerpc", "64"));
    }

    static class ArchInfo {
        String arch;
        String bits;

        public ArchInfo(String arch, String bits) {
            this.arch = arch;
            this.bits = bits;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateCheckFrequency {
        NEVER,
        DAILY,
        WEEKLY,
        MONTHLY;

    }
}

