/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variant {
    public static Map<String, String> tokensToVariantTable(String[] tokens) {
        Hashtable<String, String> variantTable = new Hashtable<String, String>();
        String[] variantPair = null;
        for (String t : tokens) {
            if (t == null || t.length() == 0 || !t.startsWith("variant.") || (variantPair = t.split("\\s*=\\s*", 2)) == null) continue;
            variantTable.put(variantPair[0].trim(), variantPair[1]);
        }
        return variantTable;
    }

    public static boolean isSelectedBy(String vname, String vvalue, Map<String, String> imageVariants) {
        if (vname == null || vname.length() == 0 || vvalue == null || vvalue.length() == 0) {
            return true;
        }
        if (imageVariants == null || imageVariants.size() == 0) {
            return false;
        }
        String imageValue = imageVariants.get(vname);
        if (imageValue == null) {
            return false;
        }
        return vvalue.equals(imageValue);
    }

    public static boolean isSelectedBy(Map<String, String> actionVariantTags, Map<String, String> imageVariants) {
        if (actionVariantTags == null || actionVariantTags.size() == 0) {
            return true;
        }
        if (imageVariants == null || imageVariants.size() == 0) {
            return false;
        }
        Set<String> actionVariantNames = actionVariantTags.keySet();
        for (String vname : actionVariantNames) {
            String vvalue;
            if (Variant.isSelectedBy(vname, vvalue = actionVariantTags.get(vname), imageVariants)) continue;
            return false;
        }
        return true;
    }

    public static boolean runTests() {
        Map<String, String> imageVariants = null;
        Map<String, String> actionVariantTags = null;
        int nfailures = 0;
        int nrun = 0;
        String[] imageVariantTokens = new String[]{"variant.os.bits=32", "variant.opensolaris.zone=global", "variant.arch=i386"};
        String[][] actionVariantTokensSelect = new String[][]{{"variant.os.bits=32", "variant.arch=i386"}, {"variant.os.bits=32"}, {"variant.arch=i386"}, {"variant.opensolaris.zone=global"}, {"variant.arch=i386", "random.property=foobar"}, {"random.property=foobar", "anotherrandomproperty=dog"}, {"random.property=foobar"}, {""}, {null}};
        String[][] actionVariantTokensNoSelect = new String[][]{{"variant.os.bits=64", "variant.arch=i386"}, {"variant.os.bits=32", "variant.arch=sparc"}, {"variant.os.bits=64", "variant.arch=sparc"}, {"variant.os.bits=32", "variant.arch=i386", "variant.junk=morejunk"}, {"variant.junk=morejunk"}, {"variant.os.bits=64"}, {"variant.os.bits=64", "random.property=foobar"}};
        imageVariants = Variant.tokensToVariantTable(imageVariantTokens);
        boolean match = false;
        for (String[] tokens : actionVariantTokensSelect) {
            actionVariantTags = Variant.tokensToVariantTable(tokens);
            match = Variant.isSelectedBy(actionVariantTags, imageVariants);
            ++nrun;
            if (match) continue;
            ++nfailures;
            Variant.testError(actionVariantTags, imageVariants, true);
        }
        for (String[] tokens : actionVariantTokensNoSelect) {
            actionVariantTags = Variant.tokensToVariantTable(tokens);
            match = Variant.isSelectedBy(actionVariantTags, imageVariants);
            ++nrun;
            if (!match) continue;
            ++nfailures;
            Variant.testError(actionVariantTags, imageVariants, false);
        }
        imageVariants.clear();
        for (String[] tokens : actionVariantTokensSelect) {
            actionVariantTags = Variant.tokensToVariantTable(tokens);
            if (actionVariantTags == null || actionVariantTags.isEmpty()) continue;
            match = Variant.isSelectedBy(actionVariantTags, imageVariants);
            ++nrun;
            if (!match) continue;
            ++nfailures;
            Variant.testError(actionVariantTags, imageVariants, false);
        }
        int npass = nrun - nfailures;
        System.out.println(nrun + " tests run: " + npass + " passed, " + nfailures + " failed.");
        return nfailures == 0;
    }

    public static void testError(Map<String, String> actionVariantTags, Map<String, String> imageVariants, boolean expectedResult) {
        if (expectedResult) {
            System.out.println("FAIL: Action with tags " + actionVariantTags.toString() + " was not selected by image variants " + imageVariants.toString());
        } else {
            System.out.println("FAIL: Action with tags " + actionVariantTags.toString() + " was selected by image variants " + imageVariants.toString());
        }
    }

    public static void main(String[] args) {
        Variant.runTests();
    }
}

