/*
 * Decompiled with CFR 0.152.
 */
package javassist.util.proxy;

import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javassist.util.proxy.SecurityActions;
import javassist.util.proxy.SerializedProxy;

public class RuntimeSupport {
    public static MethodHandler default_interceptor = new DefaultMethodHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void find2Methods(Object self, String superMethod, String thisMethod, int index, String desc, Method[] methods) {
        Method[] methodArray = methods;
        synchronized (methods) {
            if (methods[index] == null) {
                methods[index + 1] = thisMethod == null ? null : RuntimeSupport.findMethod(self, thisMethod, desc);
                methods[index] = RuntimeSupport.findSuperMethod(self, superMethod, desc);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public static Method findMethod(Object self, String name, String desc) {
        Method m = RuntimeSupport.findMethod2(self.getClass(), name, desc);
        if (m == null) {
            RuntimeSupport.error(self, name, desc);
        }
        return m;
    }

    public static Method findSuperMethod(Object self, String name, String desc) {
        Class<?> clazz = self.getClass();
        Method m = RuntimeSupport.findSuperMethod2(clazz.getSuperclass(), name, desc);
        if (m == null) {
            m = RuntimeSupport.searchInterfaces(clazz, name, desc);
        }
        if (m == null) {
            RuntimeSupport.error(self, name, desc);
        }
        return m;
    }

    private static void error(Object self, String name, String desc) {
        throw new RuntimeException("not found " + name + ":" + desc + " in " + self.getClass().getName());
    }

    private static Method findSuperMethod2(Class clazz, String name, String desc) {
        Method m = RuntimeSupport.findMethod2(clazz, name, desc);
        if (m != null) {
            return m;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (m = RuntimeSupport.findSuperMethod2(superClass, name, desc)) != null) {
            return m;
        }
        return RuntimeSupport.searchInterfaces(clazz, name, desc);
    }

    private static Method searchInterfaces(Class clazz, String name, String desc) {
        Method m = null;
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            m = RuntimeSupport.findSuperMethod2(interfaces[i], name, desc);
            if (m == null) continue;
            return m;
        }
        return m;
    }

    private static Method findMethod2(Class clazz, String name, String desc) {
        Method[] methods = SecurityActions.getDeclaredMethods(clazz);
        int n = methods.length;
        for (int i = 0; i < n; ++i) {
            if (!methods[i].getName().equals(name) || !RuntimeSupport.makeDescriptor(methods[i]).equals(desc)) continue;
            return methods[i];
        }
        return null;
    }

    public static String makeDescriptor(Method m) {
        Class[] params = m.getParameterTypes();
        return RuntimeSupport.makeDescriptor(params, m.getReturnType());
    }

    public static String makeDescriptor(Class[] params, Class retType) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        for (int i = 0; i < params.length; ++i) {
            RuntimeSupport.makeDesc(sbuf, params[i]);
        }
        sbuf.append(')');
        RuntimeSupport.makeDesc(sbuf, retType);
        return sbuf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void makeDesc(StringBuffer sbuf, Class type2) {
        if (type2.isArray()) {
            sbuf.append('[');
            RuntimeSupport.makeDesc(sbuf, type2.getComponentType());
            return;
        } else if (type2.isPrimitive()) {
            if (type2 == Void.TYPE) {
                sbuf.append('V');
                return;
            } else if (type2 == Integer.TYPE) {
                sbuf.append('I');
                return;
            } else if (type2 == Byte.TYPE) {
                sbuf.append('B');
                return;
            } else if (type2 == Long.TYPE) {
                sbuf.append('J');
                return;
            } else if (type2 == Double.TYPE) {
                sbuf.append('D');
                return;
            } else if (type2 == Float.TYPE) {
                sbuf.append('F');
                return;
            } else if (type2 == Character.TYPE) {
                sbuf.append('C');
                return;
            } else if (type2 == Short.TYPE) {
                sbuf.append('S');
                return;
            } else {
                if (type2 != Boolean.TYPE) throw new RuntimeException("bad type: " + type2.getName());
                sbuf.append('Z');
            }
            return;
        } else {
            sbuf.append('L').append(type2.getName().replace('.', '/')).append(';');
        }
    }

    public static SerializedProxy makeSerializedProxy(Object proxy) throws InvalidClassException {
        Class<?> clazz = proxy.getClass();
        MethodHandler methodHandler = null;
        if (proxy instanceof ProxyObject) {
            methodHandler = ((ProxyObject)proxy).getHandler();
        }
        return new SerializedProxy(clazz, ProxyFactory.getFilterSignature(clazz), methodHandler);
    }

    static class DefaultMethodHandler
    implements MethodHandler,
    Serializable {
        DefaultMethodHandler() {
        }

        public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Exception {
            return proceed.invoke(self, args);
        }
    }
}

