/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Table {
    private static PreparedStatement getColumnInfoStmt;
    private static PreparedStatement getColumnTypeStmt;
    private static PreparedStatement getAutoIncStmt;

    public static void doTables(Connection connection, HashMap hashMap) throws SQLException {
        getColumnInfoStmt = connection.prepareStatement("SELECT C.COLUMNNAME, C.REFERENCEID, C.COLUMNNUMBER FROM SYS.SYSCOLUMNS C, SYS.SYSTABLES T WHERE T.TABLEID = ? AND T.TABLEID = C.REFERENCEID ORDER BY C.COLUMNNUMBER");
        getColumnTypeStmt = connection.prepareStatement("SELECT COLUMNDATATYPE, COLUMNDEFAULT FROM SYS.SYSCOLUMNS WHERE REFERENCEID = ? AND COLUMNNAME = ?");
        getAutoIncStmt = connection.prepareStatement("SELECT AUTOINCREMENTSTART, AUTOINCREMENTINC, COLUMNNAME, REFERENCEID, COLUMNDEFAULT FROM SYS.SYSCOLUMNS WHERE COLUMNNAME = ? AND REFERENCEID = ?");
        boolean bl = true;
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            if (dblook.isExcludedTable(string2)) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_TablesHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL("CREATE TABLE " + string2 + " (");
            boolean bl2 = true;
            getColumnInfoStmt.setString(1, string);
            ResultSet resultSet = getColumnInfoStmt.executeQuery();
            while (resultSet.next()) {
                String string3 = dblook.addQuotes(resultSet.getString(1));
                String string4 = DB_Table.createColumn(string3, resultSet.getString(2), resultSet.getInt(3));
                if (!bl2) {
                    string4 = ", " + string4;
                }
                Logs.writeToNewDDL(string4);
                bl2 = false;
            }
            resultSet.close();
            Logs.writeToNewDDL(")");
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
        getColumnInfoStmt.close();
        getColumnTypeStmt.close();
        getAutoIncStmt.close();
    }

    private static String createColumn(String string, String string2, int n) throws SQLException {
        getColumnTypeStmt.setString(1, string2);
        getColumnTypeStmt.setString(2, dblook.stripQuotes(string));
        ResultSet resultSet = getColumnTypeStmt.executeQuery();
        StringBuffer stringBuffer = new StringBuffer();
        if (resultSet.next()) {
            stringBuffer.append(dblook.addQuotes(dblook.expandDoubleQuotes(dblook.stripQuotes(string))));
            stringBuffer.append(" ");
            stringBuffer.append(resultSet.getString(1));
            if (!DB_Table.reinstateAutoIncrement(string, string2, stringBuffer) && resultSet.getString(2) != null) {
                String string3 = resultSet.getString(2);
                if (string3.startsWith("GENERATED ALWAYS AS")) {
                    stringBuffer.append(" ");
                } else {
                    stringBuffer.append(" DEFAULT ");
                }
                stringBuffer.append(string3);
            }
        }
        resultSet.close();
        return stringBuffer.toString();
    }

    public static boolean reinstateAutoIncrement(String string, String string2, StringBuffer stringBuffer) throws SQLException {
        getAutoIncStmt.setString(1, dblook.stripQuotes(string));
        getAutoIncStmt.setString(2, string2);
        ResultSet resultSet = getAutoIncStmt.executeQuery();
        if (resultSet.next()) {
            long l = resultSet.getLong(1);
            if (!resultSet.wasNull()) {
                stringBuffer.append(" GENERATED ");
                stringBuffer.append(resultSet.getObject(5) == null ? "ALWAYS " : "BY DEFAULT ");
                stringBuffer.append("AS IDENTITY (START WITH ");
                stringBuffer.append(resultSet.getLong(1));
                stringBuffer.append(", INCREMENT BY ");
                stringBuffer.append(resultSet.getLong(2));
                stringBuffer.append(")");
                return true;
            }
        }
        return false;
    }
}

