/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.map.ser.BasicSerializerFactory;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.BeanSerializer;
import org.codehaus.jackson.map.ser.FilteredBeanPropertyWriter;
import org.codehaus.jackson.map.ser.JsonValueSerializer;
import org.codehaus.jackson.map.ser.PropertyBuilder;
import org.codehaus.jackson.map.type.TypeBindings;
import org.codehaus.jackson.map.util.ArrayBuilders;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.map.util.SubTypeHelper;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializerFactory
extends BasicSerializerFactory {
    public static final BeanSerializerFactory instance = new BeanSerializerFactory();

    protected BeanSerializerFactory() {
    }

    @Override
    public JsonSerializer<Object> createSerializer(JavaType type2, SerializationConfig config) {
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(type2.getRawClass());
        JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config, beanDesc.getClassInfo());
        if (ser == null && (ser = super.findSerializerByLookup(type2, config, beanDesc)) == null && (ser = super.findSerializerByPrimaryType(type2, config, beanDesc)) == null && (ser = this.findBeanSerializer(type2, config, beanDesc)) == null) {
            ser = super.findSerializerByAddonType(type2, config, beanDesc);
        }
        return ser;
    }

    public JsonSerializer<Object> findBeanSerializer(JavaType type2, SerializationConfig config, BasicBeanDescription beanDesc) {
        if (!this.isPotentialBeanType(type2.getRawClass())) {
            return null;
        }
        AnnotatedMethod valueMethod = beanDesc.findJsonValueMethod();
        if (valueMethod != null) {
            JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config, valueMethod);
            return new JsonValueSerializer(valueMethod.getAnnotated(), ser);
        }
        return this.constructBeanSerializer(config, beanDesc);
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType baseType, SerializationConfig config, AnnotatedMember propertyEntity) {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyTypeResolver(propertyEntity, baseType);
        if (b == null) {
            return this.createTypeSerializer(baseType, config);
        }
        List<NamedType> subtypes = SubTypeHelper.collectAndResolveSubtypes(propertyEntity, config, ai);
        return b.buildTypeSerializer(baseType, subtypes);
    }

    public TypeSerializer findPropertyContentTypeSerializer(JavaType containerType, SerializationConfig config, AnnotatedMember propertyEntity) {
        JavaType contentType = containerType.getContentType();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyContentTypeResolver(propertyEntity, containerType);
        if (b == null) {
            return this.createTypeSerializer(contentType, config);
        }
        List<NamedType> subtypes = SubTypeHelper.collectAndResolveSubtypes(propertyEntity, config, ai);
        return b.buildTypeSerializer(contentType, subtypes);
    }

    protected boolean isPotentialBeanType(Class<?> type2) {
        return ClassUtil.canBeABeanType(type2) == null && !ClassUtil.isProxyType(type2);
    }

    protected JsonSerializer<Object> constructBeanSerializer(SerializationConfig config, BasicBeanDescription beanDesc) {
        List<BeanPropertyWriter> props = this.findBeanProperties(config, beanDesc);
        if (props == null || props.size() == 0) {
            if (beanDesc.hasKnownClassAnnotations()) {
                return BeanSerializer.createDummy(beanDesc.getBeanClass());
            }
            return null;
        }
        props = this.filterBeanProperties(config, beanDesc, props);
        props = this.sortBeanProperties(config, beanDesc, props);
        BeanSerializer ser = new BeanSerializer(beanDesc.getBeanClass(), props);
        ser = this.processViews(config, beanDesc, ser, props);
        return ser;
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc) {
        VisibilityChecker<?> vchecker = config.getDefaultVisibilityChecker();
        if (!config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_GETTERS)) {
            vchecker = vchecker.withGetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS)) {
            vchecker = vchecker.withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_FIELDS)) {
            vchecker = vchecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
        }
        vchecker = config.getAnnotationIntrospector().findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        LinkedHashMap<String, AnnotatedMethod> methodsByProp = beanDesc.findGetters(vchecker, null);
        LinkedHashMap<String, AnnotatedField> fieldsByProp = beanDesc.findSerializableFields(vchecker, methodsByProp.keySet());
        if (methodsByProp.isEmpty() && fieldsByProp.isEmpty()) {
            return null;
        }
        boolean staticTyping = this.usesStaticTyping(config, beanDesc);
        PropertyBuilder pb = this.constructPropertyBuilder(config, beanDesc);
        ArrayList<BeanPropertyWriter> props = new ArrayList<BeanPropertyWriter>(methodsByProp.size());
        TypeBindings typeBind = beanDesc.bindingsForBeanType();
        for (Map.Entry<String, AnnotatedField> entry : fieldsByProp.entrySet()) {
            props.add(this._constructWriter(config, typeBind, pb, staticTyping, entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, AnnotatedMember> entry : methodsByProp.entrySet()) {
            props.add(this._constructWriter(config, typeBind, pb, staticTyping, entry.getKey(), entry.getValue()));
        }
        return props;
    }

    protected BeanPropertyWriter _constructWriter(SerializationConfig config, TypeBindings typeContext, PropertyBuilder pb, boolean staticTyping, String name, AnnotatedMember propertyMember) {
        if (config.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            propertyMember.fixAccess();
        }
        JsonSerializer<Object> annotatedSerializer = this.findSerializerFromAnnotation(config, propertyMember);
        TypeSerializer contentTypeSer = null;
        JavaType type2 = propertyMember.getType(typeContext);
        if (ClassUtil.isCollectionMapOrArray(type2.getRawClass())) {
            contentTypeSer = this.findPropertyContentTypeSerializer(type2, config, propertyMember);
        }
        TypeSerializer typeSer = this.findPropertyTypeSerializer(type2, config, propertyMember);
        BeanPropertyWriter pbw = pb.buildProperty(name, annotatedSerializer, typeSer, contentTypeSer, propertyMember, staticTyping);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        pbw.setViews(intr.findSerializationViews(propertyMember));
        return pbw;
    }

    protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc, List<BeanPropertyWriter> props) {
        AnnotatedClass ac;
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        String[] ignored = intr.findPropertiesToIgnore(ac = beanDesc.getClassInfo());
        if (ignored != null && ignored.length > 0) {
            HashSet<String> ignoredSet = ArrayBuilders.arrayToSet(ignored);
            Iterator<BeanPropertyWriter> it = props.iterator();
            while (it.hasNext()) {
                if (!ignoredSet.contains(it.next().getName())) continue;
                it.remove();
            }
        }
        return props;
    }

    protected List<BeanPropertyWriter> sortBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc, List<BeanPropertyWriter> props) {
        boolean sort;
        List<String> creatorProps = beanDesc.findCreatorPropertyNames();
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        AnnotatedClass ac = beanDesc.getClassInfo();
        String[] propOrder = intr.findSerializationPropertyOrder(ac);
        Boolean alpha = intr.findSerializationSortAlphabetically(ac);
        boolean bl = sort = alpha != null && alpha != false;
        if (sort || !creatorProps.isEmpty() || propOrder != null) {
            props = this._sortBeanProperties(props, creatorProps, propOrder, sort);
        }
        return props;
    }

    protected BeanSerializer processViews(SerializationConfig config, BasicBeanDescription beanDesc, BeanSerializer ser, List<BeanPropertyWriter> props) {
        boolean includeByDefault = config.isEnabled(SerializationConfig.Feature.DEFAULT_VIEW_INCLUSION);
        if (includeByDefault) {
            int i;
            int propCount = props.size();
            BeanPropertyWriter[] filtered = null;
            for (i = 0; i < propCount; ++i) {
                BeanPropertyWriter bpw = props.get(i);
                Class<?>[] views = bpw.getViews();
                if (views == null) continue;
                if (filtered == null) {
                    filtered = new BeanPropertyWriter[props.size()];
                }
                filtered[i] = this.constructFilteredBeanWriter(bpw, views);
            }
            if (filtered != null) {
                for (i = 0; i < propCount; ++i) {
                    if (filtered[i] != null) continue;
                    filtered[i] = props.get(i);
                }
                return ser.withFiltered(filtered);
            }
            return ser;
        }
        ArrayList<BeanPropertyWriter> explicit = new ArrayList<BeanPropertyWriter>(props.size());
        for (BeanPropertyWriter bpw : props) {
            Class<?>[] views = bpw.getViews();
            if (views == null) continue;
            explicit.add(this.constructFilteredBeanWriter(bpw, views));
        }
        BeanPropertyWriter[] filtered = explicit.toArray(new BeanPropertyWriter[explicit.size()]);
        return ser.withFiltered(filtered);
    }

    protected BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter writer, Class<?>[] inViews) {
        return FilteredBeanPropertyWriter.constructViewBased(writer, inViews);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig config, BasicBeanDescription beanDesc) {
        return new PropertyBuilder(config, beanDesc);
    }

    List<BeanPropertyWriter> _sortBeanProperties(List<BeanPropertyWriter> props, List<String> creatorProps, String[] propertyOrder, boolean sort) {
        int size = props.size();
        AbstractMap all = sort ? new TreeMap() : new LinkedHashMap(size * 2);
        for (BeanPropertyWriter w : props) {
            all.put(w.getName(), w);
        }
        LinkedHashMap<String, BeanPropertyWriter> ordered = new LinkedHashMap<String, BeanPropertyWriter>(size * 2);
        if (propertyOrder != null) {
            for (String name : propertyOrder) {
                BeanPropertyWriter w = (BeanPropertyWriter)all.get(name);
                if (w == null) continue;
                ordered.put(name, w);
            }
        }
        for (String name : creatorProps) {
            BeanPropertyWriter w = (BeanPropertyWriter)all.get(name);
            if (w == null) continue;
            ordered.put(name, w);
        }
        ordered.putAll(all);
        return new ArrayList<BeanPropertyWriter>(ordered.values());
    }
}

