/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.sql.Timestamp;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;

public class VersionAccessor
extends BasicAccessor {
    public VersionAccessor() {
        super("<version>");
    }

    public VersionAccessor(MetadataAnnotation version, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(version, accessibleObject, classAccessor);
    }

    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof VersionAccessor;
    }

    protected boolean isValidTimestampVersionLockingType(MetadataClass cls) {
        return cls.equals(Timestamp.class);
    }

    protected boolean isValidVersionLockingType(MetadataClass cls) {
        return cls.equals(Integer.TYPE) || cls.equals(Integer.class) || cls.equals(Short.TYPE) || cls.equals(Short.class) || cls.equals(Long.TYPE) || cls.equals(Long.class);
    }

    public void process() {
        super.process();
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getLogger().logConfigMessage("metadata_warning_ignore_version_locking", this);
        } else {
            MetadataClass lockType = this.getRawClass();
            this.getField().setType(this.getJavaClass(lockType));
            if (this.isValidVersionLockingType(lockType) || this.isValidTimestampVersionLockingType(lockType)) {
                for (MetadataDescriptor owningDescriptor : this.getOwningDescriptors()) {
                    VersionLockingPolicy policy = this.isValidVersionLockingType(lockType) ? new VersionLockingPolicy(this.getField()) : new TimestampLockingPolicy(this.getField());
                    policy.storeInObject();
                    policy.setIsCascaded(this.getDescriptor().usesCascadedOptimisticLocking());
                    owningDescriptor.setOptimisticLockingPolicy(policy);
                }
            } else {
                throw ValidationException.invalidTypeForVersionAttribute(this.getAttributeName(), lockType, this.getJavaClass());
            }
        }
    }
}

