/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.changetracking;

import org.eclipse.persistence.annotations.ChangeTrackingType;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class ChangeTrackingMetadata
extends ORMetadata {
    private String m_type;

    public ChangeTrackingMetadata() {
        super("<change-tracking>");
    }

    public ChangeTrackingMetadata(MetadataAnnotation changeTracking, MetadataAccessibleObject accessibleObject) {
        super(changeTracking, accessibleObject);
        this.m_type = (String)changeTracking.getAttribute("value");
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ChangeTrackingMetadata) {
            ChangeTrackingMetadata changeTracking = (ChangeTrackingMetadata)objectToCompare;
            return this.valuesMatch(this.m_type, changeTracking.getType());
        }
        return false;
    }

    public String getType() {
        return this.m_type;
    }

    public void process(MetadataDescriptor descriptor) {
        descriptor.setHasChangeTracking();
        RelationalDescriptor classDescriptor = descriptor.getClassDescriptor();
        if (this.m_type == null || this.m_type.equals(ChangeTrackingType.AUTO.name())) {
            classDescriptor.setObjectChangePolicy(null);
        } else if (this.m_type.equals(ChangeTrackingType.ATTRIBUTE.name())) {
            classDescriptor.setObjectChangePolicy(new AttributeChangeTrackingPolicy());
        } else if (this.m_type.equals(ChangeTrackingType.OBJECT.name())) {
            classDescriptor.setObjectChangePolicy(new ObjectChangeTrackingPolicy());
        } else if (this.m_type.equals(ChangeTrackingType.DEFERRED.name())) {
            classDescriptor.setObjectChangePolicy(new DeferredChangeDetectionPolicy());
        }
    }

    public void setType(String type2) {
        this.m_type = type2;
    }
}

