/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.jpa.parsing.ArithmeticFunctionNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class ModNode
extends ArithmeticFunctionNode {
    private Node denominator = null;

    public Node qualifyAttributeAccess(ParseTreeContext context) {
        if (this.left != null) {
            this.left = this.left.qualifyAttributeAccess(context);
        }
        if (this.denominator != null) {
            this.denominator = this.denominator.qualifyAttributeAccess(context);
        }
        return this;
    }

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
            this.left.validateParameter(context, typeHelper.getIntType());
            Object type2 = this.left.getType();
            if (!typeHelper.isIntegralType(type2)) {
                throw JPQLException.invalidFunctionArgument(context.getQueryInfo(), this.left.getLine(), this.left.getColumn(), "MOD", this.left.getAsString(), "integral type");
            }
        }
        if (this.denominator != null) {
            this.denominator.validate(context);
            this.denominator.validateParameter(context, typeHelper.getIntType());
            Object denominatorType = this.denominator.getType();
            if (!typeHelper.isIntegralType(denominatorType)) {
                throw JPQLException.invalidFunctionArgument(context.getQueryInfo(), this.denominator.getLine(), this.denominator.getColumn(), "MOD", this.denominator.getAsString(), "integral type");
            }
        }
        this.setType(typeHelper.getIntType());
    }

    public Expression generateExpression(GenerationContext context) {
        return ExpressionMath.mod(this.getLeft().generateExpression(context), this.getDenominator().generateExpression(context));
    }

    public Node getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Node denominator) {
        this.denominator = denominator;
    }
}

