/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util.attrs;

import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.attrs.LocalVariableType;
import org.eclipse.persistence.internal.libraries.asm.attrs.LocalVariableTypeTableAttribute;
import org.eclipse.persistence.internal.libraries.asm.util.attrs.ASMifiable;

public class ASMLocalVariableTypeTableAttribute
extends LocalVariableTypeTableAttribute
implements ASMifiable {
    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        LocalVariableTypeTableAttribute attr = (LocalVariableTypeTableAttribute)super.read(cr, off, len, buf, codeOff, labels);
        ASMLocalVariableTypeTableAttribute res = new ASMLocalVariableTypeTableAttribute();
        res.getTypes().addAll(attr.getTypes());
        return res;
    }

    public void asmify(StringBuffer buf, String varName, Map labelNames) {
        buf.append("LocalVariableTypeTableAttribute ").append(varName).append(" = new LocalVariableTypeTableAttribute();\n");
        buf.append("{\n");
        buf.append("LocalVariableTypeTableAttribute ").append(varName).append("Attr");
        buf.append(" = new LocalVariableTypeTableAttribute();\n");
        if (this.types.size() > 0) {
            int i = 0;
            while (i < this.types.size()) {
                this.asmify((LocalVariableType)this.types.get(i), buf, String.valueOf(varName) + "type" + i, labelNames);
                ++i;
            }
        }
        buf.append(varName).append(".visitAttribute(").append(varName);
        buf.append("Attr);\n}\n");
    }

    private void asmify(LocalVariableType type2, StringBuffer buf, String varName, Map labelNames) {
        ASMLocalVariableTypeTableAttribute.declareLabel(buf, labelNames, type2.start);
        ASMLocalVariableTypeTableAttribute.declareLabel(buf, labelNames, type2.end);
        buf.append("{\n");
        buf.append("LocalVariableType ").append(varName).append(" = new LocalVariableType();\n");
        buf.append(varName).append(".start = ").append(labelNames.get(type2.start)).append(";\n");
        buf.append(varName).append(".end = ").append(labelNames.get(type2.end)).append(";\n");
        buf.append(varName).append(".name = \"").append(type2.name).append("\";\n");
        buf.append(varName).append(".signature = ").append(type2.signature).append("\";\n");
        buf.append(varName).append(".index = ").append(type2.index).append("\";\n");
        buf.append("cvAttr.types.add(").append(varName).append(");\n");
        buf.append("}\n");
    }

    static void declareLabel(StringBuffer buf, Map labelNames, Label l) {
        String name = (String)labelNames.get(l);
        if (name == null) {
            name = "l" + labelNames.size();
            labelNames.put(l, name);
            buf.append("Label ").append(name).append(" = new Label();\n");
        }
    }
}

