/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
public abstract class CollectionLeafResource {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected Habitat habitat;
    protected List<String> entity;
    protected Dom parent;
    protected String tagName;
    protected String target;
    protected String profiler = "false";
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CollectionLeafResource.class);

    public void setEntity(List<String> p) {
        this.entity = p;
    }

    public List<String> getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        if (parent != null) {
            this.entity = parent.leafElements(tagName);
            if (parent.type().equals(JavaConfig.class)) {
                this.target = parent.parent().attribute("name");
            } else {
                this.target = parent.parent().parent().attribute("name");
                this.profiler = "true";
            }
        }
    }

    @GET
    public Response get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        if (this.getEntity() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Response.ok(this.buildActionReportResult()).build();
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response create(HashMap<String, String> data) throws TransactionFailure {
        if (data.containsKey("operation") && data.get("operation").equals("__deleteoperation")) {
            data.remove("operation");
            return this.delete(data);
        }
        String postCommand = this.getPostCommand();
        Map<String, String> payload = null;
        if (this.isJvmOptions(postCommand)) {
            this.deleteExistingOptions();
            payload = this.processData(data);
        } else {
            payload = data;
        }
        return this.runCommand(postCommand, payload, "rest.resource.create.message", "\"{0}\" created successfully.", "rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.");
    }

    @PUT
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response add(HashMap<String, String> data) throws TransactionFailure {
        String postCommand = this.getPostCommand();
        Map<String, String> payload = null;
        payload = this.isJvmOptions(postCommand) ? this.processData(data) : data;
        return this.runCommand(postCommand, payload, "rest.resource.create.message", "\"{0}\" created successfully.", "rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.");
    }

    @DELETE
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response delete(HashMap<String, String> data) {
        ResourceUtil.addQueryString(this.uriInfo.getQueryParameters(), data);
        String deleteCommand = this.getDeleteCommand();
        if (this.isJvmOptions(deleteCommand)) {
            if (data.isEmpty()) {
                this.deleteExistingOptions();
                return Response.ok().build();
            }
            return this.runCommand(deleteCommand, this.processData(data), "rest.resource.delete.message", "\"{0}\" deleted successfully.", "rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.");
        }
        return this.runCommand(deleteCommand, data, "rest.resource.delete.message", "\"{0}\" deleted successfully.", "rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.");
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html;qs=2", "application/xml"})
    public Response options() {
        return Response.ok(this.buildActionReportResult()).build();
    }

    protected ActionReportResult buildActionReportResult() {
        RestActionReporter ar = new RestActionReporter();
        String typeKey = Util.upperCaseFirstLetter(Util.decode(this.getName()));
        ar.setActionDescription(typeKey);
        ar.getExtraProperties().put("leafList", this.getEntity());
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        Map<String, MethodMetaData> mmd = this.getMethodMetaData();
        optionsResult.putMethodMetaData("GET", mmd.get("GET"));
        optionsResult.putMethodMetaData("POST", mmd.get("POST"));
        ResourceUtil.addMethodMetaData(ar, mmd);
        return new ActionReportResult(ar, optionsResult);
    }

    protected Map<String, MethodMetaData> getMethodMetaData() {
        String deleteCommand;
        TreeMap<String, MethodMetaData> mmd = new TreeMap<String, MethodMetaData>();
        mmd.put("GET", new MethodMetaData());
        String postCommand = this.getPostCommand();
        if (postCommand != null) {
            MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData(postCommand, this.habitat, RestService.logger);
            mmd.put("POST", postMethodMetaData);
        }
        if ((deleteCommand = this.getDeleteCommand()) != null) {
            MethodMetaData deleteMethodMetaData = ResourceUtil.getMethodMetaData(deleteCommand, this.habitat, RestService.logger);
            mmd.put("DELETE", deleteMethodMetaData);
        }
        return mmd;
    }

    protected void addDefaultParameter(Map<String, String> data) {
        int index = this.uriInfo.getAbsolutePath().getPath().lastIndexOf(47);
        String defaultParameterValue = this.uriInfo.getAbsolutePath().getPath().substring(index + 1);
        data.put("DEFAULT", defaultParameterValue);
    }

    protected String getPostCommand() {
        return null;
    }

    protected String getDeleteCommand() {
        return null;
    }

    protected String getName() {
        return Util.getResourceName(this.uriInfo);
    }

    private Response runCommand(String commandName, Map<String, String> data, String successMsgKey, String successMsg, String operationForbiddenMsgKey, String operationForbiddenMsg) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return Response.status(400).entity(ResourceUtil.getActionReportResult(400, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            ResourceUtil.purgeEmptyEntries(data);
            ResourceUtil.adjustParameters(data);
            String attributeName = data.get("DEFAULT");
            if (null != commandName) {
                String typeOfResult = ResourceUtil.getResultType(this.requestHeaders);
                RestActionReporter actionReport = ResourceUtil.runCommand(commandName, data, this.habitat, typeOfResult);
                ActionReport.ExitCode exitCode = ((ActionReport)actionReport).getActionExitCode();
                if (exitCode != ActionReport.ExitCode.FAILURE) {
                    String successMessage = localStrings.getLocalString(successMsgKey, successMsg, attributeName);
                    return Response.ok(ResourceUtil.getActionReportResult(200, successMessage, this.requestHeaders, this.uriInfo)).build();
                }
                String errorMessage = this.getErrorMessage(data, actionReport);
                return Response.status(400).entity(ResourceUtil.getActionReportResult(400, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            String message = localStrings.getLocalString(operationForbiddenMsgKey, operationForbiddenMsg, this.uriInfo.getAbsolutePath());
            return Response.status(403).entity(ResourceUtil.getActionReportResult(403, message, this.requestHeaders, this.uriInfo)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getErrorMessage(Map<String, String> data, ActionReport ar) {
        String message = ar.getMessage();
        return message;
    }

    private Map<String, String> processData(Map<String, String> data) {
        HashMap<String, String> results = new HashMap<String, String>();
        StringBuilder options = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            if ("target".equals(key) || "profiler".equals(key)) {
                results.put(key, entry.getValue());
                continue;
            }
            options.append(sep).append(this.escapeOptionPart(entry.getKey()));
            String value = entry.getValue();
            if (value != null && !value.isEmpty()) {
                options.append("=").append(this.escapeOptionPart(entry.getValue()));
            }
            sep = ":";
        }
        results.put("id", options.toString());
        if (results.get("target") == null) {
            results.put("target", this.target);
        }
        if (results.get("profiler") == null) {
            results.put("profiler", this.profiler);
        }
        return results;
    }

    protected String escapeOptionPart(String part) {
        String changed = part.replaceAll(":", "\\\\:");
        return changed;
    }

    private boolean isJvmOptions(String command) {
        return command != null && command.contains("jvm-options");
    }

    protected void deleteExistingOptions() {
        HashMap<String, String> existing = new HashMap<String, String>();
        existing.put("target", this.target);
        for (String option : this.getEntity()) {
            int index = option.indexOf("=");
            if (index > -1) {
                existing.put(option.substring(0, index), option.substring(index + 1));
                continue;
            }
            existing.put(option, "");
        }
        this.runCommand(this.getDeleteCommand(), this.processData(existing), "rest.resource.delete.message", "\"{0}\" deleted successfully.", "rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.");
    }
}

