/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.jersey.api.client.Client;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ProxyImpl;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="domain{path:.*}")
@Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
public class MonitoringResource {
    @PathParam(value="path")
    String path;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected Habitat habitat;
    @Context
    protected Client client;

    @GET
    @Produces(value={"application/json", "application/xml", "text/html;qs=2"})
    public ActionReportResult getChildNodes() {
        String root;
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        RestActionReporter ar = new RestActionReporter();
        ar.setActionDescription("Monitoring Data");
        ar.setMessage("");
        ar.setSuccess();
        ActionReportResult result = new ActionReportResult(ar);
        MonitoringRuntimeDataRegistry monitoringRegistry = this.habitat.getComponent(MonitoringRuntimeDataRegistry.class);
        if (this.path == null) {
            return result;
        }
        if (monitoringRegistry == null) {
            return result;
        }
        String currentInstanceName = System.getProperty("com.sun.aas.instanceName");
        if (this.path.equals("") || this.path.equals("/")) {
            TreeNode serverNode = monitoringRegistry.get(currentInstanceName);
            if (serverNode != null) {
                if (!serverNode.getEnabledChildNodes().isEmpty()) {
                    list.add(serverNode);
                    this.constructEntity(list, ar);
                    Domain domain = this.habitat.getComponent(Domain.class);
                    Map links = (Map)ar.getExtraProperties().get("childResources");
                    for (Server s : domain.getServers().getServer()) {
                        if (s.getName().equals("server")) continue;
                        links.put(s.getName(), ProviderUtil.getElementLink(this.uriInfo, s.getName()));
                    }
                }
                return result;
            }
            return result;
        }
        if (this.path.startsWith("/")) {
            this.path = this.path.substring(1);
        }
        if (!this.path.startsWith(currentInstanceName)) {
            Properties proxiedResponse = new MonitoringProxyImpl().proxyRequest(this.uriInfo, this.client, this.habitat);
            ar.setExtraProperties(proxiedResponse);
            return result;
        }
        this.path = this.path.replaceAll("\\.", "\\\\.");
        String dottedName = this.path.replace('/', '.');
        int index = dottedName.indexOf(46);
        if (index != -1) {
            root = dottedName.substring(0, index);
            dottedName = dottedName.substring(index + 1);
        } else {
            root = dottedName;
            dottedName = "";
        }
        TreeNode rootNode = monitoringRegistry.get(root);
        if (rootNode == null) {
            return result;
        }
        TreeNode currentNode = dottedName.length() > 0 ? rootNode.getNode(dottedName) : rootNode;
        if (currentNode == null) {
            return result;
        }
        if (currentNode.hasChildNodes()) {
            list.addAll(currentNode.getEnabledChildNodes());
        } else {
            Object r = currentNode.getValue();
            System.out.println("result: " + r);
            list.add(currentNode);
        }
        this.constructEntity(list, ar);
        return result;
    }

    private void constructEntity(List<TreeNode> nodeList, RestActionReporter ar) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (TreeNode node : nodeList) {
            if (node.hasChildNodes()) continue;
            Object value = node.getValue();
            if (value == null) {
                return;
            }
            try {
                if (value instanceof Statistic) {
                    Statistic statisticObject = (Statistic)value;
                    Map<String, Object> data = ProviderUtil.getStatistic(statisticObject);
                    map.put(node.getName(), data);
                    continue;
                }
                if (value instanceof Stats) {
                    TreeMap<String, Map<String, Object>> subMap = new TreeMap<String, Map<String, Object>>();
                    for (Statistic statistic : ((Stats)value).getStatistics()) {
                        Map<String, Object> data2 = ProviderUtil.getStatistic(statistic);
                        subMap.put(statistic.getName(), data2);
                    }
                    map.put(node.getName(), subMap);
                    continue;
                }
                map.put(node.getName(), ProviderUtil.jsonValue(value));
            }
            catch (Exception exception) {}
        }
        ar.getExtraProperties().put("entity", map);
        TreeMap<String, String> links = new TreeMap<String, String>();
        for (TreeNode node : nodeList) {
            if (!node.hasChildNodes()) continue;
            String name = node.getName();
            name = name.replace("\\.", ".");
            links.put(name, ProviderUtil.getElementLink(this.uriInfo, name));
        }
        ar.getExtraProperties().put("childResources", links);
    }

    private static class MonitoringProxyImpl
    extends ProxyImpl {
        private MonitoringProxyImpl() {
        }

        public UriBuilder constructTargetURLPath(UriInfo sourceUriInfo, URL responseURLReceivedFromTarget) {
            return sourceUriInfo.getBaseUriBuilder().replacePath(responseURLReceivedFromTarget.getFile());
        }

        public UriBuilder constructForwardURLPath(UriInfo sourceUriInfo) {
            return sourceUriInfo.getAbsolutePathBuilder();
        }

        public String extractTargetInstanceName(UriInfo uriInfo) {
            return uriInfo.getPathSegments().get(1).getPath();
        }
    }
}

