/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.apf.impl.AnnotationProcessorImpl;
import org.glassfish.apf.impl.AnnotationUtils;

public abstract class Factory {
    private static Set<String> skipAnnotationClassList = null;
    private static final String SKIP_ANNOTATION_CLASS_LIST_URL = "skip-annotation-class-list";

    protected Factory() {
    }

    public static AnnotationProcessorImpl getDefaultAnnotationProcessor() {
        return new AnnotationProcessorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initSkipAnnotationClassList() {
        if (skipAnnotationClassList == null) {
            skipAnnotationClassList = new HashSet<String>();
            InputStream is = null;
            try {
                String className;
                is = AnnotationProcessorImpl.class.getClassLoader().getResourceAsStream(SKIP_ANNOTATION_CLASS_LIST_URL);
                if (is == null) {
                    AnnotationUtils.getLogger().log(Level.FINE, "no annotation skipping class list found");
                    return;
                }
                BufferedReader bf = new BufferedReader(new InputStreamReader(is));
                while ((className = bf.readLine()) != null) {
                    skipAnnotationClassList.add(className.trim());
                }
            }
            catch (IOException ioe) {
                AnnotationUtils.getLogger().log(Level.WARNING, ioe.getMessage(), ioe);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static boolean isSkipAnnotationProcessing(String cName) {
        if (skipAnnotationClassList == null) {
            Factory.initSkipAnnotationClassList();
        }
        return skipAnnotationClassList.contains(cName);
    }
}

