/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.invocation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class InvocationManagerImpl
implements InvocationManager {
    public static boolean debug;
    private InheritableThreadLocal<InvocationArray<ComponentInvocation>> frames;
    private Map<ComponentInvocation.ComponentInvocationType, List<RegisteredComponentInvocationHandler>> regCompInvHandlerMap = new HashMap<ComponentInvocation.ComponentInvocationType, List<RegisteredComponentInvocationHandler>>();
    @Inject
    Habitat habitat;
    @Inject(optional=true)
    ComponentInvocationHandler[] invHandlers = null;

    public InvocationManagerImpl() {
        this.frames = new InheritableThreadLocal<InvocationArray<ComponentInvocation>>(){

            @Override
            protected InvocationArray initialValue() {
                return new InvocationArray();
            }

            @Override
            protected InvocationArray<ComponentInvocation> childValue(InvocationArray<ComponentInvocation> parentValue) {
                InvocationArray<ComponentInvocation> result = new InvocationArray<ComponentInvocation>();
                InvocationArray<ComponentInvocation> v = parentValue;
                if (v.size() > 0 && v.outsideStartup()) {
                    ComponentInvocation parentInv = (ComponentInvocation)v.get(v.size() - 1);
                    if (parentInv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION) {
                        ComponentInvocation inv = new ComponentInvocation();
                        inv.componentId = parentInv.getComponentId();
                        inv.setComponentInvocationType(parentInv.getInvocationType());
                        inv.instance = null;
                        inv.container = parentInv.getContainerContext();
                        inv.transaction = null;
                        result.add(inv);
                    } else if (parentInv.getInvocationType() != ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                        ComponentInvocation cpy = new ComponentInvocation();
                        cpy.componentId = parentInv.getComponentId();
                        cpy.setComponentInvocationType(parentInv.getInvocationType());
                        cpy.instance = parentInv.getInstance();
                        cpy.container = parentInv.getContainerContext();
                        cpy.transaction = parentInv.getTransaction();
                        result.add(cpy);
                    }
                }
                return result;
            }
        };
    }

    @Override
    public <T extends ComponentInvocation> void preInvoke(T inv) throws InvocationException {
        List<RegisteredComponentInvocationHandler> setCIH;
        InvocationArray v = (InvocationArray)this.frames.get();
        if (inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP) {
            v.setInvocationAttribute(ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP);
            return;
        }
        int beforeSize = v.size();
        ComponentInvocation prevInv = beforeSize > 0 ? (ComponentInvocation)v.get(beforeSize - 1) : null;
        ComponentInvocation.ComponentInvocationType invType = inv.getInvocationType();
        if (this.invHandlers != null) {
            for (ComponentInvocationHandler handler : this.invHandlers) {
                handler.beforePreInvoke(invType, prevInv, inv);
            }
        }
        if ((setCIH = this.regCompInvHandlerMap.get((Object)invType)) != null) {
            for (int i = 0; i < setCIH.size(); ++i) {
                setCIH.get(i).getComponentInvocationHandler().beforePreInvoke(invType, prevInv, inv);
            }
        }
        v.add(inv);
        if (this.invHandlers != null) {
            for (ComponentInvocationHandler handler : this.invHandlers) {
                handler.afterPreInvoke(invType, prevInv, inv);
            }
        }
        if (setCIH != null) {
            for (int i = 0; i < setCIH.size(); ++i) {
                setCIH.get(i).getComponentInvocationHandler().afterPreInvoke(invType, prevInv, inv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ComponentInvocation> void postInvoke(T inv) throws InvocationException {
        ComponentInvocation.ComponentInvocationType invType3;
        List<RegisteredComponentInvocationHandler> setCIH3;
        InvocationArray v = (InvocationArray)this.frames.get();
        if (inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP) {
            v.setInvocationAttribute(ComponentInvocation.ComponentInvocationType.UN_INITIALIZED);
            return;
        }
        int beforeSize = v.size();
        if (beforeSize == 0) {
            throw new InvocationException();
        }
        ComponentInvocation prevInv = beforeSize > 1 ? (ComponentInvocation)v.get(beforeSize - 2) : null;
        ComponentInvocation curInv = (ComponentInvocation)v.get(beforeSize - 1);
        try {
            List<RegisteredComponentInvocationHandler> setCIH2;
            ComponentInvocation.ComponentInvocationType invType2 = inv.getInvocationType();
            if (this.invHandlers != null) {
                for (ComponentInvocationHandler handler : this.invHandlers) {
                    handler.beforePostInvoke(invType2, prevInv, curInv);
                }
            }
            if ((setCIH2 = this.regCompInvHandlerMap.get((Object)invType2)) != null) {
                for (int i = 0; i < setCIH2.size(); ++i) {
                    setCIH2.get(i).getComponentInvocationHandler().beforePostInvoke(invType2, prevInv, curInv);
                }
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            ComponentInvocation.ComponentInvocationType invType3;
            List<RegisteredComponentInvocationHandler> setCIH3;
            Object var12_12 = null;
            v.remove(beforeSize - 1);
            if (this.invHandlers != null) {
                for (ComponentInvocationHandler handler : this.invHandlers) {
                    handler.afterPostInvoke(inv.getInvocationType(), prevInv, inv);
                }
            }
            if ((setCIH3 = this.regCompInvHandlerMap.get((Object)(invType3 = inv.getInvocationType()))) != null) {
                for (int i = 0; i < setCIH3.size(); ++i) {
                    setCIH3.get(i).getComponentInvocationHandler().afterPostInvoke(invType3, prevInv, curInv);
                }
            }
            throw throwable;
        }
        v.remove(beforeSize - 1);
        if (this.invHandlers != null) {
            for (ComponentInvocationHandler handler : this.invHandlers) {
                handler.afterPostInvoke(inv.getInvocationType(), prevInv, inv);
            }
        }
        if ((setCIH3 = this.regCompInvHandlerMap.get((Object)(invType3 = inv.getInvocationType()))) != null) {
            for (int i = 0; i < setCIH3.size(); ++i) {
                setCIH3.get(i).getComponentInvocationHandler().afterPostInvoke(invType3, prevInv, curInv);
            }
        }
    }

    @Override
    public boolean isInvocationStackEmpty() {
        ArrayList v = (ArrayList)this.frames.get();
        return v == null || v.size() == 0;
    }

    @Override
    public <T extends ComponentInvocation> T getCurrentInvocation() {
        ArrayList v = (ArrayList)this.frames.get();
        int size = v.size();
        if (size == 0) {
            return null;
        }
        return (T)((ComponentInvocation)v.get(size - 1));
    }

    @Override
    public <T extends ComponentInvocation> T getPreviousInvocation() throws InvocationException {
        ArrayList v = (ArrayList)this.frames.get();
        int i = v.size();
        if (i < 2) {
            return null;
        }
        return (T)((ComponentInvocation)v.get(i - 2));
    }

    public List getAllInvocations() {
        return (List)this.frames.get();
    }

    @Override
    public void registerComponentInvocationHandler(ComponentInvocation.ComponentInvocationType type2, RegisteredComponentInvocationHandler handler) {
        List<RegisteredComponentInvocationHandler> setRegCompInvHandlers = this.regCompInvHandlerMap.get((Object)type2);
        if (setRegCompInvHandlers == null) {
            setRegCompInvHandlers = new ArrayList<RegisteredComponentInvocationHandler>();
            this.regCompInvHandlerMap.put(type2, setRegCompInvHandlers);
        }
        if (setRegCompInvHandlers.size() == 0) {
            setRegCompInvHandlers.add(handler);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InvocationArray<T extends ComponentInvocation>
    extends ArrayList<T> {
        private ComponentInvocation.ComponentInvocationType invocationAttribute;

        InvocationArray() {
        }

        public void setInvocationAttribute(ComponentInvocation.ComponentInvocationType attribute) {
            this.invocationAttribute = attribute;
        }

        public ComponentInvocation.ComponentInvocationType getInvocationAttribute() {
            return this.invocationAttribute;
        }

        public boolean outsideStartup() {
            return this.getInvocationAttribute() != ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP;
        }
    }
}

