/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.ExtensionModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.config.serverbeans.WebModule;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class UpgradeService
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Domain domain;
    @Inject(name="gmsupgrade", optional=true)
    ConfigurationUpgrade precondition = null;
    private static final Logger logger = Logger.getAnonymousLogger();
    private static final String MODULE_TYPE = "moduleType";
    private static final String APPCLIENT_SNIFFER_NAME = "appclient";
    private static final String V3_0_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME = "javaWebStartEnabled";
    private static final String GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME = "java-web-start-enabled";

    @Override
    public void postConstruct() {
        this.upgradeApplicationElements();
    }

    private void upgradeApplicationElements() {
        this.upgradeV2ApplicationElements();
        this.upgradeV3PreludeApplicationElements();
        this.upgradeV3_0_1_AppClientElements();
    }

    private void upgradeV3PreludeApplicationElements() {
        ArrayList<Application> allApps = new ArrayList<Application>();
        allApps.addAll(this.domain.getApplications().getApplications());
        allApps.addAll(this.domain.getSystemApplications().getApplications());
        for (Application app : allApps) {
            if (app.getEngine() == null || app.getEngine().size() <= 0 || app.getModule() != null && app.getModule().size() != 0) continue;
            try {
                ConfigSupport.apply(new SingleConfigCode<Application>(){

                    @Override
                    public Object run(Application application) throws PropertyVetoException, TransactionFailure {
                        Module module = application.createChild(Module.class);
                        module.setName(application.getName());
                        for (Engine engine : application.getEngine()) {
                            module.getEngines().add(engine);
                        }
                        application.getModule().add(module);
                        application.getEngine().clear();
                        return null;
                    }
                }, app);
            }
            catch (TransactionFailure tf) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading application " + app.getName() + " please redeploy", tf);
                throw new RuntimeException(tf);
            }
        }
    }

    private <T extends PropertyBag & ConfigBeanProxy> Property addProperty(String propName, String propValue, T owner_w) throws TransactionFailure, PropertyVetoException {
        Property p = ((ConfigBeanProxy)owner_w).createChild(Property.class);
        p.setName(propName);
        p.setValue(propValue);
        owner_w.getProperty().add(p);
        return p;
    }

    private void upgradeV3_0_1_AppClientElements() {
        Transaction t = new Transaction();
        try {
            for (Application app : this.domain.getApplications().getApplications()) {
                System.out.println("Checking app " + app.getName());
                Application app_w = null;
                Property oldSetting = app.getProperty(V3_0_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME);
                if (oldSetting != null) {
                    logger.log(Level.INFO, "For application {0} converting property {1} to {2}", new Object[]{app.getName(), V3_0_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME, GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME});
                    app_w = t.enroll(app);
                    this.addProperty(GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME, oldSetting.getValue(), app_w);
                    app_w.getProperty().remove(oldSetting);
                }
                for (Module mod : app.getModule()) {
                    if (mod.getEngine(APPCLIENT_SNIFFER_NAME) == null || (oldSetting = mod.getProperty(V3_0_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME)) == null) continue;
                    logger.log(Level.INFO, "For application {0}/module {1} converting property {2} to {3}", new Object[]{app.getName(), mod.getName(), V3_0_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME, GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME});
                    Module mod_w = t.enroll(mod);
                    this.addProperty(GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME, oldSetting.getValue(), mod_w);
                    mod_w.getProperty().remove(oldSetting);
                }
            }
            t.commit();
        }
        catch (Exception ex) {
            t.rollback();
            throw new RuntimeException("Error upgrading application", ex);
        }
    }

    private void upgradeV2ApplicationElements() {
        Applications apps = this.domain.getApplications();
        SystemApplications sApps = this.domain.getSystemApplications();
        if (sApps != null && sApps.getModules().size() > 0) {
            return;
        }
        Transaction t = new Transaction();
        try {
            Property prop2;
            Property prop;
            Property prop3;
            Application app;
            Applications apps_w = t.enroll(apps);
            for (ConnectorModule connectorModule : apps.getModules(ConnectorModule.class)) {
                app = apps_w.createChild(Application.class);
                app.setName(connectorModule.getName());
                app.setLocation(this.getLocationAsURIString(connectorModule.getLocation()));
                app.setObjectType(connectorModule.getObjectType());
                app.setDescription(connectorModule.getDescription());
                app.setEnabled(connectorModule.getEnabled());
                app.setDirectoryDeployed(connectorModule.getDirectoryDeployed());
                for (Property property : connectorModule.getProperty()) {
                    prop3 = app.createChild(Property.class);
                    prop3.setName(property.getName());
                    prop3.setValue(property.getValue());
                    app.getProperty().add(prop3);
                }
                prop = app.createChild(Property.class);
                prop.setName(MODULE_TYPE);
                prop.setValue("connector-module");
                app.getProperty().add(prop);
                apps_w.getModules().remove(connectorModule);
                apps_w.getModules().add(app);
            }
            for (EjbModule ejbModule : apps.getModules(EjbModule.class)) {
                app = apps_w.createChild(Application.class);
                app.setName(ejbModule.getName());
                app.setLocation(this.getLocationAsURIString(ejbModule.getLocation()));
                app.setObjectType(ejbModule.getObjectType());
                app.setDescription(ejbModule.getDescription());
                app.setEnabled(ejbModule.getEnabled());
                app.setDirectoryDeployed(ejbModule.getDirectoryDeployed());
                app.setLibraries(ejbModule.getLibraries());
                app.setAvailabilityEnabled(ejbModule.getAvailabilityEnabled());
                for (Property property : ejbModule.getProperty()) {
                    prop3 = app.createChild(Property.class);
                    prop3.setName(property.getName());
                    prop3.setValue(property.getValue());
                    app.getProperty().add(prop3);
                }
                prop = app.createChild(Property.class);
                prop.setName(MODULE_TYPE);
                prop.setValue("ejb-module");
                app.getProperty().add(prop);
                apps_w.getModules().remove(ejbModule);
                apps_w.getModules().add(app);
            }
            for (WebModule webModule : apps.getModules(WebModule.class)) {
                app = apps_w.createChild(Application.class);
                app.setName(webModule.getName());
                app.setLocation(this.getLocationAsURIString(webModule.getLocation()));
                app.setObjectType(webModule.getObjectType());
                app.setDescription(webModule.getDescription());
                app.setEnabled(webModule.getEnabled());
                app.setDirectoryDeployed(webModule.getDirectoryDeployed());
                app.setLibraries(webModule.getLibraries());
                app.setContextRoot(webModule.getContextRoot());
                app.setAvailabilityEnabled(webModule.getAvailabilityEnabled());
                for (Property property : webModule.getProperty()) {
                    prop3 = app.createChild(Property.class);
                    prop3.setName(property.getName());
                    prop3.setValue(property.getValue());
                    app.getProperty().add(prop3);
                }
                prop = app.createChild(Property.class);
                prop.setName(MODULE_TYPE);
                prop.setValue("web-module");
                app.getProperty().add(prop);
                apps_w.getModules().remove(webModule);
                apps_w.getModules().add(app);
            }
            for (AppclientModule appclientModule : apps.getModules(AppclientModule.class)) {
                app = apps_w.createChild(Application.class);
                app.setName(appclientModule.getName());
                app.setLocation(this.getLocationAsURIString(appclientModule.getLocation()));
                app.setObjectType("user");
                app.setDescription(appclientModule.getDescription());
                app.setEnabled("true");
                app.setDirectoryDeployed(appclientModule.getDirectoryDeployed());
                for (Property property : appclientModule.getProperty()) {
                    prop3 = app.createChild(Property.class);
                    prop3.setName(property.getName());
                    prop3.setValue(property.getValue());
                    app.getProperty().add(prop3);
                }
                prop = app.createChild(Property.class);
                prop.setName(GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME);
                prop.setValue(appclientModule.getJavaWebStartEnabled());
                app.getProperty().add(prop);
                prop2 = app.createChild(Property.class);
                prop2.setName(MODULE_TYPE);
                prop2.setValue("appclient-module");
                app.getProperty().add(prop2);
                apps_w.getModules().remove(appclientModule);
                apps_w.getModules().add(app);
            }
            for (J2eeApplication j2eeApp : apps.getModules(J2eeApplication.class)) {
                app = apps_w.createChild(Application.class);
                app.setName(j2eeApp.getName());
                app.setLocation(this.getLocationAsURIString(j2eeApp.getLocation()));
                app.setObjectType(j2eeApp.getObjectType());
                app.setDescription(j2eeApp.getDescription());
                app.setEnabled(j2eeApp.getEnabled());
                app.setDirectoryDeployed(j2eeApp.getDirectoryDeployed());
                app.setLibraries(j2eeApp.getLibraries());
                app.setAvailabilityEnabled(j2eeApp.getAvailabilityEnabled());
                for (Property property : j2eeApp.getProperty()) {
                    prop3 = app.createChild(Property.class);
                    prop3.setName(property.getName());
                    prop3.setValue(property.getValue());
                    app.getProperty().add(prop3);
                }
                prop = app.createChild(Property.class);
                prop.setName(GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME);
                prop.setValue(j2eeApp.getJavaWebStartEnabled());
                app.getProperty().add(prop);
                prop2 = app.createChild(Property.class);
                prop2.setName(MODULE_TYPE);
                prop2.setValue("j2ee-application");
                app.getProperty().add(prop2);
                apps_w.getModules().remove(j2eeApp);
                apps_w.getModules().add(app);
            }
            if (apps.getModules(ExtensionModule.class).size() > 0) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Ignoring extension-module elements. GlassFish v3 does not support extension modules from GlassFish v2.");
            }
            for (ExtensionModule extensionModule : apps.getModules(ExtensionModule.class)) {
                apps_w.getModules().remove(extensionModule);
            }
            for (LifecycleModule lifecycleModule : apps.getModules(LifecycleModule.class)) {
                app = apps_w.createChild(Application.class);
                app.setName(lifecycleModule.getName());
                app.setObjectType(lifecycleModule.getObjectType());
                app.setDescription(lifecycleModule.getDescription());
                app.setEnabled(lifecycleModule.getEnabled());
                for (Property property : lifecycleModule.getProperty()) {
                    prop3 = app.createChild(Property.class);
                    prop3.setName(property.getName());
                    prop3.setValue(property.getValue());
                    app.getProperty().add(prop3);
                }
                prop = app.createChild(Property.class);
                prop.setName("class-name");
                prop.setValue(lifecycleModule.getClassName());
                app.getProperty().add(prop);
                if (lifecycleModule.getClasspath() != null) {
                    Property prop1 = app.createChild(Property.class);
                    prop1.setName("classpath");
                    prop1.setValue(lifecycleModule.getClasspath());
                    app.getProperty().add(prop1);
                }
                if (lifecycleModule.getLoadOrder() != null) {
                    prop2 = app.createChild(Property.class);
                    prop2.setName("load-order");
                    prop2.setValue(lifecycleModule.getLoadOrder());
                    app.getProperty().add(prop2);
                }
                Property prop32 = app.createChild(Property.class);
                prop32.setName("is-failure-fatal");
                prop32.setValue(lifecycleModule.getIsFailureFatal());
                app.getProperty().add(prop32);
                Property prop4 = app.createChild(Property.class);
                prop4.setName("isLifecycle");
                prop4.setValue("true");
                app.getProperty().add(prop4);
                apps_w.getModules().remove(lifecycleModule);
                apps_w.getModules().add(app);
            }
            if (apps.getModules(Mbean.class).size() > 0) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Ignoring mbean elements. GlassFish v3 does not support custom MBeans from GlassFish v2.");
            }
            for (Mbean mbean : apps.getModules(Mbean.class)) {
                apps_w.getModules().remove(mbean);
            }
            ArrayList<String> systemAppNames = new ArrayList<String>();
            for (Application application : apps_w.getModules(Application.class)) {
                if (!application.getObjectType().startsWith("system-")) continue;
                apps_w.getModules().remove(application);
                systemAppNames.add(application.getName());
            }
            List<String> allTargets = this.domain.getAllTargets();
            for (String target : allTargets) {
                Server servr = this.domain.getServerNamed(target);
                if (servr != null) {
                    Server servr_w = t.enroll(servr);
                    List<ApplicationRef> appRefs = servr.getApplicationRef();
                    for (ApplicationRef appRef : appRefs) {
                        if (!systemAppNames.contains(appRef.getRef())) continue;
                        servr_w.getApplicationRef().remove(appRef);
                    }
                    continue;
                }
                Cluster cluster = this.domain.getClusterNamed(target);
                if (cluster == null) continue;
                Cluster cluster_w = t.enroll(cluster);
                List<ApplicationRef> appRefs = cluster.getApplicationRef();
                for (ApplicationRef appRef : appRefs) {
                    if (!systemAppNames.contains(appRef.getRef())) continue;
                    cluster_w.getApplicationRef().remove(appRef);
                }
                for (Server svr : cluster.getInstances()) {
                    Server svr_w = t.enroll(svr);
                    List<ApplicationRef> appRefs2 = svr.getApplicationRef();
                    for (ApplicationRef appRef2 : appRefs2) {
                        if (!systemAppNames.contains(appRef2.getRef())) continue;
                        svr_w.getApplicationRef().remove(appRef2);
                    }
                }
            }
            Domain domain_w = t.enroll(this.domain);
            SystemApplications systemApps = domain_w.createChild(SystemApplications.class);
            domain_w.setSystemApplications(systemApps);
        }
        catch (TransactionFailure tf) {
            t.rollback();
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading application", tf);
            throw new RuntimeException(tf);
        }
        catch (Exception e) {
            t.rollback();
            throw new RuntimeException(e);
        }
        try {
            t.commit();
        }
        catch (RetryableException e) {
            t.rollback();
        }
        catch (TransactionFailure e) {
            t.rollback();
            throw new RuntimeException(e);
        }
    }

    private String getLocationAsURIString(String location) {
        File appFile = new File(location);
        return appFile.toURI().toString();
    }
}

