/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import java.util.Arrays;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_get-admin-object-class-names")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class GetAdminObjectClassNames
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Param
    private String rarName;
    @Param
    private String adminObjectInterface;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            String[] adminObjectClassNames = this.connectorRuntime.getAdminObjectClassNames(this.rarName, this.adminObjectInterface);
            Properties extraProperties = new Properties();
            if (adminObjectClassNames != null) {
                extraProperties.put("adminObjectClassNames", Arrays.asList(adminObjectClassNames));
            }
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-admin-object-class-names failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

