/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_instanceValidateRemoteDirDeployment")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.INSTANCE})
public class InstanceValidateRemoteDirDeploymentCommand
implements AdminCommand {
    private static final LocalStringsImpl localStrings = new LocalStringsImpl(InstanceValidateRemoteDirDeploymentCommand.class);
    @Param(primary=true)
    private File path;
    @Param
    private String checksum;

    public void execute(AdminCommandContext context) {
        context.getLogger().log(Level.FINE, "Running _instanceValidateRemoteDirDeployment with directory {0} and expected checksum {1}", new Object[]{this.path.getAbsolutePath(), this.checksum});
        ActionReport report = context.getActionReport();
        try {
            long myChecksum = DeploymentUtils.checksum(this.path);
            long dasChecksum = Long.parseLong(this.checksum);
            if (dasChecksum == myChecksum) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.getTopMessagePart().setMessage(localStrings.get("deploy.remoteDirDeployChecksumMismatch", this.path.getAbsolutePath()));
            }
        }
        catch (IllegalArgumentException ex) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.getTopMessagePart().setMessage(ex.getMessage());
        }
    }
}

