/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="undeploy")
@I18n(value="undeploy.command")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class UndeployCommand
extends UndeployCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UndeployCommand.class);
    @Inject
    Deployment deployment;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Applications apps;
    @Inject
    VersioningService versioningService;
    @Inject
    ServerEnvironment env;
    @Inject
    Domain domain;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Habitat habitat;
    @Inject
    Events events;

    public UndeployCommand() {
        this.origin = OpsParams.Origin.undeploy;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        this.name = new File(this.name).getName();
        List<String> matchedVersions = null;
        try {
            matchedVersions = this.versioningService.getMatchedVersions(this.name, this.target);
        }
        catch (VersioningException e) {
            if (this.env.isDas()) {
                report.failure(logger, e.getMessage());
            } else {
                logger.fine(e.getMessage());
            }
            return;
        }
        if (matchedVersions.isEmpty()) {
            if (this.env.isDas()) {
                report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", this.name, this.target));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                logger.fine(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", this.name, this.target));
            }
            return;
        }
        for (String appName : matchedVersions) {
            ApplicationRef ref;
            ApplicationInfo info = this.deployment.get(appName);
            Application application = this.apps.getModule(Application.class, appName);
            if (application == null) {
                report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", appName));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            this.deployment.validateUndeploymentTarget(this.target, appName);
            if (!DeploymentUtils.isDomainTarget(this.target) && (ref = this.domain.getApplicationRefInTarget(appName, this.target)) == null) {
                report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", appName, this.target));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ReadableArchive source = null;
            if (info == null) {
                if (application != null) {
                    URI uri = null;
                    try {
                        uri = new URI(application.getLocation());
                    }
                    catch (URISyntaxException e) {
                        logger.severe("Cannot determine original location for application : " + e.getMessage());
                    }
                    if (uri != null) {
                        File location = new File(uri);
                        if (location.exists()) {
                            try {
                                source = this.archiveFactory.openArchive(location);
                            }
                            catch (IOException e) {
                                logger.log(Level.INFO, e.getMessage(), e);
                            }
                        } else {
                            logger.warning("Originally deployed application at " + location + " not found");
                        }
                    }
                }
            } else {
                source = info.getSource();
            }
            if (source == null) {
                logger.fine("Cannot get source archive for undeployment");
                try {
                    this.deployment.unregisterAppFromDomainXML(appName, this.target);
                }
                catch (TransactionFailure e) {
                    logger.warning("Module " + appName + " not found in configuration");
                }
                return;
            }
            File sourceFile = new File(source.getURI());
            if (!source.exists()) {
                logger.log(Level.WARNING, "Cannot find application bits at " + sourceFile.getPath());
                try {
                    this.deployment.unregisterAppFromDomainXML(appName, this.target);
                }
                catch (TransactionFailure e) {
                    logger.warning("Module " + appName + " not found in configuration");
                }
                return;
            }
            this.name = appName;
            ExtendedDeploymentContext deploymentContext = null;
            try {
                deploymentContext = this.deployment.getBuilder(logger, this, report).source(source).build();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cannot create context for undeployment ", e);
                report.setMessage(localStrings.getLocalString("undeploy.contextcreation.failed", "Cannot create context for undeployment : {0} ", e.getMessage()));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Properties appProps = deploymentContext.getAppProps();
            appProps.putAll((Map<?, ?>)application.getDeployProperties());
            if (this.properties != null) {
                appProps.putAll((Map<?, ?>)this.properties);
            }
            deploymentContext.setModulePropsMap(application.getModulePropertiesMap());
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_VALIDATION, deploymentContext), false);
            if (report.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
                return;
            }
            if (this.env.isDas() && !DeploymentUtils.isDASTarget(this.target)) {
                CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("disable", report);
                try {
                    ParameterMapExtractor extractor = new ParameterMapExtractor(this);
                    ParameterMap parameters = extractor.extract(Collections.EMPTY_LIST);
                    parameters.set("DEFAULT", appName);
                    parameters.add("isundeploy", Boolean.TRUE.toString());
                    inv.parameters(parameters).execute();
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        report.setMessage(localStrings.getLocalString("disable.command.failed", "{0} disabled failed", appName));
                        return;
                    }
                    if (DeploymentUtils.isDomainTarget(this.target)) {
                        List<String> targets = this.domain.getAllReferencedTargetsForApplication(appName);
                        parameters.remove("isUndeploy");
                        ClusterOperationUtil.replicateCommand("undeploy", FailurePolicy.Error, FailurePolicy.Warn, targets, context, parameters, this.habitat);
                    }
                }
                catch (Exception e) {
                    report.failure(logger, e.getMessage());
                    return;
                }
            }
            Artifacts generatedArtifacts = DeploymentUtils.generatedArtifacts(application);
            generatedArtifacts.record(deploymentContext);
            if (info != null) {
                this.deployment.undeploy(appName, deploymentContext);
            }
            boolean isDirectoryDeployed = false;
            if (application != null) {
                isDirectoryDeployed = Boolean.valueOf(application.getDirectoryDeployed());
            }
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) continue;
            try {
                this.deployment.unregisterAppFromDomainXML(appName, this.target);
            }
            catch (TransactionFailure e) {
                logger.warning("Module " + appName + " not found in configuration");
            }
            deploymentContext.clean();
            if (source == null || this.keepreposdir.booleanValue() || isDirectoryDeployed || !source.exists()) continue;
            FileUtils.whack(new File(source.getURI()));
        }
    }
}

