/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import org.glassfish.deployment.common.ModuleExploder;
import org.glassfish.internal.embedded.ScatteredArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentElement {
    private static final Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, "javax.enterprise.system.container.ejb");
    private File element;
    private boolean isEJBModule;
    private boolean isWebApp = false;

    DeploymentElement(File element, boolean isEJBModule) {
        this.element = element;
        this.isEJBModule = isEJBModule;
        if (element.isFile()) {
            this.isWebApp = element.getName().endsWith(".war");
        } else {
            List<String> files = Arrays.asList(element.list());
            this.isWebApp = files.contains("WEB-INF");
        }
    }

    File getElement() {
        return this.element;
    }

    boolean isEJBModule() {
        return this.isEJBModule;
    }

    boolean isWebApp() {
        return this.isWebApp;
    }

    public static boolean hasEJBModule(Set<DeploymentElement> modules) {
        for (DeploymentElement module : modules) {
            if (!module.isEJBModule()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWar(Set<DeploymentElement> modules) {
        for (DeploymentElement module : modules) {
            if (!module.isWebApp()) continue;
            return true;
        }
        return false;
    }

    public static DeploymentElement getWar(Set<DeploymentElement> modules) {
        for (DeploymentElement module : modules) {
            if (!module.isWebApp()) continue;
            return module;
        }
        return null;
    }

    public static boolean hasLibrary(Set<DeploymentElement> modules) {
        for (DeploymentElement module : modules) {
            if (module.isEJBModule()) continue;
            return true;
        }
        return false;
    }

    public static int countEJBModules(Set<DeploymentElement> modules) {
        int result = 0;
        for (DeploymentElement module : modules) {
            if (!module.isEJBModule()) continue;
            ++result;
        }
        return result;
    }

    public static ResultApplication getOrCreateApplication(Set<DeploymentElement> modules, String appName) throws EJBException, IOException {
        Object result = null;
        boolean deleteOnExit = false;
        if (modules == null || modules.size() == 0 || !DeploymentElement.hasEJBModule(modules)) {
            _logger.severe("[DeploymentElement] No modules found");
        } else if (appName == null && DeploymentElement.countEJBModules(modules) == 1) {
            if (modules.size() == 1) {
                result = modules.iterator().next().getElement();
            } else if (DeploymentElement.countEJBModules(modules) == 1 && DeploymentElement.hasWar(modules)) {
                result = DeploymentElement.getWar(modules).getElement();
            } else {
                String aName = null;
                ArrayList<URL> archives = new ArrayList<URL>();
                for (DeploymentElement m : modules) {
                    boolean isEJBModule = m.isEJBModule();
                    File f = m.getElement();
                    String name = f.getName();
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.info("[DeploymentElement] adding " + (isEJBModule ? "EJB module" : "library") + " to ScatteredArchive " + name);
                    }
                    if (isEJBModule) {
                        aName = name;
                        archives.add(0, f.toURI().toURL());
                        continue;
                    }
                    archives.add(f.toURI().toURL());
                }
                ScatteredArchive.Builder saBuilder = new ScatteredArchive.Builder(aName, Collections.unmodifiableCollection(archives));
                result = saBuilder.buildJar();
            }
        } else {
            File resultFile = File.createTempFile("ejb-app", "");
            File lib = null;
            if (resultFile.delete() && resultFile.mkdirs()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("[DeploymentElement] temp dir created at " + resultFile.getAbsolutePath());
                }
                if (DeploymentElement.hasLibrary(modules)) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("[DeploymentElement] lib dir added ... ");
                    }
                    lib = new File(resultFile, "lib");
                }
            } else {
                throw new EJBException("Not able to create temp dir " + resultFile.getAbsolutePath());
            }
            if (System.getProperty("org.glassfish.ejb.embedded.keep-temporary-files") == null) {
                deleteOnExit = true;
            }
            int duplicate_dir_counter = 0;
            for (DeploymentElement m : modules) {
                File out;
                File base;
                int lastpart;
                String filename;
                File f = m.getElement();
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.info("[DeploymentElement] adding " + f.getName() + " to exploded ear " + " isEJBModule? " + m.isEJBModule() + " isWebApp? " + m.isWebApp());
                }
                if ((filename = f.toURI().getSchemeSpecificPart()).endsWith(File.separator) || filename.endsWith("/")) {
                    int length = filename.length();
                    filename = filename.substring(0, length - 1);
                }
                if ((lastpart = filename.lastIndexOf(File.separatorChar)) == -1) {
                    lastpart = filename.lastIndexOf(47);
                }
                String name = filename.substring(lastpart + 1);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("[DeploymentElement] Converted file name: " + filename + " to " + name);
                }
                File file = base = m.isEJBModule() ? resultFile : lib;
                if (!f.isDirectory() && m.isEJBModule()) {
                    out = new File(base, FileUtils.makeFriendlyFilename(name));
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("[DeploymentElement] Exploding jar to: " + out);
                    }
                    ModuleExploder.explodeJar(f, out);
                } else {
                    if (f.isDirectory()) {
                        name = name + (m.isWebApp() ? "_war" : (m.isEJBModule() ? "_jar" : ".jar"));
                    }
                    if ((out = new File(base, name)).exists()) {
                        out = new File(base, "d__" + ++duplicate_dir_counter + "__" + name);
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("[DeploymentElement] Copying element to: " + out);
                    }
                    FileUtils.copy(f, out);
                }
                result = resultFile;
            }
        }
        return new ResultApplication(result, deleteOnExit);
    }

    protected static class ResultApplication {
        private boolean deleteOnExit = false;
        private Object app = null;

        ResultApplication(Object app) {
            this.app = app;
        }

        ResultApplication(Object app, boolean deleteOnExit) {
            this.app = app;
            this.deleteOnExit = deleteOnExit;
        }

        Object getApplication() {
            return this.app;
        }

        boolean deleteOnExit() {
            return this.deleteOnExit;
        }
    }
}

