/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.containers.AbstractSingletonContainer;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.startup.EjbApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonLifeCycleManager {
    private Set<String> names = new HashSet<String>();
    private Map<String, Set<String>> initialDependency = new HashMap<String, Set<String>>();
    private Map<String, Integer> name2Index = new HashMap<String, Integer>();
    private Map<Integer, String> index2Name = new HashMap<Integer, String>();
    private Set<String> leafNodes = new HashSet<String>();
    private int maxIndex = 0;
    private boolean[][] adj;
    private List<AbstractSingletonContainer> initializedSingletons = new ArrayList<AbstractSingletonContainer>();
    private Map<String, AbstractSingletonContainer> name2Container = new HashMap<String, AbstractSingletonContainer>();
    private boolean initializeInOrder;
    private Map<String, EjbApplication> name2EjbApp = new HashMap<String, EjbApplication>();
    private static final Logger _logger = LogDomains.getLogger(SingletonLifeCycleManager.class, "javax.enterprise.system.container.ejb");

    SingletonLifeCycleManager(boolean initializeInOrder) {
        this.initializeInOrder = initializeInOrder;
    }

    void addSingletonContainer(EjbApplication ejbApp, AbstractSingletonContainer c) {
        c.setSingletonLifeCycleManager(this);
        EjbSessionDescriptor sdesc = (EjbSessionDescriptor)c.getEjbDescriptor();
        String modName = sdesc.getEjbBundleDescriptor().getName();
        String src = this.normalizeSingletonName(sdesc.getName(), sdesc);
        String[] depends = sdesc.getDependsOn();
        String[] newDepends = new String[depends.length];
        StringBuilder sb = new StringBuilder("Partial order of dependent(s). " + src + " => {");
        for (int i = 0; i < depends.length; ++i) {
            newDepends[i] = this.normalizeSingletonName(depends[i], sdesc);
            sb.append(newDepends[i] + " ");
        }
        sb.append("}");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, sb.toString());
        }
        this.addDependency(src, newDepends);
        this.name2Container.put(src, c);
        this.name2EjbApp.put(src, ejbApp);
    }

    private String normalizeSingletonName(String origName, EjbSessionDescriptor sessionDesc) {
        String normalizedName = origName;
        boolean fullyQualified = origName.contains("#");
        Application app = sessionDesc.getEjbBundleDescriptor().getApplication();
        if (fullyQualified) {
            int indexOfHash = origName.indexOf("#");
            String ejbName = origName.substring(indexOfHash + 1);
            String relativeJarPath = origName.substring(0, indexOfHash);
            BundleDescriptor bundle = app.getRelativeBundle(sessionDesc.getEjbBundleDescriptor(), relativeJarPath);
            if (bundle == null) {
                throw new IllegalStateException("Invalid @DependOn value = " + origName + " for Singleton " + sessionDesc.getName());
            }
            normalizedName = bundle.getModuleDescriptor().getArchiveUri() + "#" + ejbName;
        } else {
            normalizedName = sessionDesc.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri() + "#" + origName;
        }
        return normalizedName;
    }

    void doStartup(EjbApplication ejbApp) {
        Set<EjbDescriptor> ejbs = ejbApp.getEjbBundleDescriptor().getEjbs();
        int descSz = ejbs.size();
        for (EjbDescriptor desc : ejbs) {
            EjbSessionDescriptor sdesc;
            if (!(desc instanceof EjbSessionDescriptor) || !(sdesc = (EjbSessionDescriptor)desc).isSingleton() || !sdesc.getInitOnStartup()) continue;
            String normalizedSingletonName = this.normalizeSingletonName(sdesc.getName(), sdesc);
            this.initializeSingleton(this.name2Container.get(normalizedSingletonName));
        }
    }

    void doShutdown() {
        Collections.reverse(this.initializedSingletons);
        for (AbstractSingletonContainer singletonContainer : this.initializedSingletons) {
            singletonContainer.onShutdown();
        }
    }

    public synchronized void initializeSingleton(AbstractSingletonContainer c) {
        this.initializeSingleton(c, new ArrayList<String>());
    }

    private void initializeSingleton(AbstractSingletonContainer c, List<String> initList) {
        if (!this.initializedSingletons.contains(c)) {
            String normalizedSingletonName = this.normalizeSingletonName(c.getEjbDescriptor().getName(), (EjbSessionDescriptor)c.getEjbDescriptor());
            List<String> computedDeps = this.computeDependencies(normalizedSingletonName);
            int sz = computedDeps.size();
            AbstractSingletonContainer[] deps = new AbstractSingletonContainer[sz];
            initList.add(normalizedSingletonName);
            for (int i = 0; i < sz; ++i) {
                EjbApplication ejbApp;
                String nextSingletonName = computedDeps.get(i);
                deps[i] = this.name2Container.get(nextSingletonName);
                if (this.initializeInOrder && !(ejbApp = this.name2EjbApp.get(nextSingletonName)).isStarted()) {
                    String msg = "application.xml specifies module initialization ordering but " + initList.get(0) + " depends on " + nextSingletonName + " which is in a module that hasn't been started yet";
                    if (_logger.isLoggable(Level.WARNING)) {
                        StringBuilder sb = new StringBuilder(initList.get(0));
                        for (int k = 1; k < initList.size(); ++k) {
                            sb.append(" -> ").append(initList.get(k));
                        }
                        sb.append(" -> ").append(nextSingletonName);
                        _logger.log(Level.WARNING, "Partial order of singleton beans involved in this: " + sb.toString());
                    }
                    throw new RuntimeException(msg);
                }
                this.initializeSingleton(deps[i], initList);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SingletonLifeCycleManager: initializingSingleton: " + normalizedSingletonName);
            }
            c.instantiateSingletonInstance();
            this.initializedSingletons.add(c);
        }
    }

    private void addDependency(String src, String[] depends) {
        if (depends != null && depends.length > 0) {
            for (String s : depends) {
                this.addDependency(src, s);
            }
        } else {
            this.addDependency(src, "");
        }
    }

    private void addDependency(String src, List<String> depends) {
        if (depends != null) {
            for (String s : depends) {
                this.addDependency(src, s);
            }
        } else {
            this.addDependency(src, "");
        }
    }

    private void addDependency(String src, String depends) {
        src = src.trim();
        Set<String> deps = this.getExistingDependecyList(src);
        StringTokenizer tok = new StringTokenizer(depends, " ,");
        while (tok.hasMoreTokens()) {
            String dep = tok.nextToken();
            deps.add(dep);
            this.getExistingDependecyList(dep);
        }
    }

    private String[] getPartialOrdering() {
        if (this.adj == null) {
            this.fillAdjacencyMatrix();
        }
        boolean[][] tempAdj = new boolean[this.maxIndex][this.maxIndex];
        for (int i = 0; i < this.maxIndex; ++i) {
            for (int j = 0; j < this.maxIndex; ++j) {
                tempAdj[i][j] = this.adj[i][j];
            }
        }
        ArrayList<String> dependencies = new ArrayList<String>();
        do {
            String src = null;
            boolean foundAtLeastOneLeaf = false;
            for (int i = 0; i < this.maxIndex; ++i) {
                src = this.index2Name.get(i);
                if (dependencies.contains(src)) continue;
                boolean hasDep = false;
                for (int j = 0; j < this.maxIndex; ++j) {
                    if (!tempAdj[i][j]) continue;
                    hasDep = true;
                    break;
                }
                if (hasDep || dependencies.contains(src)) continue;
                dependencies.add(src);
                for (int k = 0; k < this.maxIndex; ++k) {
                    tempAdj[k][i] = false;
                }
                foundAtLeastOneLeaf = true;
            }
            if (foundAtLeastOneLeaf || dependencies.size() >= this.name2Index.size()) continue;
            throw new IllegalArgumentException("Circular dependency: " + this.getCyclicString(tempAdj));
        } while (dependencies.size() < this.name2Index.size());
        return dependencies.toArray(new String[0]);
    }

    private AbstractSingletonContainer[] getPartiallyOrderedSingletonContainer() {
        String[] computedDeps = this.getPartialOrdering();
        int sz = computedDeps.length;
        AbstractSingletonContainer[] deps = new AbstractSingletonContainer[sz];
        for (int i = 0; i < sz; ++i) {
            deps[i] = this.name2Container.get(computedDeps[i]);
        }
        return deps;
    }

    private List<String> computeDependencies(String root) {
        if (this.adj == null) {
            this.fillAdjacencyMatrix();
        }
        Stack<String> stk = new Stack<String>();
        stk.push(root);
        ArrayList<String> dependencies = new ArrayList<String>();
        do {
            String top = (String)stk.peek();
            int topIndex = this.name2Index.get(top);
            boolean hasDep = false;
            for (int j = 0; j < this.maxIndex; ++j) {
                if (!this.adj[topIndex][j]) continue;
                String name = this.index2Name.get(j);
                if (stk.contains(name)) {
                    String str = "Cyclic dependency: " + top + " => " + name + "? ";
                    throw new IllegalArgumentException(str + this.getCyclicString(this.adj));
                }
                if (dependencies.contains(name)) continue;
                if (this.leafNodes.contains(name)) {
                    dependencies.add(name);
                    continue;
                }
                hasDep = true;
                stk.push(name);
            }
            if (hasDep) continue;
            stk.pop();
            if (dependencies.contains(top)) continue;
            dependencies.add(top);
        } while (!stk.empty());
        dependencies.remove(dependencies.size() - 1);
        return dependencies;
    }

    private Set<String> getExistingDependecyList(String src) {
        Set<String> existingDeps = this.initialDependency.get(src);
        if (existingDeps == null) {
            existingDeps = new HashSet<String>();
            this.initialDependency.put(src, existingDeps);
            this.name2Index.put(src, this.maxIndex);
            this.index2Name.put(this.maxIndex, src);
            ++this.maxIndex;
        }
        return existingDeps;
    }

    private void fillAdjacencyMatrix() {
        this.adj = new boolean[this.maxIndex][this.maxIndex];
        for (int i = 0; i < this.maxIndex; ++i) {
            String src = this.index2Name.get(i);
            for (int j = 0; j < this.maxIndex; ++j) {
                this.adj[i][j] = false;
            }
            boolean isLeaf = true;
            Set<String> deps = this.initialDependency.get(src);
            for (String d : deps) {
                int k = this.name2Index.get(d);
                this.adj[i][k] = true;
                isLeaf = false;
            }
            if (!isLeaf) continue;
            this.leafNodes.add(src);
        }
    }

    private String getCyclicString(boolean[][] a) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.maxIndex; ++i) {
            StringBuilder sb2 = new StringBuilder("");
            String delim = "";
            for (int j = 0; j < this.maxIndex; ++j) {
                if (!a[i][j]) continue;
                sb2.append(delim).append(this.index2Name.get(j));
                delim = ", ";
            }
            String dep = sb2.toString();
            if (dep.length() <= 0) continue;
            sb.append(" ").append(this.index2Name.get(i)).append(" => ").append(sb2.toString()).append("; ");
        }
        return sb.toString();
    }

    private void printAdjacencyMatrix() {
        int i;
        if (this.adj == null) {
            this.fillAdjacencyMatrix();
        }
        System.out.print(" ");
        for (i = 0; i < this.maxIndex; ++i) {
            System.out.print(" " + this.index2Name.get(i));
        }
        System.out.println();
        for (i = 0; i < this.maxIndex; ++i) {
            System.out.print(this.index2Name.get(i) + " ");
            for (int j = 0; j < this.maxIndex; ++j) {
                System.out.print(this.adj[i][j] ? "1 " : "0 ");
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
    }

    private static void test1() {
        SingletonLifeCycleManager ts = new SingletonLifeCycleManager(false);
        ts.addDependency("A", "B, C");
        ts.addDependency("B", "C, D");
        ts.addDependency("D", "E");
        ts.addDependency("C", "D, E, G");
        ts.addDependency("E", "D");
        ts.getPartialOrdering();
        SingletonLifeCycleManager t = new SingletonLifeCycleManager(false);
        t.addDependency("C", ts.computeDependencies("C"));
        t.addDependency("D", ts.computeDependencies("D"));
        t.printAdjacencyMatrix();
        for (String s : t.computeDependencies("C")) {
            System.out.print(s + " ");
        }
        System.out.println();
        for (String s : t.getPartialOrdering()) {
            System.out.print(s + " ");
        }
    }

    private static void test2() {
        SingletonLifeCycleManager ts = new SingletonLifeCycleManager(false);
        ts.addDependency("A", "D, E");
        ts.addDependency("B", "F");
        ts.addDependency("C", "G, H");
        ts.addDependency("D", "I");
        ts.addDependency("E", "J");
        ts.addDependency("F", "J, K");
        ts.addDependency("H", "L");
        ts.addDependency("I", "M, N");
        ts.addDependency("J", "U");
        ts.addDependency("K", "U");
        ts.addDependency("L", "O");
        ts.addDependency("U", "N, O");
        ts.addDependency("N", "P, Q");
        ts.addDependency("O", "Q, R");
        ts.addDependency("Q", "S, T");
        ts.addDependency("E", "X, W");
        ts.addDependency("X", "Y");
        ts.addDependency("W", "Y");
        ts.addDependency("Y", "Z");
        ts.addDependency("Z", "O");
        String[] dep = ts.getPartialOrdering();
        for (String s : ts.getPartialOrdering()) {
            System.out.print(s + " ");
        }
        System.out.println();
        SingletonLifeCycleManager ts2 = new SingletonLifeCycleManager(false);
        ts2.addDependency("E", ts.computeDependencies("E"));
        ts2.addDependency("U", ts.computeDependencies("U"));
        ts2.addDependency("H", ts.computeDependencies("H"));
        String[] dep2 = ts2.getPartialOrdering();
        for (String s : ts2.getPartialOrdering()) {
            System.out.print(s + " ");
        }
    }

    private static void test3() {
        SingletonLifeCycleManager ts = new SingletonLifeCycleManager(false);
        ts.addDependency("A", (String)null);
        ts.addDependency("B", (String)null);
        ts.addDependency("C", (String)null);
        String[] dep = ts.getPartialOrdering();
        for (String s : ts.getPartialOrdering()) {
            System.out.print(s + " ");
        }
        System.out.println();
        for (String s : ts.computeDependencies("B")) {
            System.out.print(s + " ");
        }
        System.out.println();
    }

    private static void test4() {
        SingletonLifeCycleManager ts = new SingletonLifeCycleManager(false);
        ts.addDependency("A", "D, B, C");
        ts.addDependency("B", "F, I");
        ts.addDependency("C", "F, H, G");
        ts.addDependency("D", "E");
        ts.addDependency("E", (String)null);
        ts.addDependency("F", "E");
        ts.addDependency("G", "E, I, K");
        ts.addDependency("H", "J");
        ts.addDependency("I", "J");
        ts.addDependency("K", (List<String>)null);
        String[] dep = ts.getPartialOrdering();
        for (String s : ts.getPartialOrdering()) {
            System.out.print(s + " ");
        }
        System.out.println();
        for (String s : ts.computeDependencies("C")) {
            System.out.print(s + " ");
        }
        System.out.println();
    }
}

