/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.util;

import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.WorkQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.util.ORBCommonStatsImpl;
import org.glassfish.enterprise.iiop.util.ThreadPoolStats;
import org.glassfish.external.statistics.BoundedRangeStatistic;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.BoundedRangeStatisticImpl;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="The implementation for the ThreadPoolStats")
public class ThreadPoolStatsImpl
extends ORBCommonStatsImpl
implements ThreadPoolStats {
    private ThreadPool threadPool;
    private WorkQueue workQueue;
    private String threadPoolName;
    private String workQueueName;
    private CountStatisticImpl numberOfBusyThreads;
    private CountStatisticImpl numberOfAvailableThreads;
    private BoundedRangeStatisticImpl currentNumberOfThreads;
    private BoundedRangeStatisticImpl averageWorkCompletionTime;
    private CountStatisticImpl totalWorkItemsAdded;
    private BoundedRangeStatisticImpl numberOfWorkItemsInQueue;
    private BoundedRangeStatisticImpl averageTimeInQueue;
    private static final String stringNumberOfBusyThreads = "numberOfBusyThreads";
    private static final String stringNumberOfAvailableThreads = "numberOfAvailableThreads";
    private static final String stringCurrentNumberOfThreads = "currentNumberOfThreads";
    private static final String stringAverageWorkCompletionTime = "averageWorkCompletionTime";
    private static final String stringTotalWorkItemsAdded = "totalWorkItemsAdded";
    private static final String stringNumberOfWorkItemsInQueue = "workItemsInQueue";
    private static final String stringAverageTimeInQueue = "averageTimeInQueue";

    public ThreadPoolStatsImpl(ThreadPool threadPool) throws NoSuchWorkQueueException {
        this.threadPool = threadPool;
        this.threadPoolName = threadPool.getName();
        this.getWorkQueueForThreadPool();
        this.initializeStats();
    }

    private void getWorkQueueForThreadPool() {
        try {
            this.workQueue = this.threadPool.getWorkQueue(0);
            this.workQueueName = this.workQueue.getName();
        }
        catch (NoSuchWorkQueueException ex) {
            Logger.getLogger(this.workQueueName).log(Level.SEVERE, this.workQueueName);
            throw new RuntimeException(ex);
        }
    }

    private void initializeStats() throws NoSuchWorkQueueException {
        super.initialize("org.glassfish.enterprise.iiop.util.ThreadPoolStats");
        long time = System.currentTimeMillis();
        this.numberOfBusyThreads = new CountStatisticImpl(this.threadPool.numberOfBusyThreads(), stringNumberOfBusyThreads, "COUNT", this.threadPool.getWorkQueue(0).toString(), time, time);
        this.numberOfAvailableThreads = new CountStatisticImpl(this.threadPool.numberOfAvailableThreads(), stringNumberOfAvailableThreads, "count", this.threadPool.getWorkQueue(0).toString(), time, time);
        this.currentNumberOfThreads = new BoundedRangeStatisticImpl(this.threadPool.currentNumberOfThreads(), this.threadPool.maximumNumberOfThreads(), this.threadPool.minimumNumberOfThreads(), Long.MAX_VALUE, 0L, stringCurrentNumberOfThreads, "count", this.threadPool.getWorkQueue(0).toString(), time, time);
        this.averageWorkCompletionTime = new BoundedRangeStatisticImpl(this.threadPool.averageWorkCompletionTime(), 0L, 0L, Long.MAX_VALUE, 0L, stringAverageWorkCompletionTime, "Milliseconds", this.threadPool.getWorkQueue(0).toString(), time, time);
        this.totalWorkItemsAdded = new CountStatisticImpl(this.workQueue.totalWorkItemsAdded(), stringTotalWorkItemsAdded, "count", this.workQueue.getName(), time, time);
        this.numberOfWorkItemsInQueue = new BoundedRangeStatisticImpl(this.workQueue.workItemsInQueue(), 0L, 0L, Long.MAX_VALUE, 0L, stringNumberOfWorkItemsInQueue, "count", this.workQueue.getName(), time, time);
        this.averageTimeInQueue = new BoundedRangeStatisticImpl(this.workQueue.averageTimeInQueue(), 0L, 0L, Long.MAX_VALUE, 0L, stringAverageTimeInQueue, "Milliseconds", this.workQueue.getName(), time, time);
    }

    @ManagedAttribute(id="currentbusythreads")
    @Description(value="Total number of busy threads")
    public synchronized CountStatistic getNumberOfBusyThreads() {
        int numBusyThreads = this.threadPool.numberOfBusyThreads();
        this.numberOfBusyThreads.setCount(numBusyThreads);
        return this.numberOfBusyThreads.getStatistic();
    }

    @ManagedAttribute
    @Description(value="Total number of available threads")
    public synchronized CountStatistic getNumberOfAvailableThreads() {
        long numAvailableThreads = this.threadPool.numberOfAvailableThreads();
        this.numberOfAvailableThreads.setCount(numAvailableThreads);
        return this.numberOfAvailableThreads.getStatistic();
    }

    @ManagedAttribute
    @Description(value="Total number of current threads")
    public synchronized BoundedRangeStatistic getCurrentNumberOfThreads() {
        int numCurrentThreads = this.threadPool.currentNumberOfThreads();
        this.currentNumberOfThreads.setCurrent(numCurrentThreads);
        return this.currentNumberOfThreads.getStatistic();
    }

    @ManagedAttribute
    @Description(value="Average time to complete work")
    public synchronized RangeStatistic getAverageWorkCompletionTime() {
        long avgWorkCompletionTime = this.threadPool.averageWorkCompletionTime();
        this.averageWorkCompletionTime.setCurrent(avgWorkCompletionTime);
        return this.averageWorkCompletionTime.getStatistic();
    }

    @ManagedAttribute
    @Description(value="Total number of work items added to the queue")
    public synchronized CountStatistic getTotalWorkItemsAdded() {
        long totWorkItemsAdded = this.workQueue.totalWorkItemsAdded();
        this.totalWorkItemsAdded.setCount(totWorkItemsAdded);
        return this.totalWorkItemsAdded.getStatistic();
    }

    @ManagedAttribute
    @Description(value="Total number of work items in the queue")
    public synchronized BoundedRangeStatistic getNumberOfWorkItemsInQueue() {
        int totWorkItemsInQueue = this.workQueue.workItemsInQueue();
        this.numberOfWorkItemsInQueue.setCurrent(totWorkItemsInQueue);
        return this.numberOfWorkItemsInQueue.getStatistic();
    }

    @ManagedAttribute
    @Description(value="Average time in queue")
    public synchronized RangeStatistic getAverageTimeInQueue() {
        long avgTimeInQueue = this.workQueue.averageTimeInQueue();
        this.averageTimeInQueue.setCurrent(avgTimeInQueue);
        return this.averageTimeInQueue.getStatistic();
    }
}

