/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jts.admin.cli;

import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.jts.admin.cli.RecoverTransactionsBase;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="recover-transactions")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.DAS})
@Scoped(value=PerLookup.class)
@I18n(value="recover.transactions")
public class RecoverTransactions
extends RecoverTransactionsBase
implements AdminCommand {
    @Param(name="target", alias="destination", optional=true)
    String destinationServer;
    @Inject
    CommandRunner runner;

    public void execute(AdminCommandContext context) {
        String error;
        ActionReport report = context.getActionReport();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("==> original target: " + this.destinationServer + " ... server: " + this.serverToRecover);
        }
        if ((error = this.validate(this.destinationServer, true)) != null) {
            _logger.log(Level.WARNING, localStrings.getString("recover.transactions.failed") + " " + error);
            report.setMessage(error);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.destinationServer == null) {
            this.destinationServer = this.serverToRecover;
        }
        try {
            CommandRunner.CommandInvocation inv = this.runner.getCommandInvocation("_recover-transactions-internal", report);
            ParameterMap parameters = new ParameterMap();
            parameters.add("target", this.destinationServer);
            parameters.add("DEFAULT", this.serverToRecover);
            parameters.add("transactionlogdir", this.transactionLogDir);
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("==> calling _recover-transactions-internal with params: " + parameters);
            }
            inv.parameters(parameters).execute();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("==> _recover-transactions-internal returned with: " + (Object)((Object)report.getActionExitCode()));
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, localStrings.getString("recover.transactions.failed"), e);
            report.setMessage(localStrings.getString("recover.transactions.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

