/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijpa;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.Extender;
import org.glassfish.osgijpa.JPABundleProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class JPAExtender
implements Extender,
SynchronousBundleListener {
    private Logger logger = Logger.getLogger(JPAExtender.class.getPackage().getName());
    private BundleContext context;
    private final ServiceTracker tracker;
    private Map<Long, JPABundleProcessor> bundlesToBeEnhanced = Collections.synchronizedMap(new HashMap());
    ExecutorService executorService;
    private static final String PERSISTENT_STATE = "jpa-extender-state";
    private EnhancerPolicy enhancerPolicy = EnhancerPolicy.SYNCHRONOUS;
    private static final String ENHANCER_POLICY_KEY = "org.glassfish.osgijpa.enhancerPolicy";

    public JPAExtender(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.tracker.open();
    }

    public void start() {
        String value = this.context.getProperty(ENHANCER_POLICY_KEY);
        if (value != null) {
            this.enhancerPolicy = EnhancerPolicy.valueOf(value);
        }
        this.context.addBundleListener((BundleListener)this);
        this.executorService = Executors.newSingleThreadExecutor();
        this.restoreState();
        this.logger.logp(Level.FINE, "JPAExtender", "start", " JPAExtender started", new Object[0]);
    }

    public void stop() {
        this.context.removeBundleListener((BundleListener)this);
        this.executorService.shutdownNow();
        this.saveState();
        this.logger.logp(Level.FINE, "JPAExtender", "stop", " JPAExtender stopped", new Object[0]);
    }

    public void bundleChanged(BundleEvent event) {
        final Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 1: 
            case 8: {
                final JPABundleProcessor bi = new JPABundleProcessor(bundle);
                if (bi.isEnhanced() || !bi.isJPABundle()) break;
                this.logger.logp(Level.INFO, "JPAExtender", "bundleChanged", "Bundle having id {0} is a JPA bundle", new Object[]{bundle.getBundleId()});
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (JPAExtender.this.tryResolve(bundle)) {
                            JPAExtender.this.enhance(bi, true);
                        } else {
                            JPAExtender.this.logger.log(Level.INFO, "Bundle having id {0} can't be resolved now, so adding to a list so that we can enhance it when it gets resolved in future", new Object[]{bundle.getBundleId()});
                            JPAExtender.this.bundlesToBeEnhanced.put(bi.getBundleId(), bi);
                        }
                    }
                };
                this.executeTask(runnable, this.enhancerPolicy);
                break;
            }
            case 2: {
                long id = bundle.getBundleId();
                final JPABundleProcessor bi = this.bundlesToBeEnhanced.remove(id);
                if (bi == null) break;
                Runnable runnable = new Runnable(){

                    public void run() {
                        JPAExtender.this.enhance(bi, false);
                    }
                };
                this.executeTask(runnable, EnhancerPolicy.ASYNCHRONOUS);
                break;
            }
            case 16: {
                long id = bundle.getBundleId();
                this.bundlesToBeEnhanced.remove(id);
                break;
            }
        }
    }

    private PackageAdmin getPackageAdmin() {
        return (PackageAdmin)PackageAdmin.class.cast(this.tracker.getService());
    }

    private void enhance(JPABundleProcessor bi, boolean refreshPackage) {
        try {
            Bundle bundle = bi.getBundle();
            InputStream enhancedStream = bi.enhance();
            this.updateBundle(bundle, enhancedStream);
            if (refreshPackage) {
                this.getPackageAdmin().refreshPackages(new Bundle[]{bundle});
            } else {
                this.logger.logp(Level.INFO, "JPAExtender", "enhance", "Deferring refresh to framework restart, so enhanced bytes won't come into effect until then for bundle " + bi.getBundleId() + " if there are existing wires to this bundle.");
            }
        }
        catch (Exception e) {
            this.logger.logp(Level.WARNING, "JPAExtender", "enhance", "Failed to enhance bundle having id " + bi.getBundleId(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBundle(Bundle bundle, InputStream enhancedStream) throws BundleException {
        try {
            bundle.update(enhancedStream);
        }
        finally {
            try {
                enhancedStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void executeTask(Runnable runnable, EnhancerPolicy enhancerPolicy) {
        switch (enhancerPolicy) {
            case SYNCHRONOUS: {
                runnable.run();
                break;
            }
            case ASYNCHRONOUS: {
                this.executorService.submit(runnable);
            }
        }
    }

    private boolean tryResolve(Bundle bundle) {
        return this.getPackageAdmin().resolveBundles(new Bundle[]{bundle});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreState() {
        File baseDir = this.context.getDataFile("");
        if (baseDir == null) {
            return;
        }
        File state = new File(baseDir, PERSISTENT_STATE);
        if (!state.exists()) {
            return;
        }
        ObjectInputStream stream = null;
        try {
            stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(state)));
            this.bundlesToBeEnhanced = (Map)stream.readObject();
            this.logger.logp(Level.INFO, "JPAExtender", "restoreState", "Restored state from {0} and following bundles are yet to be enhanced: {1} ", new Object[]{state.getAbsolutePath(), this.printBundleIds()});
        }
        catch (Exception e) {
            this.logger.logp(Level.WARNING, "JPAExtender", "restoreState", "Unable to read stored data. Will continue with an empty initial state. If you have bundles that were installed earlier and have not been enhanced yet, please update those bundles.", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState() {
        if (this.bundlesToBeEnhanced.isEmpty()) {
            return;
        }
        File baseDir = this.context.getDataFile("");
        if (baseDir == null) {
            return;
        }
        File state = new File(baseDir, PERSISTENT_STATE);
        if (state.exists()) {
            state.delete();
        }
        ObjectOutputStream stream = null;
        try {
            stream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(state)));
            stream.writeObject(this.bundlesToBeEnhanced);
            this.logger.logp(Level.INFO, "JPAExtender", "saveState", "Saved state to {0} and following bundles are yet to be enhanced: {1} ", new Object[]{state.getAbsolutePath(), this.printBundleIds()});
        }
        catch (Exception e) {
            this.logger.logp(Level.WARNING, "JPAExtender", "saveState", "Unable to store data. If you have intalled bundles that are yet to be enhanced, they won't be enhanced next time when server starts unless you update those bundles.", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private StringBuilder printBundleIds() {
        StringBuilder sb = new StringBuilder();
        for (long id : this.bundlesToBeEnhanced.keySet()) {
            sb.append(id).append(" ");
        }
        return sb;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EnhancerPolicy {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }
}

