/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.jpa.PersistenceUnitInfoImpl;

public class JPAJava2DBProcessor {
    private static final String TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    private static final String TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_NEW = "oracle.toplink.essentials.PersistenceProvider";
    private static final String ECLIPSELINK_PERSISTENCE_PROVIDER_CLASS_NAME = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final String CREATE_ONLY = "create-tables";
    private static final String DROP_AND_CREATE = "drop-and-create-tables";
    private static final String NONE = "none";
    private static final String DDL_BOTH_GENERATION = "both";
    private static final String DDL_DATABASE_GENERATION = "database";
    private static final String DDL_SQL_SCRIPT_GENERATION = "sql-script";
    private static final String SunAS9 = "SunAS9";
    private static final String TOPLINK_DDL_GENERATION = "toplink.ddl-generation";
    private static final String ECLIPSELINK_DDL_GENERATION = "eclipselink.ddl-generation";
    private static final String TOPLINK_DDL_GENERATION_MODE = "toplink.ddl-generation.output-mode";
    private static final String ECLIPSELINK_DDL_GENERATION_MODE = "eclipselink.ddl-generation.output-mode";
    private static final String TOPLINK_APP_LOCATION = "toplink.application-location";
    private static final String ECLIPSELINK_APP_LOCATION = "eclipselink.application-location";
    private static final String TOPLINK_CREATE_JDBC_DDL_FILE = "toplink.create-ddl-jdbc-file-name";
    private static final String ECLIPSELINK_CREATE_JDBC_DDL_FILE = "eclipselink.create-ddl-jdbc-file-name";
    private static final String TOPLINK_DROP_JDBC_DDL_FILE = "toplink.drop-ddl-jdbc-file-name";
    private static final String ECLIPSELINK_DROP_JDBC_DDL_FILE = "eclipselink.drop-ddl-jdbc-file-name";
    private static Logger logger = LogDomains.getLogger(JPAJava2DBProcessor.class, "javax.org.glassfish.persistence");
    private ProviderPropertyNamesHolder providerPropertyNamesHolder;
    private String ddlMode;
    private Java2DBProcessorHelper helper = null;

    public JPAJava2DBProcessor(Java2DBProcessorHelper helper) {
        this.helper = helper;
        this.helper.init();
    }

    public boolean isJava2DbPU(PersistenceUnitDescriptor bundle) {
        boolean userDropTables;
        String providerClassName = this.getProviderClassName(bundle);
        this.providerPropertyNamesHolder = new ProviderPropertyNamesHolder();
        if (TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_NEW.equals(providerClassName) || TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD.equals(providerClassName)) {
            this.providerPropertyNamesHolder.appLocation = TOPLINK_APP_LOCATION;
            this.providerPropertyNamesHolder.createJdbcDdlFile = TOPLINK_CREATE_JDBC_DDL_FILE;
            this.providerPropertyNamesHolder.dropJdbcDdlFile = TOPLINK_DROP_JDBC_DDL_FILE;
            this.providerPropertyNamesHolder.ddlGeneration = TOPLINK_DDL_GENERATION;
            this.providerPropertyNamesHolder.ddlGenerationMode = TOPLINK_DDL_GENERATION_MODE;
        }
        String ddlGenerate = this.getPersistencePropVal(bundle, this.providerPropertyNamesHolder.ddlGeneration, NONE);
        this.ddlMode = this.getPersistencePropVal(bundle, this.providerPropertyNamesHolder.ddlGenerationMode, DDL_BOTH_GENERATION);
        boolean userCreateTables = (ddlGenerate.equals(CREATE_ONLY) || ddlGenerate.equals(DROP_AND_CREATE)) && !this.ddlMode.equals(NONE);
        boolean createTables = this.helper.getCreateTables(userCreateTables);
        boolean bl = userDropTables = ddlGenerate.equals(DROP_AND_CREATE) && (this.ddlMode.equals(DDL_DATABASE_GENERATION) || this.ddlMode.equals(DDL_BOTH_GENERATION));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing request with create tables: " + createTables + ", drop tables: " + userDropTables);
        }
        if (!createTables && !userDropTables) {
            return false;
        }
        if (!this.isSupportedPersistenceProvider(bundle)) {
            if (this.helper.hasDeployCliOverrides()) {
                this.helper.logI18NWarnMessage("Java2DBProcessorHelper.nondefaultprovider", this.getProviderClassName(bundle), bundle.getName(), null);
            }
            return false;
        }
        this.helper.setProcessorType("JPA", bundle.getName());
        this.helper.setDropTablesValue(userDropTables, bundle.getName());
        this.helper.setCreateTablesValue(userCreateTables && !this.ddlMode.equals(DDL_SQL_SCRIPT_GENERATION), bundle.getName());
        String dataSourceName = PersistenceUnitTransactionType.JTA == PersistenceUnitTransactionType.valueOf(bundle.getTransactionType()) ? bundle.getJtaDataSource() : bundle.getNonJtaDataSource();
        this.helper.setJndiName(dataSourceName, bundle.getName());
        this.constructJdbcFileNames(bundle);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing request to create files - create file: " + this.helper.getCreateJdbcFileName(bundle.getName()) + ", drop  file: " + this.helper.getDropJdbcFileName(bundle.getName()));
        }
        this.addPropertiesToPU(bundle);
        return true;
    }

    private void constructJdbcFileNames(PersistenceUnitDescriptor parBundle) {
        String createJdbcFileName = this.getPersistencePropVal(parBundle, this.providerPropertyNamesHolder.createJdbcDdlFile, null);
        String dropJdbcFileName = this.getPersistencePropVal(parBundle, this.providerPropertyNamesHolder.dropJdbcDdlFile, null);
        if (null != createJdbcFileName && null != dropJdbcFileName) {
            return;
        }
        String filePrefix = Java2DBProcessorHelper.getDDLNamePrefix(parBundle.getParent().getParent());
        if (null == createJdbcFileName) {
            createJdbcFileName = filePrefix + '_' + parBundle.getName() + "_createDDL.jdbc";
        }
        if (null == dropJdbcFileName) {
            dropJdbcFileName = filePrefix + '_' + parBundle.getName() + "_dropDDL.jdbc";
        }
        this.helper.setCreateJdbcFileName(createJdbcFileName, parBundle.getName());
        this.helper.setDropJdbcFileName(dropJdbcFileName, parBundle.getName());
    }

    public void createTablesInDB() {
        this.helper.createOrDropTablesInDB(true, "JPA");
    }

    private void addPropertiesToPU(PersistenceUnitDescriptor puDescriptor) {
        this.addPropertyToDescriptor(puDescriptor, this.providerPropertyNamesHolder.appLocation, this.helper.getGeneratedLocation(puDescriptor.getName()));
        this.addPropertyToDescriptor(puDescriptor, this.providerPropertyNamesHolder.createJdbcDdlFile, this.helper.getCreateJdbcFileName(puDescriptor.getName()));
        this.addPropertyToDescriptor(puDescriptor, this.providerPropertyNamesHolder.dropJdbcDdlFile, this.helper.getDropJdbcFileName(puDescriptor.getName()));
    }

    private void addPropertyToDescriptor(PersistenceUnitDescriptor descriptor, String propertyName, String propertyValue) {
        String oldPropertyValue = descriptor.getProperties().getProperty(propertyName);
        if (null == oldPropertyValue) {
            descriptor.addProperty(propertyName, propertyValue);
        }
    }

    private String getPersistencePropVal(PersistenceUnitDescriptor parBundle, String propertyName, String defaultValue) {
        return parBundle.getProperties().getProperty(propertyName, defaultValue);
    }

    private boolean isSupportedPersistenceProvider(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        String providerClassName = this.getProviderClassName(persistenceUnitDescriptor);
        return providerClassName.equals(TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD) || providerClassName.equals(TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_NEW) || providerClassName.equals(ECLIPSELINK_PERSISTENCE_PROVIDER_CLASS_NAME);
    }

    private File getDDLFile(PersistenceUnitDescriptor bundle, String fileName, boolean create) {
        String appLocation = this.getPersistencePropVal(bundle, this.providerPropertyNamesHolder.appLocation, this.helper.getGeneratedLocation(bundle.getName()));
        this.helper.setGeneratedLocation(appLocation, bundle.getName());
        return this.helper.getDDLFile(appLocation + File.separator + fileName, create);
    }

    private String getProviderClassName(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        return PersistenceUnitInfoImpl.getPersistenceProviderClassNameForPuDesc(persistenceUnitDescriptor);
    }

    private static class ProviderPropertyNamesHolder {
        String appLocation = "eclipselink.application-location";
        String createJdbcDdlFile = "eclipselink.create-ddl-jdbc-file-name";
        String dropJdbcDdlFile = "eclipselink.drop-ddl-jdbc-file-name";
        String ddlGeneration = "eclipselink.ddl-generation";
        String ddlGenerationMode = "eclipselink.ddl-generation.output-mode";

        private ProviderPropertyNamesHolder() {
        }
    }
}

